//-----------------------------------------------------------------------------
#include "typedefs.h"
#include "application.h"
#include "spi_master.h"
#include "ad7719_adc.h"
#include "atmega_adc.h"    
#include "usart.h"
#include "macros.h"
#include "interpol.h"
#include "w5100_spi_interface.h"
#include <avr/interrupt.h>
#include <avr/wdt.h>
#include <stdlib.h>
//-----------------------------------------------------------------------------
// definition of some functions:
// these function are implemented in this file, this is not doog coding style.
// sooner or later, they will be moved into more apropriate files.
U08	increase_adc (U08 channel);
U08	increase_ad7719 (U08 channel);
void Set_V_Muxer (U08 channel);
void Set_T_Muxer(U08 channel);
void talk(void);// never used up to now.
void ad7719_output(U08 channel, U32 data);
void adc_output(U08 channel, U08 data);
void adc_output_all();
void parse(); //doesn't do anything at the moment
void check_if_measured_all() ;
void print_ad7719_nicely();
void print_adc_nicely();

// end of function definition:
//-----------------------------------------------------------------------------

// MAIN WORKFLOW GLOBAL VARIABLES
	bool verbose;
	bool heartbeat_enable;

// USART global variables
	U08 usart_rx_buffer[USART_RX_BUFFER_SIZE];
	U08 usart_tx_buffer[USART_TX_BUFFER_SIZE];
	U08 usart_received_chars;
	U08 usart_rx_buffer_index = 0;
	U08 usart_tx_buffer_index = 0;
  	U08 usart_last_char; 					// last received char

// USART FLAGS
	bool usart_tx_buffer_overflow = false;	// true if usart_tx_buffer was full.
	bool usart_rx_ready = false;			// EOL was received, parser needs to be called
	
// TIMER global variable
	volatile U32 local_ms = 0;

// AD7719 global variables
	#define TEMP_CHANNELS 64
	#define CHANNEL_BITMAP 8
	#define AD7719_READINGS_UNTIL_SETTLED 5 // bei3:480ms
	U32 ad7719_values[TEMP_CHANNELS];
	U08 ad7719_enables[CHANNEL_BITMAP];
	U08 ad7719_channels_ready[CHANNEL_BITMAP];
	U08 ad7719_readings_since_last_muxing = 0;
	U08 ad7719_current_channel = 0;
	U32 ad7719_current_reading = 0;
	bool ad7719_measured_all = false;
	
// ATMEGA ADC global variables
	#define V_CHANNELS 40
	#define I_CHANNELS 40
	#define H_CHANNELS 4
	#define V_BITMAP 5
	#define I_BITMAP 5
	#define H_BITMAP 1
	#define ADC_READINGS_UNTIL_SETTLED 1
	U08 adc_values[V_CHANNELS + I_CHANNELS + H_CHANNELS]; // stores measured voltage in steps of 16mV
	U08 adc_enables[V_BITMAP + I_BITMAP + H_BITMAP];
	U08 adc_channels_ready[V_BITMAP + I_BITMAP + H_BITMAP];
	U08 adc_readings_since_last_muxing = 0;
	U08 adc_current_channel = 0;
	U08 adc_current_reading = 0;
	bool adc_measured_all = false;

	bool once_told_you = true;
	bool debug_mode = false;

//-----------------------------------------------------------------------------
//   M A I N    ---   M A I N    ---   M A I N    ---   M A I N    ---  M A I N    
//-----------------------------------------------------------------------------
int main(void)
{
	app_init();		  // Setup: Watchdog and I/Os
	usart_init();		// Initialize serial interface   
	spi_init(); 		// Initialize SPI interface as master
	ad7719_init(); 		// Initialize AD7719 ADC as SPI slave 
	atmega_adc_init();

// TIMER2 is used as local clock:
// configure timer 2
	TCCR2 = (1<<WGM21); // CTC Modus
	TCCR2 |= (1<<CS21) | (1<<CS20); // Prescaler 64 --> counts up every 8us
	OCR2 = 125-1; 					// --> output compare interrupt occurs every 125 x 8us = 1ms
	// Compare Interrupt erlauben
	TIMSK |= (1<<OCIE2);

  //  Enable interrupts
  sei();              

  PORTB &= ~(1<<PB2);
  
for ( U08 i=0; i<CHANNEL_BITMAP; ++i ) {
	ad7719_enables[i]=0x00;
	ad7719_channels_ready[i]=0;
	}
	ad7719_enables[0]=0x01;
for ( U08 i=0; i<V_BITMAP + I_BITMAP; ++i ) {
	adc_enables[i]=0xFF;
	adc_channels_ready[i]=0;
}
	adc_enables[V_BITMAP + I_BITMAP + H_BITMAP -1] = 0x0F;
	adc_channels_ready[V_BITMAP + I_BITMAP + H_BITMAP -1]=0;

	static U08 welcome[]="\n\nwelcome to FACT FSC commandline interface v0.4\nDN 17.03.2011\nready?";
	usart_write_str(welcome);


//MAIN LOOP
while (1)
{

	//IF one of the ADC measured all channels, we wanted to know.
	check_if_measured_all();
	
	if (ad7719_measured_all && adc_measured_all && !once_told_you)
	{
		adc_output_all();
		once_told_you = true;
	}
//----------------------------------------------------------------------------

	if (heartbeat_enable) PORTB ^= (1<<PB3); // toggle Out2_spare --> heartbeat
//----------------------------------------------------------------------------
	//IF we need to send away one byte, and ready to send

	if ( (usart_tx_buffer_index > 0) && (UCSRA & (1<<UDRE)) ) { 
		UDR = usart_tx_buffer[0];
		// THis is shit
		for (U08 i=0 ; i < USART_TX_BUFFER_SIZE; ++i) {
			usart_tx_buffer[i] = usart_tx_buffer[i+1];
		}
		usart_tx_buffer_index--;
	}
//----------------------------------------------------------------------------

	//IF we just received one byte, and there is enough space in the RX_buffer
	if ( (UCSRA & (1<<RXC)) && (usart_rx_buffer_index < USART_RX_BUFFER_SIZE) ){
		usart_last_char = UDR;
		if (usart_last_char == '\n'){ // if EOL was received
			usart_rx_ready = true;
		}else {
		usart_rx_buffer[usart_rx_buffer_index] = usart_last_char;
		usart_rx_buffer_index++;
		}
		// here is still something strange .... better send an enter automatically
	} else if (UCSRA & (1<<RXC)) { // if there is no scace in the buffer; read anyway.
		usart_last_char = UDR;
		usart_rx_buffer_index =0;
	}
//----------------------------------------------------------------------------

	//IF USART DOR bit is set, PC is sending data to fast!!!
	if ( UCSRA & (1<<DOR) ){
		// flush TX_buffer and write warning message in
		// maybe even switch off every measurement. ?
	}
//----------------------------------------------------------------------------

	//IF TX_BUFFER was overrun.	
	if (usart_tx_buffer_overflow) {
		// flash TX_buffer and write warning message in
		// maybe even switch off every measurement. ?
		//
		// this should only happen, in verbose mode and with low baudrates.
	}
//----------------------------------------------------------------------------
	
	//IF one command was received. 
	//	-It is not allowed to send more than one command between two '\n'
	if (usart_rx_ready){ 
		parse();
		usart_rx_buffer_index = 0;
		usart_rx_ready = false;
	}
//----------------------------------------------------------------------------

	//IF ATmega internal ADC did finish a conversion --every 200us
	if ( (ADCSRA & (1<<ADIF)) && !adc_measured_all) {
		adc_current_reading = ADCH;
		if (adc_readings_since_last_muxing == ADC_READINGS_UNTIL_SETTLED) {
			adc_values[adc_current_channel] = adc_current_reading;
			adc_readings_since_last_muxing=0;
			// note that this channel is ready, now and 
			//adc_output(adc_current_channel, adc_current_reading);
			// proceed to the next enabled channel.
			adc_channels_ready[adc_current_channel/8] |= (1<<(adc_current_channel%8));
			adc_current_channel = increase_adc (adc_current_channel);
			Set_V_Muxer(adc_current_channel);
			_delay_ms(10);
		} else { // the ADC did not settle yet, we discard the reading
			++adc_readings_since_last_muxing;
			// current reading is not used for anything else
		}
	}
//----------------------------------------------------------------------------

	//IF AD7719 ADC just finished a conversion -- every 60ms
	
	if (AD7719_IS_READY() && !ad7719_measured_all) {
			ad7719_current_reading = read_adc(); // --takes at 4MHz SCLK speed about 6us
		// AD7719 is only read out if settled. saves time.	
		if (ad7719_readings_since_last_muxing == AD7719_READINGS_UNTIL_SETTLED) {
			ad7719_values[ad7719_current_channel] = ad7719_current_reading;
			ad7719_readings_since_last_muxing=0;
			if (debug_mode) {
				usart_write_U32_hex(ad7719_current_reading);
				usart_write_char('\n');
				usart_write_char('\n');
			}
			// now prepare the data to be send away via USART.
			//ad7719_output(ad7719_current_channel, ad7719_current_reading);
			// note that this channel is ready, now and 
			// proceed to the next enabled channel.
			ad7719_channels_ready[ad7719_current_channel/8] |= (1<<(ad7719_current_channel%8));
			ad7719_current_channel = increase_ad7719 (ad7719_current_channel);
			Set_T_Muxer(ad7719_current_channel);
		} else { // the AD7719 did not settle yet, we discard the reading
			++ad7719_readings_since_last_muxing;
			if (debug_mode) {
				usart_write_U32_hex(ad7719_current_reading);
				usart_write_char('\n'); 
			}

			// current reading is not used for anything else
		}
	}

//----------------------------------------------------------------------------
/*
	if (verbose == true)
		// talk() was just defined so the 
		// code is not at this place ... look down.
		talk();
*/

} // end of MAIN LOOP
//-----------------------------------------------------------------------------
//    E N D     E N D     E N D     E N D     E N D     E N D     E N D     
//-----------------------------------------------------------------------------



float resistance;

U08 SA_mux_val = 0x00;
U08 SB_mux_val = 0x00;

//U08 counter = 0;
U08 Res_or_Volt = 0x00;


while (TRUE)
	 {


  ++Res_or_Volt;
  if (Res_or_Volt <= 64){


		// if USART data arrives. i.e. data via USB
		// the usart_rx_ready flag is set TRUE
		// now process the incoming data which is stored in 
		// U08 usart_rx_buffer[USART_RX_BUFFER_SIZE]
		// and tell the USART interface, it may receive new data
		// by setting the usart_rx_ready flag FALSE again
		++SA_mux_val;
		if (Res_or_Volt == 1) SB_mux_val = 16;
		else if (SA_mux_val == 64) SA_mux_val = 32;
		else if (SA_mux_val == 16) SA_mux_val = 48;
		else if (SA_mux_val == 32) SA_mux_val = 0;
		PORTA = (SA_mux_val & 0x3F); 
				
//		usart_write_str((pU08)"SA:");
		usart_write_U08(SA_mux_val,2);
		usart_write_str((pU08)" Sensor:");
		usart_write_U08((SA_mux_val % 8)+1,2);
		usart_write_str((pU08)" an Temperatur_");
		switch (SA_mux_val / 8)
		{
			case 0: usart_write_str((pU08)"C");
			break;
			case 1: usart_write_str((pU08)"D");
			break;
			case 2: usart_write_str((pU08)"A");
			break;
			case 3: usart_write_str((pU08)"B");
			break;
			case 4: usart_write_str((pU08)"G");
			break;
			case 5: usart_write_str((pU08)"H");
			break;
			case 6: usart_write_str((pU08)"E");
			break;
			case 7: usart_write_str((pU08)"F");
			break;
			default: usart_write_str((pU08)"alarm!");
			break;
		}
//		usart_write_str((pU08)"\n");
		usart_write_str((pU08)"  ");


		startconv(0);

	
		while (!AD7719_IS_READY())
		{
		// just wait until ADC is redy -- really bad code here!
		}	    			
 		
		resistance = getresistance();
							//Start a new A/D Conversion
    	//temp = 	readandsendtemp();
		//adcword = getadc();
		
		//temperature = gettemp();
		usart_write_str((pU08)"R:");
		usart_write_float(resistance,3,4);
		usart_write_str((pU08)"kOhm ");
		
		//_delay_ms(200);

		startconv(0);

		while (!AD7719_IS_READY())
		{
		// just wait until ADC is redy -- really bad code here!
		}	    			
   									//Start a new A/D Conversion
    	//temp = 	readandsendtemp();
		//adcword = getadc();
		resistance = getresistance();
		//temperature = gettemp();
		usart_write_str((pU08)"R:");
		usart_write_float(resistance,3,4);
		usart_write_str((pU08)"kOhm ");			

//usart_write_str((pU08)"\n");
switch (SA_mux_val)
		{
			case 7: usart_write_str((pU08)"\n\n");
			break;
			case 15: usart_write_str((pU08)"\n\n");
			break;
			case 23: usart_write_str((pU08)"\n\n");
			break;
			case 31: usart_write_str((pU08)"\n\n");
			break;
			case 39: usart_write_str((pU08)"\n\n");
			break;
			case 47: usart_write_str((pU08)"\n\n");
			break;
			case 55: usart_write_str((pU08)"\n\n");
			break;
			case 63: usart_write_str((pU08)"\n\n");
			break;
			default: usart_write_str((pU08)"\n");
			break; 
		}
SB_mux_val = 0;
}
else if (Res_or_Volt == 148) Res_or_Volt = 0;
else {


		++SB_mux_val;		
		if (SB_mux_val == 84) SB_mux_val = 0;
		else if (SB_mux_val == 74) SB_mux_val = 82;
		else if (SB_mux_val == 82) SB_mux_val = 72;
		else if (SB_mux_val == 72) SB_mux_val = 74;
		else if (SB_mux_val == 48) SB_mux_val = 64;
		else if (SB_mux_val == 64) SB_mux_val = 32;
		else if (SB_mux_val == 32) SB_mux_val = 48;
		PORTC = (SB_mux_val & 0x7F);
 



usart_write_str((pU08)"8bit-ADC: ");

if (SB_mux_val < 64)
{
		switch (SB_mux_val / 16)
		{
			case 0: usart_write_str((pU08)"voltage_A: ");
			break;
			case 1: usart_write_str((pU08)"voltage_B: ");
			break;
			case 2: usart_write_str((pU08)"voltage_D: ");
			break;
			case 3: usart_write_str((pU08)"voltage_C: ");
			break;
		}

		if (SB_mux_val % 2 == 0) {
			usart_write_str((pU08)"U");
			usart_write_U08( (SB_mux_val%16)/2 , 1 );
		} else {
			usart_write_str((pU08)"I");
			usart_write_U08( ((SB_mux_val%16)-1)/2 , 1 );
		}


} else {


	if (SB_mux_val < 72)  {
		usart_write_str((pU08)"voltage_E: ");
		if (SB_mux_val % 2 == 0) {
			usart_write_str((pU08)"U");
			usart_write_U08( (SB_mux_val%8)/2 , 1 );
		} else {
			usart_write_str((pU08)"I");
			usart_write_U08( ((SB_mux_val%8)-1)/2 , 1 );
		}

	}
else if (SB_mux_val == 72) usart_write_str((pU08)"humidity_A: H0");
else if (SB_mux_val == 73) usart_write_str((pU08)"humidity_A: H1");

else if (SB_mux_val < 82) {
		usart_write_str((pU08)"voltage_F: ");
		if (SB_mux_val % 2 == 0) {
			usart_write_str((pU08)"U");
			usart_write_U08( ((SB_mux_val-2)%8)/2 , 1 );
		} else {
			usart_write_str((pU08)"I");
			usart_write_U08( (((SB_mux_val-2)%8)-1)/2 , 1 );
		}

	}
else if (SB_mux_val == 82) usart_write_str((pU08)"humidity_B: H0");
else if (SB_mux_val == 83) usart_write_str((pU08)"humidity_B: H1");
}

for (U08 counter = 0; counter < 1; ++counter) {
	while (ADCSRA & (1<<ADSC) );    // wait until internal ADC is ready
	float voltage;
	voltage = ( (float)ADCH ) / 256 * 4.096;
	usart_write_str((pU08)" ");
	usart_write_float(voltage,3,4);


}
//usart_write_str((pU08)"\n");

switch (SB_mux_val)
		{
			case 15: usart_write_str((pU08)"\n\n");
			break;
			case 31: usart_write_str((pU08)"\n\n");
			break;
			case 47: usart_write_str((pU08)"\n\n");
			break;
			case 63: usart_write_str((pU08)"\n\n");
			break;
			case 71: usart_write_str((pU08)"\n\n");
			break;
			case 73: usart_write_str((pU08)"\n\n");
			break;
			case 81: usart_write_str((pU08)"\n\n");
			break;
			case 83: usart_write_str((pU08)"\n\n");
			break;
			default: usart_write_str((pU08)"\n");
			break; 
		}

SA_mux_val = 15;
}		
	/*	
		if ( usart_rx_ready == TRUE )
		{
			//understand what it means and react
			
			switch (usart_rx_buffer[0])
			{
				
				case 'h':
				{
					// toggle the heartbeat mode on or off.
					heartbeat_enable = !heartbeat_enable;
					break;
				}
				case 'a':
				{
					// conduct adc - AD7719 SPI interface test
					
					break;
				}
				case 'e':
				{
					// conduct ethernet module SPI interface test
					strtol((char*) usart_rx_buffer+1, NULL, 0);
					break;
				}

				default:
				{
					usart_write_str((pU08)"? you wrote: ");
					usart_write_str((pU08)usart_rx_buffer);
					usart_write_str((pU08)"\n");
					break;
				}
			}
			
			heartbeat_enable = !heartbeat_enable;
			usart_rx_ready = FALSE;
		}
*/
// das ist ein paar schritte zu frh.
// erstmal mssen die interfaces getestet werden.
/*

		for (U08 i = 0; i<16; i++)
	  	{ 
			
	   		if((~PIND) & 0x08)  // PD4 is #ADC_RDY input. Inverted logic! if PD4=0 this evaluates to true					
	    	{		
				PORTA = (PORTA & 0xF0) | ((i) & 0x0F); 	// switch muxer
		   		startconv();							//Start a new A/D Conversion
		    	//temp = 	readandsendtemp();
				//adcword = getadc();
				//resistance = getresistance();
				temperature = gettemp();
				usart_write_float(temperature,2,4);
				usart_write_str((pU08)"\t");

			} // end of if adc ready
			else
			{
			i--;
			}
		} // end of for loop over 16 channels
		usart_write_crlf();

*/

 	}	// end of infinite while loop
} // end of main()


ISR (TIMER2_COMP_vect)
{
 ++local_ms;
}


U08	increase_adc (U08 channel){
bool valid_ch_found = false;
	while (!valid_ch_found){
	
		// just increase 'channel' or turnover to zero.
		++channel;
		if (channel == V_CHANNELS + I_CHANNELS + H_CHANNELS)
			channel = 0;
	
		// check if this channel is enabled in the bitmap
		if (adc_enables[channel/8] & (1<<channel%8))
			valid_ch_found = true;
	} // end of while loop
	return channel;
} // end if increase_adc;

U08	increase_ad7719 (U08 channel){
bool valid_ch_found = false;
	while (!valid_ch_found){
	
		// just increase 'channel' or turnover to zero.
		++channel;
		if (channel == TEMP_CHANNELS)
			channel = 0;
	
		// check if this channel is enabled in the bitmap
		if (ad7719_enables[channel/8] & (1<<channel%8))
			valid_ch_found = true;
	} // end of while loop
	return channel;
} // end if increase_adc;


// Sets voltage Muxer to current channel
// this is a Muxing, and therefor the adc might need some time to settle.
// Since there are:
//	- 40 voltage monitor channels
// 	- 40 current monitor channels
// 	- 4 humidity monitor channels
// the muxer is set as follows.
// channel 00..39 --> looking at the voltage channels
// channel 40..79 --> looking at the current channels
// channel 80..83 --> looking at the humidities
void Set_V_Muxer (U08 channel){
U08 SB = 0;
	// voltages
	if (channel < 40) {
		if (channel < 36)
			SB = channel*2;
		else
			SB = (channel+1)*2;
	}
	// currents
	else if (channel < 80) {
		channel -= 40;
		if (channel < 36)
			SB = channel*2+1;
		else
			SB = (channel+1)*2+1;
	}
	// humidities
	else if (channel < 84) {
		channel -= 80;
		switch (channel) {
			case 0:
				SB = 0x48; //0100.1000
				break;
			case 1:
				SB = 0x49; //0100.1001
				break;
			case 2:
				SB = 0x58; //0101.0010
				break;
			case 3:
				SB = 0x58; //0101.0011
				break;
		} // end of switch-case
	} // end of if (channel < some_number)

	PORTC = (PORTC & 0x80) | (0x7F & SB); // Here the muxer is switched.
}

void Set_T_Muxer(U08 channel) {
U08 SA = 0x00;

	switch (channel/16) {
		case 0:
			SA |= 1<<4; // 0001.0000
			break;
		case 1:
			break;		// 0000.0000
		case 2:
			SA |= (1<<4)|(1<<5); // 0011.0000
			break;
		case 3:
			SA |= 1<<5;  // 0010.0000
			break;
	}
	
	SA =  SA | (channel%16);
	
	PORTA = (PORTA & 0xC0) | (0x3F & SA); // Here the muxer is switched.
}

void talk(void){

/*
// makes no sense to declare the 'new_measurement' vars here
// but maybe the whole function will be deleted, anyway ...
// I'm thinking about it.
bool ad7719_new_measurement;
bool atmega_adc_new_measurement;
	if (verbose == true) { 
		// somebody wants to read every new measured value, even if it is trash!
			// do not actually send away data !
			// just prepare the data to be send away.
		if ( ad7719_new_measurement  == true ) {
			add_str_to_output_stream("ad7719: reading:");
			add_dec_to_output_stream(reading_since_last_muxer_switch,1);
			add_str_to_output_stream(" temperature channel:");
			add_dec_to_output_stream(current_temperature_channel,2);
			add_str_to_output_stream(" = ");
			add_float_to_output_stream(current_ad7719_value,4,3);
			add_str_to_output_stream("\n");
		}
		if (atmega_adc_new_measurement == true) {
			add_str_to_output_stream("atmega_adc: reading:");
			add_dec_to_output_stream(reading_since_last_muxer_switch,1);
			add_str_to_output_stream(" voltage channel:");
			add_dec_to_output_stream(current_voltage_channel,2);
			add_str_to_output_stream(" = ");
			add_float_to_output_stream(current_atmega_adc_value,4,3);
			add_str_to_output_stream("\n");
		}
	} // end of: if verbose
*/
} // end of talk()

// this function generates some output.
void ad7719_output(U08 channel, U32 data) {
float value = 0;
	usart_write_str((pU08)"R:"); //R for resistance
	usart_write_char('A'+channel/8); // Letters A,B,C,D,E,F,G,H
	//usart_write_char(' '); 
	usart_write_U08(channel%8+1,1); // Numbers 1...8
	usart_write_char(':'); 
	

	value = (6.25 * data) / ((U32)1 << 25);
	usart_write_float(value, 3,6);
	//usart_write_U32_hex(data); //data


}

void adc_output(U08 channel, U08 data) {

//	if (channel < 40) 
//		usart_write_str((pU08)"V:"); 
//	else if (channel < 80)
//		usart_write_str((pU08)"I:"); 
//	else if (channel < 84)
//		usart_write_str((pU08)"H:"); 

	if (channel <80)
	{
		switch ((channel%40)/4) {
			case 0:
			case 1:
				usart_write_char('A'); 
			break;
			case 2:
			case 3:
				usart_write_char('B');
				break;
			case 4:
			case 5:
				usart_write_char('C'); 
				break;
			case 6:
			case 7:
				usart_write_char('D'); 
				break;
			case 8:
				usart_write_char('E');
				break;
			case 9:
				usart_write_char('F');
				break;
			default:
				usart_write_char('?');
				break;
			}
	}
	else // channel 80..83
	{
		usart_write_char('H');
	}
	//usart_write_char(' '); 
	
	if ( (channel%40)/4 == 9)
		usart_write_U08((channel)%4+1,1); // Numbers 1...4
	else
		usart_write_U08((channel)%8+1,1); // Numbers 1...8
	
	
	//usart_write_U08(channel,2); // Numbers 1...8
	usart_write_char(':'); 
	usart_write_U16((U16)data*16, 4); //data
}


void adc_output_all() {
	print_adc_nicely();
	print_ad7719_nicely();
}


// this method parses the data, 
// which came in via USART
// later it might as well parse the data from ethernet.
void parse() {
U08 command = usart_rx_buffer[0];
// look at first byte
// I hope, I can manage to use one byte commands
	usart_rx_buffer[USART_RX_BUFFER_SIZE-1] = 0;
	usart_write_str((pU08)"got:");
	usart_write_str(usart_rx_buffer);
	
	

	switch (command) {
		case 'E': 	// AD7719 enable bitmaps may be set
		usart_write_str((pU08)"\n set enable bits of AD7719 Port ");
			if ((usart_rx_buffer_index>=5) && 
			(usart_rx_buffer[2] >= 'A' && usart_rx_buffer[2] <= 'H'))
			{
			usart_write_char(usart_rx_buffer[2]);
			usart_write_str((pU08)" to ");
			usart_write_U08_hex(usart_rx_buffer[4]);
			usart_write_char('\n');
				ad7719_enables[usart_rx_buffer[2]-'A']=usart_rx_buffer[4];
				ad7719_channels_ready[usart_rx_buffer[2]-'A']=0x00;
			}
			else if  ((usart_rx_buffer_index=3) && 
			(usart_rx_buffer[1] >= 'A' && usart_rx_buffer[1] <= 'H'))
			{
				usart_write_char(usart_rx_buffer[1]);
				if (usart_rx_buffer[2]!='0') {
					usart_write_str((pU08)" to 0xFF\n");
					ad7719_enables[usart_rx_buffer[1]-'A']=0xFF;
				} else
				{
					usart_write_str((pU08)" to 0x00\n");
					ad7719_enables[usart_rx_buffer[1]-'A']=0x00;
				}
				ad7719_channels_ready[usart_rx_buffer[1]-'A']=0x00;	
			}
			else
			{
				usart_write_str((pU08)"\n something wrong\n");
				usart_write_str((pU08)"usart_rx_buffer_index: ");
				usart_write_U08(usart_rx_buffer_index, 3);
				usart_write_str((pU08)"\n usart_rx_buffer[2]: ");
				usart_write_char(usart_rx_buffer[2]);
				usart_write_str((pU08)"\n usart_rx_buffer[4]: ");
				usart_write_U08_hex(usart_rx_buffer[4]);
				usart_write_char('\n');
			}
			break;
		case 'e':	// ATmega internal ADC enable bitmaps may be set
			usart_write_str((pU08)"\n setting ADC enable registers all");
			if (usart_rx_buffer[1] == '0'){
				usart_write_str((pU08)"OFF \n");
				for ( U08 i=0; i<V_BITMAP + I_BITMAP; ++i ) {
				adc_enables[i]=0x00;
				adc_channels_ready[i]=0;
			}
				adc_enables[V_BITMAP + I_BITMAP + H_BITMAP -1] = 0x00;
				adc_channels_ready[V_BITMAP + I_BITMAP + H_BITMAP -1]=0;
			} else {
				usart_write_str((pU08)"ON\n");
				for ( U08 i=0; i<V_BITMAP + I_BITMAP; ++i ) {
				adc_enables[i]=0xFF;
				adc_channels_ready[i]=0;
			}
				adc_enables[V_BITMAP + I_BITMAP + H_BITMAP -1] = 0x0F;
				adc_channels_ready[V_BITMAP + I_BITMAP + H_BITMAP -1]=0;
			}
			
			
			break;
		case 'h':
			usart_write_str((pU08)"\nheartbeat ");
			heartbeat_enable = true;
			if (usart_rx_buffer[1] == '0'){
				heartbeat_enable = false;
				usart_write_str((pU08)"off\n");
			} else {
				usart_write_str((pU08)"on\n");
			}
			break;
		case 'G': 			// GET the Temperature channels, which are enabled
			once_told_you = false;
			for ( U08 i=0; i<CHANNEL_BITMAP; ++i ) {
				ad7719_channels_ready[i]=0;
			}
			break;
		case 'g':			// GET the voltage/current/humidity channels, which are enabled
			once_told_you = false;
			for ( U08 i=0; i<V_BITMAP + I_BITMAP + H_BITMAP; ++i ) {
				adc_channels_ready[i]=0;
			}
			break;

		case 'Q':
			for (U08 i=0; i< TEMP_CHANNELS;++i) {
				if (i%8 == 0) usart_write_char('\n');
				usart_write_U32_hex(ad7719_values[i]);
				usart_write_char('\t');
			}
			usart_write_char('\n');
			break;

		case 'q':
			// output:	U08 adc_values[V_CHANNELS + I_CHANNELS + H_CHANNELS];
			for (U08 i=0; i< V_CHANNELS + I_CHANNELS + H_CHANNELS;++i) {
				if (i%8 == 0) usart_write_char('\n');
				usart_write_U16(adc_values[i]*16, 5);
				usart_write_char('\t');
			}
			usart_write_char('\n');
			break;

		case 'P':
			print_ad7719_nicely();
			break;
			
		case 'p':
			print_adc_nicely();
			break;



		case 's':
			
			usart_write_str((pU08)"adc status:\n");
			for (U08 i=0; i< V_BITMAP + I_BITMAP + H_BITMAP;++i) {
				usart_write_U08_bin(adc_enables[i]);	
				usart_write_char(' ');
			}
			usart_write_char('\n');
			for (U08 i=0; i< V_BITMAP + I_BITMAP + H_BITMAP;++i){
				usart_write_U08_bin(adc_channels_ready[i]);
				usart_write_char(' ');
			}
			usart_write_char('\n');
		
			usart_write_str((pU08)"ad7719 status:\n");
			for (U08 i=0; i< CHANNEL_BITMAP;++i) {
				usart_write_U08_bin(ad7719_enables[i]);
				usart_write_char(' ');
			}
			usart_write_char('\n');
			for (U08 i=0; i< CHANNEL_BITMAP;++i){
				usart_write_U08_bin(ad7719_channels_ready[i]);
				usart_write_char(' ');
			}
			usart_write_char('\n');
				
			usart_write_str((pU08)"time:");
			usart_write_float((float)local_ms/1000 , 1,7);
			usart_write_str((pU08)" sec.\n");
			
			usart_write_str((pU08)"adc measured all: ");
			if (adc_measured_all)
				usart_write_str((pU08)" true\n");
			else
				usart_write_str((pU08)"false\n");

			usart_write_str((pU08)"ad7719 measured all: ");
			if (ad7719_measured_all)
				usart_write_str((pU08)" true\n");
			else
				usart_write_str((pU08)"false\n");
			
			usart_write_str((pU08)"adc current channel:");
			usart_write_U08(adc_current_channel,2);
			usart_write_char('\n');
			
			usart_write_str((pU08)"ad7719 current channel:");
			usart_write_U08(ad7719_current_channel,2);
			usart_write_char('\n');
			break;	

		case 'd':
			usart_write_str((pU08)"\ndebug mode ");
			debug_mode = true;
			if (usart_rx_buffer[1] == '0'){
				debug_mode = false;
				usart_write_str((pU08)"off\n");
			} else {
				usart_write_str((pU08)"on\n");
			}
			break;		
	}
	
	
	usart_write_str((pU08)"\nready?");
	for (U08 i=0; i<USART_RX_BUFFER_SIZE; ++i)
		usart_rx_buffer[i] = 0;
}

void check_if_measured_all() {
	adc_measured_all = true;
	for ( U08 i=0; i<V_BITMAP + I_BITMAP + H_BITMAP; ++i ) {
		if ((adc_enables[i] ^ adc_channels_ready[i]) != 0x00) {
			adc_measured_all = false;
			break;
		}
	}
	ad7719_measured_all = true;
	for ( U08 i=0; i<CHANNEL_BITMAP; ++i ) {
		if ((ad7719_enables[i] ^ ad7719_channels_ready[i]) != 0x00) {
			ad7719_measured_all = false;
			break;
		}
	}


}

void print_ad7719_nicely() 
{
	float value;

	usart_write_str((pU08)"\n printing measured resistance in kohms:\n");

for (U08 i=0; i< TEMP_CHANNELS;++i) {
	if (i%8 == 0) usart_write_char('\n');

	// print channel name:
	usart_write_str((pU08)"R:"); //R for resistance
	usart_write_char('A'+i/8); // Letters A,B,C,D,E,F,G,H
	//usart_write_char(' '); 
	usart_write_U08(i%8+1,1); // Numbers 1...8
	usart_write_char(':'); 

	// check if this channel is enabled in the bitmap
	if (ad7719_enables[i/8] & (1<<i%8))
	{
		value = (6.25 * 1.024 * ad7719_values[i]) / ((U32)1 << 25);
		usart_write_float(value, 3,6);
		//usart_write_U32(ad7719_values[i],8);
		//usart_write_U32_hex(data); //data
		usart_write_str((pU08)"  ");	
	} else {
		usart_write_str((pU08)"        ");	
	}
	//usart_write_char('\n');
}
}

void print_adc_nicely() {
	usart_write_str((pU08)"\n printing voltages in mV:\n");
	// output:	U08 adc_values[V_CHANNELS + I_CHANNELS + H_CHANNELS];
	for (U08 i=0; i< V_CHANNELS + I_CHANNELS + H_CHANNELS;++i) {
	if (i%8 == 0) usart_write_char('\n');

	if (i==0)
		usart_write_str((pU08)"voltages:\n");
	if (i==40)
		usart_write_str((pU08)"currents in mV :-) :\n");
	if (i==80)
		usart_write_str((pU08)"humiditiesin mV :-) :\n");


		
		adc_output(i, adc_values[i]);
		usart_write_str((pU08)"   ");
	}
	usart_write_char('\n');
}
