----------------------------------------------------------------------------------
-- Company:        ETH Zurich, Institute for Particle Physics
-- Engineer:       Q. Weitzel
-- 
-- Create Date:    15:56:13 02/28/2011 
-- Design Name: 
-- Module Name:    FTM_central_control - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description:    Central FSM for FTM firmware
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

library ftm_definitions;
USE ftm_definitions.ftm_array_types.all;
USE ftm_definitions.ftm_constants.all;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity FTM_central_control is
  port(
    clk                  : IN  std_logic;
    clk_scaler           : IN  std_logic;
    new_config           : IN  std_logic;
    config_started       : OUT std_logic := '0';
    config_started_ack   : IN  std_logic;
    config_start_eth     : OUT std_logic := '0';
    config_started_eth   : IN  std_logic;
    config_ready_eth     : IN  std_logic;
    config_start_ftu     : OUT std_logic := '0';
    config_started_ftu   : IN  std_logic ;
    config_ready_ftu     : IN  std_logic ;
    ping_ftu_start       : IN  std_logic;
    ping_ftu_started     : OUT std_logic := '0';
    ping_ftu_ready       : OUT std_logic := '0';
    ping_ftu_start_ftu   : OUT std_logic := '0';
    ping_ftu_started_ftu : IN  std_logic;
    ping_ftu_ready_ftu   : IN  std_logic;
    rates_ftu            : OUT std_logic := '0';
    rates_started_ftu    : IN  std_logic;
    rates_ready_ftu      : IN  std_logic;
    prescaling_FTU01     : IN  std_logic_vector(7 downto 0);
    dd_send              : OUT std_logic := '0';
    dd_send_ack          : IN  std_logic;
    dd_send_ready        : IN  std_logic;
    config_start_cc      : out std_logic := '0';
    config_started_cc    : in  std_logic;
    config_ready_cc      : in  std_logic
  );
end FTM_central_control;

architecture Behavioral of FTM_central_control is

  signal reset_scaler_sig  : std_logic := '0';
  signal scaler_counts_sig : integer := 0;
  signal scaler_period_sig : integer range 0 to 128 * (LOW_FREQUENCY / SCALER_FREQ_DIVIDER) := 128 * (LOW_FREQUENCY / SCALER_FREQ_DIVIDER);
  
  type state_central_proc_type is (CP_INIT,
                                   CP_CONFIG_START, CP_CONFIG, CP_CONFIG_01,
                                   CP_CONFIG_CC, CP_CONFIG_CC_01,
                                   CP_CONFIG_FTU, CP_CONFIG_FTU_01, CP_CONFIG_SCALER,
                                   CP_IDLE, CP_PING, CP_READ_RATES, CP_READ_RATES_01,
                                   CP_SEND_START, CP_SEND_END);
  signal state_central_proc : state_central_proc_type := CP_INIT;
  
begin

  central_proc : process (clk, prescaling_FTU01)
  begin
    if rising_edge (clk) then
      case state_central_proc is

        when CP_INIT =>
          state_central_proc <= CP_CONFIG;
          
        when CP_CONFIG_START =>
          reset_scaler_sig <= '1';
          if (config_started_ack = '1') then
            config_started <= '0';
            state_central_proc <= CP_CONFIG;
          end if;

        when CP_CONFIG =>
          reset_scaler_sig <= '1';
          config_start_eth <= '1';
          if (config_started_eth = '1') then
            config_start_eth <= '0';
            state_central_proc <= CP_CONFIG_01;
          end if;

        when CP_CONFIG_01 =>
          if (config_ready_eth = '1') then
            state_central_proc <= CP_CONFIG_CC;
            --state_central_proc <= CP_CONFIG_SCALER;
            --state_central_proc <= CP_IDLE;
          end if;

        when CP_CONFIG_CC =>
          config_start_cc <= '1';
          if (config_started_cc = '1') then
            config_start_cc <= '0';
            state_central_proc <= CP_CONFIG_CC_01;
          end if;

        when CP_CONFIG_CC_01 =>
          if (config_ready_cc = '1') then
            state_central_proc <= CP_CONFIG_FTU;
          end if;
          
        when CP_CONFIG_FTU =>
          config_start_ftu <= '1';
          if (config_started_ftu = '1') then
            config_start_ftu <= '0';
            state_central_proc <= CP_CONFIG_FTU_01;
          end if;

        when CP_CONFIG_FTU_01 =>
          if (config_ready_ftu = '1') then
            state_central_proc <= CP_CONFIG_SCALER;
          end if;

        when CP_CONFIG_SCALER =>
          --if ((conv_integer(unsigned(prescaling_FTU01))) mod 2 = 0) then
            --scaler_period_sig <= ((((conv_integer(unsigned(prescaling_FTU01)) / 2)) * (LOW_FREQUENCY / SCALER_FREQ_DIVIDER)) + (LOW_FREQUENCY / (2 * SCALER_FREQ_DIVIDER)));
          --else
            --scaler_period_sig <= (((conv_integer(unsigned(prescaling_FTU01)) - 1) / 2) + 1) * (LOW_FREQUENCY / SCALER_FREQ_DIVIDER);
          --end if;
          reset_scaler_sig <= '1';
          state_central_proc <= CP_IDLE;
          
        when CP_IDLE =>
          reset_scaler_sig <= '0';
          if (new_config = '1') then
            config_started <= '1';
            state_central_proc <= CP_CONFIG_START;
          elsif (ping_ftu_start = '1') then
          --else
            ping_ftu_start_ftu <= '1';
            if (ping_ftu_started_ftu = '1') then
              ping_ftu_start_ftu <= '0';
              ping_ftu_started <= '1';
              ping_ftu_ready <= '0';
              state_central_proc <= CP_PING;
            end if;            
          --elsif (scaler_counts_sig = scaler_period_sig) then
          --  reset_scaler_sig <= '1';
          --  rates_ftu <= '1';
          --  state_central_proc <= CP_READ_RATES;
          end if;

        when CP_PING =>
          if (ping_ftu_ready_ftu = '1') then
            if (ping_ftu_start = '0') then
              ping_ftu_started <= '0';
              ping_ftu_ready <= '1';
              state_central_proc <= CP_IDLE;
            end if;
          end if;

        when CP_READ_RATES =>
          reset_scaler_sig <= '0';
          if (rates_started_ftu = '1') then
            rates_ftu <= '0';
            state_central_proc <= CP_READ_RATES_01;
          end if;

        when CP_READ_RATES_01 =>
          if (rates_ready_ftu = '1') then
            state_central_proc <= CP_SEND_START;
          end if;
          
        when CP_SEND_START =>
          dd_send <= '1';
          if (dd_send_ack = '1') then
            dd_send <= '0';
            state_central_proc <= CP_SEND_END;
          end if;
          
        when CP_SEND_END =>
          if (dd_send_ready = '1') then
            state_central_proc <= CP_IDLE;
          end if;

      end case;
    end if;
  end process central_proc;

  scaler_process: process(reset_scaler_sig, clk_scaler)
  begin
    if reset_scaler_sig = '1' then
      scaler_counts_sig <= 0;
    elsif rising_edge(clk_scaler) then
      if (scaler_counts_sig < scaler_period_sig) then
        scaler_counts_sig <= scaler_counts_sig + 1;
      else
        scaler_counts_sig <= scaler_counts_sig;
      end if;
    end if;
  end process scaler_process;

  process(reset_scaler_sig, prescaling_FTU01)
  begin
    if rising_edge(reset_scaler_sig) then
      if ((conv_integer(unsigned(prescaling_FTU01))) mod 2 = 0) then
        scaler_period_sig <= ((((conv_integer(unsigned(prescaling_FTU01)) / 2)) * (LOW_FREQUENCY / SCALER_FREQ_DIVIDER)) + (LOW_FREQUENCY / (2 * SCALER_FREQ_DIVIDER)));
      else
        scaler_period_sig <= (((conv_integer(unsigned(prescaling_FTU01)) - 1) / 2) + 1) * (LOW_FREQUENCY / SCALER_FREQ_DIVIDER);
      end if;
    end if;
  end process;

end Behavioral;
