#ifndef EDD_H_SEEN
#define EDD_H_SEEN

#include "../../Evidence/GUI.h"
#include "RawDataCTX.h"
#include "PixelMap.h"

#define SVN_REVISION "$Revision: 10143 $"

// Event oscilloscope
class EventScope: public EddBasePlot, public PixelMap {
  Q_OBJECT

  private:
    struct ItemDetails {
	  unsigned int Board, Chip, Channel;
      QwtPlotCurve *Signal;
	  QwtPlotMarker *Trigger;
    };
    QList<struct ItemDetails> List;

    QString Name;
	RawDataCTX *RD;
	CTX_ErrCode ErrCode;
	QAction *PhysPipeAction;
	QAction *PersistanceAction;
	FILE *Tmpfile;

  public:
    EventScope(QWidget * = NULL);
    ~EventScope();
	
	void UpdateFirst(int, int, int);
	void AddTrace(int, int, int);
	void SetActive(bool);
	QString ToPixel(unsigned int, unsigned int, unsigned int, unsigned int);

  private slots:
	void Update(QString, int, QByteArray, QString, QString);
	void PlotTraces();
	void DeleteCurve(QwtPlotCurve *);
	
  signals:
	void RunHeaderChanged(QString);
	void EventHeaderChanged(QString);
	void PixelData(QVector<double>);
};


// Tab page classes
class TP_Environment: public QWidget {
  Q_OBJECT

  public:
    TP_Environment();
};

class TP_Bias: public QWidget {
  Q_OBJECT

  public:
    TP_Bias();
};

class TP_FADctrl: public QWidget {
  Q_OBJECT

  public:
    TP_FADctrl();
};

class TP_Feedback: public QWidget {
  Q_OBJECT

  public:
    TP_Feedback();
};

class TP_DAQ: public QWidget {
  Q_OBJECT
  static const int MAXPIXEL = 1440;

  private:
	EventScope *Scope;
    QPlainTextEdit *RunHeaderDisplay, *EventHeaderDisplay;

 	QSpinBox *Channel, *Chip, *Board, *PixelID;
 	QFormLayout *FormLayout;
	QWidget *Display;
	QPushButton **Pixel;
	QPushButton *StartStopButton;

  private slots:
	void TranslatePixelID(int);
	void UpdateScope(int);
	void KeepCurrent();
	void StartStop(bool);
	void ShowPixelDisplay();
	void SetPixelData(QVector<double>);

  public:
	TP_DAQ();	
	~TP_DAQ();	
};

class TP_Evidence: public QWidget {
  Q_OBJECT

  private slots:
	void ToggleAlarm(bool);
	void StartDIMBrowser();
	void StartELog();

  public:
	TP_Evidence();	
};


// Main window class
class GUI: public QMainWindow, public DimBrowser {
  Q_OBJECT

  private:
    QTabWidget *TabWidget;
            
    void closeEvent(QCloseEvent *);
	
  public:
    GUI();
    
  private slots:
    void MenuAbout();
    void MenuNewHistory();
	void DetachTab(int);
	void CheckAlarm();
};

#endif
