--------------------------------------------------------------------------------
-- Company:       ETH Zurich, Institute for Particle Physics
-- Engineer:      Q. Weitzel, P. Vogler
--
-- Create Date:   08.12.2010
-- Design Name:   
-- Module Name:   FTM_top_tb.vhd
-- Project Name:  
-- Target Device:  
-- Tool versions:  
-- Description:   Testbench for FTM firmware
-- 
-- VHDL Test Bench Created by ISE for module: FTM_top
-- 
-- Dependencies:
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
-- Notes: 
-- This testbench has been automatically generated using types std_logic and
-- std_logic_vector for the ports of the unit under test.  Xilinx recommends
-- that these types always be used for the top-level I/O of a design in order
-- to guarantee that the testbench will bind correctly to the post-implementation 
-- simulation model.
--------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
use IEEE.NUMERIC_STD.ALL;

library UNISIM;
use UNISIM.VComponents.all;

entity FTM_top_tb is
end FTM_top_tb;

architecture behavior of FTM_top_tb is 

  -- Component Declaration for the Unit Under Test (UUT)
 
  component FTM_top
    port(
      
      -- Clock
      clk : IN  STD_LOGIC;  -- external clock from oscillator U47
    
      -- connection to the WIZnet W5300 ethernet controller
      -------------------------------------------------------------------------------
      -- W5300 data bus
      W_D  : inout STD_LOGIC_VECTOR(15 downto 0);  -- 16-bit data bus to W5300	

      -- W5300 address bus
      W_A  : out STD_LOGIC_VECTOR(9 downto 0); -- there is no real net W_A0 because
                                               -- the W5300 is operated in the 
                                               -- 16-bit mode
                                               -- -> W_A<0> assigned to unconnected pin

      -- W5300 control signals
      -- the signals W_INT, W_RD, W_WR and W_RES also go to testpoints T17
      -- W_CS is also routed to testpoint JP7
      W_CS   : out  STD_LOGIC;                      -- W5300 chip select
      W_INT  : IN   STD_LOGIC;                      -- interrupt
      W_RD   : out  STD_LOGIC;                      -- read
      W_WR   : out  STD_LOGIC;                      -- write
      W_RES  : out  STD_LOGIC;                      -- reset W5300 chip

      -- W5300 buffer ready indicator
      -- W_BRDY : in STD_LOGIC_VECTOR(3 downto 0); 

      -- testpoints (T18) associated with the W5300
      -- W_T    : inout STD_LOGIC_VECTOR(3 downto 0);  
 

      -- SPI Interface
      -- connection to the EEPROM U36 (AL25L016M) and 
      -- temperature sensors U45, U46, U48 and U49 (all MAX6662)
      -------------------------------------------------------------------------------
      -- S_CLK  : out  STD_LOGIC;     -- SPI clock

      -- EEPROM
      --   MOSI   : out  STD_LOGIC;     -- master out slave in
      --   MISO   : in   STD_LOGIC;     -- master in slave out
      --   EE_CS  : out  STD_LOGIC;     -- EEPROM chip select

      -- temperature sensors U45, U46, U48 and U49
      -- SIO    : inout  STD_LOGIC;          -- serial IO
      -- TS_CS  : out STD_LOGIC_VECTOR(3 downto 0);     -- temperature sensors chip select

 
      -- Trigger primitives inputs
      -------------------------------------------------------------------------------
      -- Trig_Prim_A  : in STD_LOGIC_VECTOR(9 downto 0);  -- crate 0
      -- Trig_Prim_B  : in STD_LOGIC_VECTOR(9 downto 0);  -- crate 1
      -- Trig_Prim_C  : in STD_LOGIC_VECTOR(9 downto 0);  -- crate 2
      -- Trig_Prim_D  : in STD_LOGIC_VECTOR(9 downto 0);  -- crate 3

  
      -- NIM inputs
      ------------------------------------------------------------------------------
      -- ext_Trig  : in  STD_LOGIC_VECTOR(2 downto 1);      -- external trigger input
      -- Veto      : in  STD_LOGIC;                         -- trigger veto input
      -- NIM_In    : in  STD_LOGIC_VECTOR(2 downto 0);      -- auxiliary inputs

      -- alternative external clock input for FPGA
      -- NIM_In3_GCLK  : in  STD_LOGIC;      -- input with global clock buffer available 

   
      -- LEDs
      -------------------------------------------------------------------------------
      LED_red  : out STD_LOGIC_VECTOR(3 downto 0);    -- red
      LED_ye   : out STD_LOGIC_VECTOR(1 downto 0);    -- yellow
      LED_gn   : out STD_LOGIC_VECTOR(1 downto 0);    -- green

    
      -- Clock conditioner LMK03000
      -------------------------------------------------------------------------------
      CLK_Clk_Cond  : out STD_LOGIC;  -- MICROWIRE interface serial clock
      LE_Clk_Cond   : out STD_LOGIC;  -- MICROWIRE interface latch enable   
      DATA_Clk_Cond : out STD_LOGIC;  -- MICROWIRE interface data
   
      SYNC_Clk_Cond : out STD_LOGIC;  -- global clock synchronization
      LD_Clk_Cond   : in STD_LOGIC;   -- lock detect, should be checked for                  

    
      -- various RS-485 Interfaces
      -------------------------------------------------------------------------------
      -- Bus 1: FTU slow control   
      Bus1_Tx_En    : out STD_LOGIC;  -- bus 1: transmitter enable                                 
      Bus1_Rx_En    : out STD_LOGIC;  -- bus 1: receiver enable

      Bus1_RxD_0    : in STD_LOGIC;   -- crate 0
      Bus1_TxD_0    : out STD_LOGIC;

      Bus1_RxD_1    : in STD_LOGIC;   -- crate 1
      Bus1_TxD_1    : out STD_LOGIC;

      Bus1_RxD_2    : in STD_LOGIC;   -- crate 2
      Bus1_TxD_2    : out STD_LOGIC;

      Bus1_RxD_3    : in STD_LOGIC;   -- crate 3
      Bus1_TxD_3    : out STD_LOGIC


      -- Bus 2: Trigger-ID to FAD boards
      -- Bus2_Tx_En    : out STD_LOGIC;  -- bus 2: transmitter enable                                 
      -- Bus2_Rx_En    : out STD_LOGIC;  -- bus 2: receiver enable

      -- Bus2_RxD_0    : in STD_LOGIC;   -- crate 0
      -- Bus2_TxD_0    : out STD_LOGIC;

      -- Bus2_RxD_1    : in STD_LOGIC;   -- crate 1
      -- Bus2_TxD_1    : out STD_LOGIC;

      -- Bus2_RxD_2    : in STD_LOGIC;   -- crate 2
      -- Bus2_TxD_2    : out STD_LOGIC;

      -- Bus2_RxD_3    : in STD_LOGIC;   -- crate 3
      -- Bus2_TxD_3    : out STD_LOGIC;  
   

      -- auxiliary access
      --   Aux_Rx_D      : in STD_LOGIC;
      --   Aux_Tx_D      : out STD_LOGIC;
      --   Aux_Rx_En     : out STD_LOGIC;   --   Rx- and Tx enable 
      --   Aux_Tx_En     : out STD_LOGIC;   --   also for auxiliary Trigger-ID
    		      	      			    	   	  

      -- auxiliary Trigger-ID (i.e. to send the Trigger-ID to the counting hut/house/container)
      --   TrID_Rx_D     : in STD_LOGIC;
      --   TrID_Tx_D     : out STD_LOGIC;


      -- Crate-Resets
      -------------------------------------------------------------------------------
      -- Crate_Res0   : out STD_LOGIC;
      -- Crate_Res1   : out STD_LOGIC;
      -- Crate_Res2   : out STD_LOGIC;
      -- Crate_Res3   : out STD_LOGIC;


      -- Busy signals from the FAD boards
      -------------------------------------------------------------------------------
--      Busy0     : in STD_LOGIC;
--      Busy1     : in STD_LOGIC;
--      Busy2     : in STD_LOGIC;
--      Busy3     : in STD_LOGIC;


      -- NIM outputs
      -- LVDS output at the FPGA followed by LVDS to NIM conversion stage
      -------------------------------------------------------------------------------
      -- calibration
      --   Cal_NIM1_p  : out STD_LOGIC;     --  Cal_NIM1+ 
      --   Cal_NIM1_n  : out STD_LOGIC;     --  Cal_NIM1-
      --   Cal_NIM2_p  : out STD_LOGIC;     --  Cal_NIM2+  
      --   Cal_NIM2_n  : out STD_LOGIC;     --  Cal_NIM2- 

      -- auxiliarry / spare NIM outputs
      --   NIM_Out0_p  : out STD_LOGIC;   -- NIM_Out0+
      --   NIM_Out0_n  : out STD_LOGIC;   -- NIM_Out0-
      --   NIM_Out1_p  : out STD_LOGIC;   -- NIM_Out1+
      --   NIM_Out1_n  : out STD_LOGIC;   -- NIM_Out1-

  
      -- fast control signal outputs
      -- LVDS output at the FPGA followed by LVDS to NIM conversion stage
      -------------------------------------------------------------------------------
--      RES_p      : out STD_LOGIC;   --  RES+   Reset
--      RES_n      : out STD_LOGIC;   --  RES-

--      TRG_p      : out STD_LOGIC;   -- TRG+  Trigger
--      TRG_n      : out STD_LOGIC;   -- TRG-

--      TIM_Run_p  : out STD_LOGIC;   -- TIM_Run+  Time Marker
--      TIM_Run_n  : out STD_LOGIC;   -- TIM_Run-
--      TIM_Sel    : out STD_LOGIC;   -- Time Marker selector
                                                    
      -- CLD_FPGA   : in STD_LOGIC;    -- DRS-Clock feedback into FPGA


      -- LVDS calibration outputs
      -------------------------------------------------------------------------------
      -- to connector J13
      -- for light pulsar in the mirror dish
--      Cal_0_p    : out STD_LOGIC;  
--      Cal_0_n    : out STD_LOGIC;
--      Cal_1_p    : out STD_LOGIC;
--      Cal_1_n    : out STD_LOGIC;
--      Cal_2_p    : out STD_LOGIC;
--      Cal_2_n    : out STD_LOGIC;
--      Cal_3_p    : out STD_LOGIC;
--      Cal_3_n    : out STD_LOGIC;

      -- to connector J12
      -- for light pulsar inside shutter
--      Cal_4_p    : out STD_LOGIC;
--      Cal_4_n    : out STD_LOGIC;
--      Cal_5_p    : out STD_LOGIC;
--      Cal_5_n    : out STD_LOGIC;
--      Cal_6_p    : out STD_LOGIC;
--      Cal_6_n    : out STD_LOGIC; 
--      Cal_7_p    : out STD_LOGIC;
--      Cal_7_n    : out STD_LOGIC  


      -- Testpoints
      -------------------------------------------------------------------------------
      --   TP    : inout STD_LOGIC_VECTOR(32 downto 0);
      --   TP_in    : in STD_LOGIC_VECTOR(34 downto 33);    -- input only

      -- Board ID - inputs 
      -- local board-ID "solder programmable"
      -- all on 'input only' pins
      -------------------------------------------------------------------------------
      -- brd_id : in STD_LOGIC_VECTOR(7 downto 0)    -- input only		    

    );
  end component;
    
  --Inputs
  signal clk_sig          : STD_LOGIC := '0';
  signal W_INT_sig        : STD_LOGIC := '0';
  signal W_BRDY_sig       : STD_LOGIC_VECTOR(3 downto 0) := (others => '0');
  signal Trig_Prim_A_sig  : STD_LOGIC_VECTOR(9 downto 0) := (others => '0');
  signal Trig_Prim_B_sig  : STD_LOGIC_VECTOR(9 downto 0) := (others => '0');
  signal Trig_Prim_C_sig  : STD_LOGIC_VECTOR(9 downto 0) := (others => '0');
  signal Trig_Prim_D_sig  : STD_LOGIC_VECTOR(9 downto 0) := (others => '0');
  signal ext_Trig_sig     : STD_LOGIC_VECTOR(2 downto 1) := (others => '0');
  signal Veto_sig         : STD_LOGIC := '0';
  signal NIM_In_sig       : STD_LOGIC_VECTOR(2 downto 0) := (others => '0');
  signal NIM_In3_GCLK_sig : STD_LOGIC := '0';
  signal LD_Clk_Cond_sig  : STD_LOGIC := '1';
  signal Bus1_RxD_0_sig   : STD_LOGIC := '1';
  signal Bus1_RxD_1_sig   : STD_LOGIC := '1';
  signal Bus1_RxD_2_sig   : STD_LOGIC := '1';
  signal Bus1_RxD_3_sig   : STD_LOGIC := '1';
  signal Bus2_RxD_0_sig   : STD_LOGIC := '1';
  signal Bus2_RxD_1_sig   : STD_LOGIC := '1';
  signal Bus2_RxD_2_sig   : STD_LOGIC := '1';
  signal Bus2_RxD_3_sig   : STD_LOGIC := '1';
  signal Busy0_sig        : STD_LOGIC := '0';
  signal Busy1_sig        : STD_LOGIC := '0';
  signal Busy2_sig        : STD_LOGIC := '0';
  signal Busy3_sig        : STD_LOGIC := '0';

  --Input/Output Pins
  signal W_D_sig : STD_LOGIC_VECTOR(15 downto 0) := (others => '0');
  signal W_T_sig : STD_LOGIC_VECTOR(3 downto 0) := (others => '0');
  signal SIO_sig : STD_LOGIC := '0';
  
  --Outputs
  signal W_A_sig           : STD_LOGIC_VECTOR(9 downto 0);
  signal W_CS_sig          : STD_LOGIC;
  signal W_RD_sig          : STD_LOGIC;
  signal W_WR_sig          : STD_LOGIC;
  signal W_RES_sig         : STD_LOGIC;
  signal S_CLK_sig         : STD_LOGIC;
  signal TS_CS_sig         : STD_LOGIC_VECTOR(3 downto 0);  
  signal LED_red_sig       : STD_LOGIC_VECTOR(3 downto 0);
  signal LED_ye_sig        : STD_LOGIC_VECTOR(1 downto 0);
  signal LED_gn_sig        : STD_LOGIC_VECTOR(1 downto 0);
  signal CLK_Clk_Cond_sig  : STD_LOGIC;
  signal LE_Clk_Cond_sig   : STD_LOGIC;
  signal DATA_Clk_Cond_sig : STD_LOGIC;
  signal SYNC_Clk_Cond_sig : STD_LOGIC;
  signal Bus1_Tx_En_sig    : STD_LOGIC;
  signal Bus1_Rx_En_sig    : STD_LOGIC;
  signal Bus1_TxD_0_sig    : STD_LOGIC;
  signal Bus1_TxD_1_sig    : STD_LOGIC;
  signal Bus1_TxD_2_sig    : STD_LOGIC;
  signal Bus1_TxD_3_sig    : STD_LOGIC;
  signal Bus2_Tx_En_sig    : STD_LOGIC;
  signal Bus2_Rx_En_sig    : STD_LOGIC;
  signal Bus2_TxD_0_sig    : STD_LOGIC;
  signal Bus2_TxD_1_sig    : STD_LOGIC;
  signal Bus2_TxD_2_sig    : STD_LOGIC;
  signal Bus2_TxD_3_sig    : STD_LOGIC;
  signal Crate_Res0_sig    : STD_LOGIC;
  signal Crate_Res1_sig    : STD_LOGIC;
  signal Crate_Res2_sig    : STD_LOGIC;
  signal Crate_Res3_sig    : STD_LOGIC;
  signal RES_p_sig         : STD_LOGIC;
  signal RES_n_sig         : STD_LOGIC;
  signal TRG_p_sig         : STD_LOGIC;
  signal TRG_n_sig         : STD_LOGIC;
  signal TIM_Run_p_sig     : STD_LOGIC;
  signal TIM_Run_n_sig     : STD_LOGIC;
  signal TIM_Sel_sig       : STD_LOGIC;
  signal Cal_0_p_sig       : STD_LOGIC;
  signal Cal_0_n_sig       : STD_LOGIC;
  signal Cal_1_p_sig       : STD_LOGIC;
  signal Cal_1_n_sig       : STD_LOGIC;
  signal Cal_2_p_sig       : STD_LOGIC;
  signal Cal_2_n_sig       : STD_LOGIC;
  signal Cal_3_p_sig       : STD_LOGIC;
  signal Cal_3_n_sig       : STD_LOGIC;
  signal Cal_4_p_sig       : STD_LOGIC;
  signal Cal_4_n_sig       : STD_LOGIC;
  signal Cal_5_p_sig       : STD_LOGIC;
  signal Cal_5_n_sig       : STD_LOGIC;
  signal Cal_6_p_sig       : STD_LOGIC;
  signal Cal_6_n_sig       : STD_LOGIC;
  signal Cal_7_p_sig       : STD_LOGIC;
  signal Cal_7_n_sig       : STD_LOGIC;

  -- Clock period definitions
  constant clk_period       : TIME := 25 ns;  --  40 MHZ oscillator U47
  constant baud_rate_period : TIME :=  4 us;  -- 250 kHz baud rate
  
begin
 
  -- Instantiate the Unit Under Test (UUT)
  uut: FTM_top
    port map(     
      clk           => clk_sig,
      W_D           => W_D_sig,
      W_A           => W_A_sig,
      W_CS          => W_CS_sig,
      W_INT         => W_INT_sig,
      W_RD          => W_RD_sig,
      W_WR          => W_WR_sig,
      W_RES         => W_RES_sig,
--      W_BRDY        => W_BRDY_sig, 
--      W_T           => W_T_sig,  
--      S_CLK         => S_CLK_sig,
--      SIO           => SIO_sig,
--      TS_CS         => TS_CS_sig,
--      Trig_Prim_A   => Trig_Prim_A_sig,
--      Trig_Prim_B   => Trig_Prim_B_sig,
--      Trig_Prim_C   => Trig_Prim_C_sig,
--      Trig_Prim_D   => Trig_Prim_D_sig,
--      ext_Trig      => ext_Trig_sig,
--      Veto          => Veto_sig, 
--      NIM_In        => NIM_In_sig, 
--      NIM_In3_GCLK  => NIM_In3_GCLK_sig, 
      LED_red       => LED_red_sig,
      LED_ye        => LED_ye_sig,
      LED_gn        => LED_gn_sig,
      CLK_Clk_Cond  => CLK_Clk_Cond_sig,
      LE_Clk_Cond   => LE_Clk_Cond_sig,
      DATA_Clk_Cond => DATA_Clk_Cond_sig,
      SYNC_Clk_Cond => SYNC_Clk_Cond_sig,
      LD_Clk_Cond   => LD_Clk_Cond_sig,               
      Bus1_Tx_En    => Bus1_Tx_En_sig,                               
      Bus1_Rx_En    => Bus1_Rx_En_sig,
      Bus1_RxD_0    => Bus1_RxD_0_sig,
      Bus1_TxD_0    => Bus1_TxD_0_sig,
      Bus1_RxD_1    => Bus1_RxD_1_sig,
      Bus1_TxD_1    => Bus1_TxD_1_sig,
      Bus1_RxD_2    => Bus1_RxD_2_sig,
      Bus1_TxD_2    => Bus1_TxD_2_sig,
      Bus1_RxD_3    => Bus1_RxD_3_sig,
      Bus1_TxD_3    => Bus1_TxD_3_sig  
--      Bus2_Tx_En    => Bus2_Tx_En_sig,                               
--      Bus2_Rx_En    => Bus2_Rx_En_sig,
--      Bus2_RxD_0    => Bus2_RxD_0_sig,
--      Bus2_TxD_0    => Bus2_TxD_0_sig,
--      Bus2_RxD_1    => Bus2_RxD_1_sig,
--      Bus2_TxD_1    => Bus2_TxD_1_sig,
--      Bus2_RxD_2    => Bus2_RxD_2_sig,
--      Bus2_TxD_2    => Bus2_TxD_2_sig,
--      Bus2_RxD_3    => Bus2_RxD_3_sig,
--      Bus2_TxD_3    => Bus2_TxD_3_sig,
--      Crate_Res0    => Crate_Res0_sig,
--      Crate_Res1    => Crate_Res1_sig,
--      Crate_Res2    => Crate_Res2_sig,
--      Crate_Res3    => Crate_Res3_sig,
--      Busy0         => Busy0_sig,
--      Busy1         => Busy1_sig,
--      Busy2         => Busy2_sig,
--      Busy3         => Busy3_sig,
--      RES_p         => RES_p_sig,
--      RES_n         => RES_n_sig,
--      TRG_p         => TRG_p_sig,
--      TRG_n         => TRG_n_sig,
--      TIM_Run_p     => TIM_Run_p_sig,
--      TIM_Run_n     => TIM_Run_n_sig,
--      TIM_Sel       => TIM_Sel_sig,
--      Cal_0_p       => Cal_0_p_sig,  
--      Cal_0_n       => Cal_0_n_sig,
--      Cal_1_p       => Cal_1_p_sig,
--      Cal_1_n       => Cal_1_n_sig,
--      Cal_2_p       => Cal_2_p_sig,
--      Cal_2_n       => Cal_2_n_sig,
--      Cal_3_p       => Cal_3_p_sig,
--      Cal_3_n       => Cal_3_n_sig,
--      Cal_4_p       => Cal_4_p_sig,
--      Cal_4_n       => Cal_4_n_sig,
--      Cal_5_p       => Cal_5_p_sig,
--      Cal_5_n       => Cal_5_n_sig,
--      Cal_6_p       => Cal_6_p_sig,
--      Cal_6_n       => Cal_6_n_sig, 
--      Cal_7_p       => Cal_7_p_sig,
--      Cal_7_n       => Cal_7_n_sig  
    );

  -- Stimulus process for clock
  clk_proc: process
  begin
    clk_sig <= '0';
    wait for clk_period/2;
    clk_sig <= '1';
    wait for clk_period/2;
  end process clk_proc;

  -- Stimulus process for RS485 of crate 0 
  rs485_0_proc: process

    procedure assign_rs485_0 (data: std_logic_vector(7 downto 0)) is
    begin
      Bus1_RxD_0_sig <= '0'; --start bit
      wait for baud_rate_period;
      Bus1_RxD_0_sig <= data(0); --bit 0
      wait for baud_rate_period;
      Bus1_RxD_0_sig <= data(1); --bit 1
      wait for baud_rate_period;
      Bus1_RxD_0_sig <= data(2); --bit 2
      wait for baud_rate_period;
      Bus1_RxD_0_sig <= data(3); --bit 3
      wait for baud_rate_period;
      Bus1_RxD_0_sig <= data(4); --bit 4
      wait for baud_rate_period;
      Bus1_RxD_0_sig <= data(5); --bit 5
      wait for baud_rate_period;
      Bus1_RxD_0_sig <= data(6); --bit 6
      wait for baud_rate_period;
      Bus1_RxD_0_sig <= data(7); --bit 7
      wait for baud_rate_period;
      Bus1_RxD_0_sig <= '1'; --stop bit
      wait for baud_rate_period;
      Bus1_RxD_0_sig <= '1'; --stop bit
      wait for baud_rate_period;
    end assign_rs485_0;

  begin
    ---------------------------------------------------------------------------
    -- time of FTU answer
    ---------------------------------------------------------------------------
    wait for 2ms;
    ---------------------------------------------------------------------------
    -- data package of FTU answer (28 byte)
    ---------------------------------------------------------------------------
    assign_rs485_0(X"40"); --start delimiter
    wait for 0us;
    assign_rs485_0(X"C0"); --FTM address
    wait for 0ns;
    assign_rs485_0(X"00"); --FTU address
    wait for 0ns;
    assign_rs485_0(X"01"); --FTM firmware ID
    wait for 0ns;
    assign_rs485_0(X"05"); --instruction
    wait for 0us;
    assign_rs485_0(X"00"); --data byte 01
    wait for 0ns;
    assign_rs485_0(X"00"); --data byte 02
    wait for 0ns;
    assign_rs485_0(X"00"); --data byte 03
    wait for 0ns;
    assign_rs485_0(X"00"); --data byte 04
    wait for 0ns;
    assign_rs485_0(X"00"); --data byte 05
    wait for 0ns;
    assign_rs485_0(X"00"); --data byte 06
    wait for 0ns;
    assign_rs485_0(X"00"); --data byte 07
    wait for 0ns;
    assign_rs485_0(X"00"); --data byte 08
    wait for 0ns;
    assign_rs485_0(X"00"); --data byte 09
    wait for 0ns;
    assign_rs485_0(X"00"); --data byte 10
    wait for 0ns;
    assign_rs485_0(X"00"); --data byte 11
    wait for 0ns;
    assign_rs485_0(X"00"); --data byte 12
    wait for 0ns;
    assign_rs485_0(X"00"); --data byte 13
    wait for 0ns;
    assign_rs485_0(X"00"); --data byte 14
    wait for 0ns;
    assign_rs485_0(X"00"); --data byte 15
    wait for 0ns;
    assign_rs485_0(X"00"); --data byte 16
    wait for 0ns;
    assign_rs485_0(X"00"); --data byte 17
    wait for 0ns;
    assign_rs485_0(X"00"); --data byte 18
    wait for 0ns;
    assign_rs485_0(X"00"); --data byte 19
    wait for 0ns;
    assign_rs485_0(X"00"); --data byte 20
    wait for 0ns;
    assign_rs485_0(X"00"); --data byte 21
    wait for 0ns;
    assign_rs485_0(X"00"); --CRC error counter (not used)
    wait for 0ns;
    --assign_rs485_0(X"9E"); --check sum for rates
    assign_rs485_0(X"A5"); --check sum for ping
    ---------------------------------------------------------------------------
    -- don't forget final wait!
    ---------------------------------------------------------------------------
    wait;

  end process rs485_0_proc;
    
end;
