--
-- VHDL Architecture FACT_FTM_lib.header_modul.beha
--
-- Created:
--          by - kai.UNKNOWN (E5PCXX)
--          at - 10:30:24 03.03.2011
--
-- using Mentor Graphics HDL Designer(TM) 2009.1 (Build 12)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE IEEE.STD_LOGIC_UNSIGNED.all;
--LIBRARY FACT_FTM_lib;
--USE FACT_FTM_lib.ftm_array_types.all;
--USE FACT_FTM_lib.ftm_constants.all;
library ftm_definitions;
USE ftm_definitions.ftm_array_types.all;
USE ftm_definitions.ftm_constants.all;

ENTITY header_modul IS
PORT(
  clk                       : IN std_logic;
  get_header                : IN std_logic;
  get_header_started        : OUT std_logic := '0';
  get_header_ready          : OUT std_logic := '0';
  trigger_counter_read      : OUT std_logic := '0';
  trigger_counter_valid     : IN std_logic;
  trigger_counter           : IN  std_logic_vector (31 DOWNTO 0) := (others => '0');
  header_board_id           : OUT std_logic_vector (63 DOWNTO 0) := (others => '0');
  header_firmware_id        : OUT std_logic_vector (15 DOWNTO 0) := (others => '0');
  header_trigger_counter    : OUT std_logic_vector (31 DOWNTO 0) := (others => '0');
  header_timestamp_counter  : OUT std_logic_vector (47 DOWNTO 0) := (others => '0')
  );
END ENTITY header_modul;

--
ARCHITECTURE beha OF header_modul IS

  type state_header_proc_type is (HP_INIT, HP_CONFIG, HP_IDLE, HP_START, HP_TRG_CNT, HP_END);
  
  signal state_header_proc : state_header_proc_type := HP_INIT;

BEGIN
  header_proc : process (clk)
  begin
    if rising_edge (clk) then
      case state_header_proc is
      
      when HP_INIT =>
        state_header_proc <= HP_CONFIG;
        
      when HP_CONFIG =>
        state_header_proc <= HP_IDLE;
        
      when HP_IDLE =>
        if (get_header = '1') then
          get_header_started <= '1';
          get_header_ready <= '0';
          state_header_proc <= HP_START;
        end if;
        
      when HP_START =>
        header_board_id <= to_stdlogicvector (DNA_FOR_SIM);
        header_firmware_id <= X"00" & FIRMWARE_ID;
        header_timestamp_counter <= X"333322221111";
        
        trigger_counter_read <= '1';
        state_header_proc <= HP_TRG_CNT;
        
      when HP_TRG_CNT =>
        trigger_counter_read <= '0';
        if (trigger_counter_valid = '1') then
          header_trigger_counter <= trigger_counter;
          state_header_proc <= HP_END;
        end if;
        
      when HP_END =>
        if (get_header <= '0') then
          get_header_started <= '0';
          get_header_ready <= '1';
          state_header_proc <= HP_IDLE;
        end if;
      
      end case;
    end if;
  end process header_proc;

END ARCHITECTURE beha;

