----------------------------------------------------------------------------------
-- Company:        ETH Zurich, Institute for Particle Physics
-- Engineer:       Q. Weitzel
-- 
-- Create Date:    February 28, 2011 
-- Design Name: 
-- Module Name:    FTM_clk_gen_2 - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description:    interface to different DCMs and clk dividers for FMU board
--                 add here more DCMs if needed
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity FTM_clk_gen_2 is
  Port (
    clk        : IN  STD_LOGIC;
    rst        : IN  STD_LOGIC;
    clk_1      : OUT STD_LOGIC;
    clk_50     : OUT STD_LOGIC;
    clk_250    : OUT STD_LOGIC;
    clk_250_ps : OUT STD_LOGIC;
    ready      : OUT STD_LOGIC
  );
end FTM_clk_gen_2;

architecture Behavioral of FTM_clk_gen_2 is

  component FTM_dcm_40M_to_50M_2
    port(
      CLKIN_IN        : in    std_logic;
      RST_IN          : in    std_logic;
      CLKFX_OUT       : out   std_logic;
      CLKIN_IBUFG_OUT : out   std_logic;
      LOCKED_OUT      : out   std_logic
    );
  end component;

  component FTM_dcm_50M_to_250M_2
    port(
      CLKIN_IN     : in    std_logic;
      RST_IN       : in    std_logic;
      CLKFX_OUT    : out   std_logic;
      CLKFX180_OUT : out   std_logic;
      CLK0_OUT     : out   std_logic;
      LOCKED_OUT   : out   std_logic
    );
  end component;
  
  component Clock_Divider
    port(
      clock_in  : IN  STD_LOGIC;
      clock_out : OUT STD_LOGIC
    );
  end component;

  signal clk_1M_sig      : std_logic;
  signal clk_50M_sig     : std_logic;
  signal clk_250M_sig    : std_logic;
  signal clk_250M_ps_sig : std_logic;

  signal clk_50M_int_sig : std_logic;
  signal dcm1_ibufg_sig  : std_logic;
  
  signal dcm1_locked : std_logic;
  signal dcm2_locked : std_logic;
  
begin

  Inst_FTM_dcm_40M_to_50M_2 : FTM_dcm_40M_to_50M_2
    port map(
      CLKIN_IN        => clk,
      RST_IN          => rst,
      CLKFX_OUT       => clk_50M_int_sig,
      CLKIN_IBUFG_OUT => dcm1_ibufg_sig,
      LOCKED_OUT      => dcm1_locked
    );

  Inst_FTM_dcm_50M_to_250M_2 : FTM_dcm_50M_to_250M_2
    port map(
      CLKIN_IN     => clk_50M_int_sig,
      RST_IN       => rst,
      CLKFX_OUT    => clk_250M_sig,
      CLKFX180_OUT => clk_250M_ps_sig,
      CLK0_OUT     => clk_50M_sig,
      LOCKED_OUT   => dcm2_locked
    );
  
  Inst_Clock_Divider : Clock_Divider
    port map (
      clock_in  => clk_50M_sig,
      clock_out => clk_1M_sig
    );

  clk_1      <= clk_1M_sig;
  clk_50     <= clk_50M_sig;
  clk_250    <= clk_250M_sig;
  clk_250_ps <= clk_250M_ps_sig;

  ready <= dcm1_locked and dcm2_locked;

end Behavioral;

----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

library ftm_definitions;
USE ftm_definitions.ftm_array_types.all;
USE ftm_definitions.ftm_constants.all;

entity Clock_Divider is
  generic(
    divider : integer := INT_CLK_FREQUENCY_1 / LOW_FREQUENCY
  );
  port(
    clock_in  : in  std_logic;
    clock_out : out std_logic := '0'
  );
end entity Clock_Divider;

architecture RTL of Clock_Divider is

begin
    
  process (clock_in)
    variable Z: integer range 0 to divider - 1;
  begin
    if rising_edge(clock_in) then
      if (Z < divider - 1) then
        Z := Z + 1;
      else
        Z := 0;
      end if;
      if (Z = 0) then
        clock_out <= '1';
      end if;
      if (Z = divider / 2) then
        clock_out <= '0';
      end if;
    end if;
  end process;

end architecture RTL;
