--
-- VHDL Architecture FACT_FTM_lib.cram_control.beha
--
-- Created:
--          by - kai.UNKNOWN (E5PCXX)
--          at - 14:42:24 01.02.2011
--
-- using Mentor Graphics HDL Designer(TM) 2009.1 (Build 12)
--
-- updated by Q. Weitzel, March 14, 2011 
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE IEEE.STD_LOGIC_UNSIGNED.all;
-- LIBRARY FACT_FTM_lib;
-- USE FACT_FTM_lib.ftm_array_types.all;
-- USE FACT_FTM_lib.ftm_constants.all;
library ftm_definitions;
USE ftm_definitions.ftm_array_types.all;
USE ftm_definitions.ftm_constants.all;

ENTITY cram_control IS
  PORT( 
    clk                            : IN  std_logic;
    led                            : OUT std_logic_vector (7 downto 0) := X"00";
    cram_data_in                   : OUT std_logic_vector (15 downto 0) := (others => '0');
    cram_data_out                  : IN  std_logic_vector (15 downto 0);
    cram_addr_in, cram_addr_out    : OUT std_logic_vector (11 downto 0) := (others => '0');
    cram_we                        : OUT std_logic_vector (0 downto 0) := "0";
    sd_write, sd_read, sd_read_ftu : IN  std_logic;
    sd_busy                        : OUT std_logic := '1';
    sd_started, sd_started_ftu     : OUT std_logic := '0';
    sd_ready                       : OUT std_logic := '0';
    sd_data_in                     : IN  std_logic_vector (15 downto 0);
    sd_data_out, sd_data_out_ftu   : OUT std_logic_vector (15 downto 0) := (others => '0');
    sd_addr, sd_addr_ftu           : IN  std_logic_vector (11 downto 0);
      
    config_start_cc   : IN  std_logic;
    config_started_cc : OUT std_logic := '0';
    config_ready_cc   : OUT std_logic := '0';
      
    -- data from config ram
    general_settings : OUT std_logic_vector (15 downto 0) := (others => '0');
    lp_pt_freq       : OUT std_logic_vector (15 downto 0) := (others => '0');
    lp_pt_ratio      : OUT std_logic_vector (15 downto 0) := (others => '0');
    lp1_amplitude    : OUT std_logic_vector (15 downto 0) := (others => '0');
    lp2_amplitude    : OUT std_logic_vector (15 downto 0) := (others => '0');
    lp1_delay        : OUT std_logic_vector (15 downto 0) := (others => '0');
    lp2_delay        : OUT std_logic_vector (15 downto 0) := (others => '0');
    coin_n_p         : OUT std_logic_vector (15 downto 0) := (others => '0');
    coin_n_c         : OUT std_logic_vector (15 downto 0) := (others => '0');
    trigger_delay    : OUT std_logic_vector (15 downto 0) := (others => '0');
    timemarker_delay : OUT std_logic_vector (15 downto 0) := (others => '0');
    dead_time        : OUT std_logic_vector (15 downto 0) := (others => '0');
    cc_R0            : OUT std_logic_vector (31 downto 0) := (others => '0');
    cc_R1            : OUT std_logic_vector (31 downto 0) := (others => '0');
    cc_R8            : OUT std_logic_vector (31 downto 0) := (others => '0');
    cc_R9            : OUT std_logic_vector (31 downto 0) := (others => '0');
    cc_R11           : OUT std_logic_vector (31 downto 0) := (others => '0');
    cc_R13           : OUT std_logic_vector (31 downto 0) := (others => '0');
    cc_R14           : OUT std_logic_vector (31 downto 0) := (others => '0');
    cc_R15           : OUT std_logic_vector (31 downto 0) := (others => '0');
    coin_win_p	     : OUT std_logic_vector (15 downto 0) := (others => '0');
    coin_win_c	     : OUT std_logic_vector (15 downto 0) := (others => '0');
    prescaling_FTU01 : OUT std_logic_vector (15 downto 0) := (others => '0');
    ftu_active_cr0   : OUT std_logic_vector (15 downto 0) := (others => '0');
    ftu_active_cr1   : OUT std_logic_vector (15 downto 0) := (others => '0');
    ftu_active_cr2   : OUT std_logic_vector (15 downto 0) := (others => '0');
    ftu_active_cr3   : OUT std_logic_vector (15 downto 0) := (others => '0')
  );
END cram_control ;

ARCHITECTURE beha OF cram_control IS

  type state_cram_proc_type is (CR_INIT, CR_INIT_01, CR_INIT_02, CR_INIT_03,
                                CR_CONFIG, CR_CONFIG_START, CR_CONFIG_01,
                                CR_IDLE, CR_WRITE_START, CR_WRITE_END, CR_READ_START, CR_READ_WAIT, CR_READ_END,
                                CR_DOUT_WIZ_START, CR_DOUT_WIZ_END, CR_DOUT_FTU_START, CR_DOUT_FTU_END);
  signal state_cram_proc : state_cram_proc_type := CR_INIT;
  signal next_state      : state_cram_proc_type := CR_IDLE;
  
  signal local_sd_addr  : std_logic_vector (11 downto 0) := X"000";
  signal local_sd_data  : std_logic_vector (15 downto 0);
--  signal addr_cnt       : integer range 0 to 4096 := 0;
  signal addr_cnt       : std_logic_vector (11 downto 0) := X"000";
  signal ftu_cnt        : integer range 0 to SD_FTU_NUM := 0;
  signal ftu_active_cnt : integer range 0 to SD_FTU_ACTIVE_NUM := 0;

BEGIN
  
  cram_proc : process (clk)
  begin
    if rising_edge (clk) then
      case state_cram_proc is
        
        when CR_INIT =>
          addr_cnt <= X"000";
          state_cram_proc <= CR_INIT_01;
          
        -- general part of static data block
        when CR_INIT_01 =>
          if (addr_cnt < SD_BLOCK_SIZE_GENERAL) then
            local_sd_addr <= addr_cnt;
            local_sd_data <= sd_block_default_array (conv_integer (addr_cnt));
            addr_cnt <= addr_cnt + 1;
            next_state <= CR_INIT_01;
            state_cram_proc <= CR_WRITE_START;
          else
            addr_cnt <= X"000";
            ftu_cnt <= 0;
            state_cram_proc <= CR_INIT_02;
          end if;

        -- defaults for FTUs
        when CR_INIT_02 =>
          if (ftu_cnt < SD_FTU_NUM) then
            if (addr_cnt < SD_FTU_DATA_SIZE) then
              local_sd_addr <= SD_FTU_BASE_ADDR + (ftu_cnt * SD_FTU_DATA_SIZE) + addr_cnt;
              -- only for testing
              -- local_sd_data <= sd_block_ftu_default_array (conv_integer (addr_cnt)) OR (conv_std_logic_vector (ftu_cnt, 8) & X"00");
              -- for FTM-Board
              local_sd_data <= sd_block_ftu_default_array (conv_integer (addr_cnt));
              -- --
              addr_cnt <= addr_cnt + 1;
              next_state <= CR_INIT_02;
              state_cram_proc <= CR_WRITE_START;
            else
              addr_cnt <= X"000";
              ftu_cnt <= ftu_cnt + 1;
            end if;
          else
            addr_cnt <= X"000";
            state_cram_proc <= CR_INIT_03;
          end if;
          
        -- defaults for active FTU lists
        when CR_INIT_03 =>
          if (ftu_active_cnt < SD_FTU_ACTIVE_NUM) then
            local_sd_addr <= SD_FTU_ACTIVE_BASE_ADDR + conv_std_logic_vector (ftu_active_cnt, 12);
            -- only for testing
            -- local_sd_data <= conv_std_logic_vector (ftu_active_cnt, 16);
            -- for FTM-Board
            local_sd_data <= sd_block_default_ftu_active_list (ftu_active_cnt);
            -- --
            ftu_active_cnt <= ftu_active_cnt + 1;
            next_state <= CR_INIT_03;
            state_cram_proc <= CR_WRITE_START;
          else
            ftu_active_cnt <= 0;
            state_cram_proc <= CR_CONFIG;
          end if;


        when CR_CONFIG =>
          if (config_start_cc = '1') then
            config_ready_cc <= '0';
            config_started_cc <= '1';
            state_cram_proc <= CR_CONFIG_START;
          end if;
          
        when CR_CONFIG_START =>
          if (addr_cnt < SD_BLOCK_SIZE) then
            if ((addr_cnt < SD_FTU_BASE_ADDR)
                OR (addr_cnt = SD_ADDR_ftu_prescaling_0)
                OR (addr_cnt >= SD_FTU_ACTIVE_BASE_ADDR)
                ) then
              local_sd_addr <= addr_cnt;
              next_state <= CR_CONFIG_01;
              state_cram_proc <= CR_READ_START;
            elsif (addr_cnt = SD_FTU_BASE_ADDR) then
              addr_cnt <= SD_ADDR_ftu_prescaling_0;
            elsif (addr_cnt = (SD_ADDR_ftu_prescaling_0 + 1)) then
              addr_cnt <= SD_FTU_ACTIVE_BASE_ADDR;
            end if;
          else
            addr_cnt <= X"000";
            config_started_cc <= '0';
            config_ready_cc <= '1';
            state_cram_proc <= CR_IDLE;
          end if;
          
        when CR_CONFIG_01 =>
            state_cram_proc <= CR_CONFIG_START;
            addr_cnt <= addr_cnt + 1;
            case addr_cnt is
              when SD_ADDR_general_settings =>
                general_settings <= local_sd_data;
              when SD_ADDR_led =>
                led <= local_sd_data (7 downto 0);
              when SD_ADDR_lp_pt_freq =>
                lp_pt_freq <= local_sd_data;
              when SD_ADDR_lp_pt_ratio =>
                lp_pt_ratio <= local_sd_data;
              when SD_ADDR_lp1_amplitude =>
                lp1_amplitude <= local_sd_data;
              when SD_ADDR_lp2_amplitude =>
                lp2_amplitude <= local_sd_data;
              when SD_ADDR_lp1_delay =>
                lp1_delay <= local_sd_data;
              when SD_ADDR_lp2_delay =>
                lp2_delay <= local_sd_data;
              when SD_ADDR_coin_n_p =>
                coin_n_p <= local_sd_data;
              when SD_ADDR_coin_n_c =>
                coin_n_c <= local_sd_data;
              when SD_ADDR_trigger_delay =>
                trigger_delay <= local_sd_data;
              when SD_ADDR_timemarker_delay =>
                timemarker_delay <= local_sd_data;
              when SD_ADDR_dead_time =>
                dead_time <= local_sd_data;
              when SD_ADDR_cc_R0_HI =>
                cc_R0 (31 downto 16) <= local_sd_data;
              when SD_ADDR_cc_R0_LO =>
                cc_R0 (15 downto 0) <= local_sd_data;  
              when SD_ADDR_cc_R1_HI =>
                cc_R1 (31 downto 16) <= local_sd_data;
              when SD_ADDR_cc_R1_LO =>
                cc_R1 (15 downto 0) <= local_sd_data;  
              when SD_ADDR_cc_R8_HI =>
                cc_R8 (31 downto 16) <= local_sd_data;
              when SD_ADDR_cc_R8_LO =>
                cc_R8 (15 downto 0) <= local_sd_data;  
              when SD_ADDR_cc_R9_HI =>
                cc_R9 (31 downto 16) <= local_sd_data;
              when SD_ADDR_cc_R9_LO =>
                cc_R9 (15 downto 0) <= local_sd_data;  
              when SD_ADDR_cc_R11_HI =>
                cc_R11 (31 downto 16) <= local_sd_data;
              when SD_ADDR_cc_R11_LO =>
                cc_R11 (15 downto 0) <= local_sd_data;  
              when SD_ADDR_cc_R13_HI =>
                cc_R13 (31 downto 16) <= local_sd_data;
              when SD_ADDR_cc_R13_LO =>
                cc_R13 (15 downto 0) <= local_sd_data;  
              when SD_ADDR_cc_R14_HI =>
                cc_R14 (31 downto 16) <= local_sd_data;
              when SD_ADDR_cc_R14_LO =>
                cc_R14 (15 downto 0) <= local_sd_data;  
              when SD_ADDR_cc_R15_HI =>
                cc_R15 (31 downto 16) <= local_sd_data;
              when SD_ADDR_cc_R15_LO =>
                cc_R15 (15 downto 0) <= local_sd_data;
			  when SD_ADDR_coin_win_p =>
				coin_win_p <= local_sd_data;
			  when SD_ADDR_coin_win_c =>
				coin_win_c <= local_sd_data;
              when SD_ADDR_ftu_prescaling_0 =>
                prescaling_FTU01 <= local_sd_data;            
              when SD_ADDR_ftu_active_cr0 =>
                ftu_active_cr0 <= local_sd_data;
              when SD_ADDR_ftu_active_cr1 =>
                ftu_active_cr1 <= local_sd_data;
              when SD_ADDR_ftu_active_cr2 =>
                ftu_active_cr2 <= local_sd_data;
              when SD_ADDR_ftu_active_cr3 =>
                ftu_active_cr3 <= local_sd_data;
              when others =>
                null;
            end case;          

        when CR_IDLE =>
          sd_busy <= '0';
          
          if (config_start_cc = '1') then
            sd_busy <= '1';
            state_cram_proc <= CR_CONFIG;

          elsif (sd_write = '1') then
            sd_busy <= '1';
            sd_started <= '1';
            sd_ready <= '0';
            local_sd_addr <= sd_addr;
            local_sd_data <= sd_data_in;
            next_state <= CR_IDLE;
            state_cram_proc <= CR_WRITE_START;

          elsif (sd_read = '1') then
            sd_busy <= '1';
            sd_started <= '1';
            sd_ready <= '0';
            local_sd_addr <= sd_addr;
            next_state <= CR_DOUT_WIZ_START;
            state_cram_proc <= CR_READ_START;
          
          elsif (sd_read_ftu = '1') then
            sd_busy <= '1';
            sd_started_ftu <= '1';
            sd_ready <= '0';
            local_sd_addr <= sd_addr_ftu;
            next_state <= CR_DOUT_FTU_START;
            state_cram_proc <= CR_READ_START;
          end if;
          
  
        when CR_DOUT_FTU_START =>
          sd_data_out_ftu <= local_sd_data;
          sd_ready <= '1';
          state_cram_proc <= CR_DOUT_FTU_END;
          
        when CR_DOUT_FTU_END =>
          if (sd_read_ftu <= '0') then
            sd_started_ftu <= '0';
            state_cram_proc <= CR_IDLE;
          end if;
        
        when CR_DOUT_WIZ_START =>
          sd_data_out <= local_sd_data;
          sd_ready <= '1';
          state_cram_proc <= CR_DOUT_WIZ_END;
          
        when CR_DOUT_WIZ_END =>
          if (sd_read <= '0') then
            sd_started <= '0';
            state_cram_proc <= CR_IDLE;
          end if;
                   

        -- --
        -- write to config ram
        -- --
        when CR_WRITE_START =>
          cram_addr_in <= local_sd_addr;
          cram_data_in <= local_sd_data;
          cram_we <= "1";
          state_cram_proc <= CR_WRITE_END;
          
        when CR_WRITE_END =>
          cram_we <= "0";
          if (sd_write = '0') then
            sd_started <= '0';
            sd_ready <= '1';
            state_cram_proc <= next_state;
          end if;

        -- --
        -- read from config ram
        -- --
        when CR_READ_START =>
          cram_addr_out <= local_sd_addr;
          state_cram_proc <= CR_READ_WAIT;
          
        when CR_READ_WAIT =>
          state_cram_proc <= CR_READ_END;
          
        when CR_READ_END =>
          local_sd_data <= cram_data_out;
          state_cram_proc <= next_state;
          
          
      end case;
    end if; -- rising edge
  end process cram_proc;
  
END ARCHITECTURE beha;

