--=======================================================================================
-- TITLE        : Trigger counter top
-- DESCRIPTION  : Top entity for trigger synchronization, detection and counting
-- FILE         : FTU_trigger_counter.vhd
-- COMPANY      : Micro-Cameras & Space Exploration SA
--=======================================================================================
-- CREATION
-- DATE 			AUTHOR 	PROJECT 		REVISION
-- 02/03/2011 JGi     FTM        	110302a
--=======================================================================================
-- MODIFICATION HISTORY
-- DATE 			AUTHOR	PROJECT			REVISION	COMMENTS
-- 02/03/2011 JGi 	 	FTM         110302a 	Description
--=======================================================================================
-- Library Definition
library ieee;
  use ieee.std_logic_1164.all;
  use ieee.numeric_std.all;

-- Entity Definition
entity FTU_trigger_counter is
  port( --clocks
        clk_250MHz					: in  std_logic;
				clk_250MHz_180			: in  std_logic;
				--control
				phys_coinc_window		: in	std_logic_vector(3 downto 0);
				calib_coinc_window	: in	std_logic_vector(3 downto 0);
				active_FTU_list_0		: in	std_logic_vector(9 downto 0);
				active_FTU_list_1		: in	std_logic_vector(9 downto 0);
				active_FTU_list_2		: in	std_logic_vector(9 downto 0);
				active_FTU_list_3		: in	std_logic_vector(9 downto 0);
        --trigger primitives from FTUs
    		trig_prim_0					: in 	std_logic_vector(9 downto 0);  	--crate 0
    		trig_prim_1					: in 	std_logic_vector(9 downto 0);  	--crate 1
    		trig_prim_2					: in 	std_logic_vector(9 downto 0);  	--crate 2
    		trig_prim_3					: in 	std_logic_vector(9 downto 0);  	--crate 3
    		--trigger detection pulses
    		phys_events					: out	std_logic_vector(5 downto 0);
    		calib_events				: out	std_logic_vector(5 downto 0));
end FTU_trigger_counter;

-- Architecture Definition
architecture RTL of FTU_trigger_counter is

	component input_synch is
	  port( clk_250MHz					: in  std_logic;
	        clk_250MHz_180			: in  std_logic;
	    		trig_prim_0					: in 	std_logic_vector(9 downto 0);
	    		trig_prim_1					: in 	std_logic_vector(9 downto 0);
	    		trig_prim_2					: in 	std_logic_vector(9 downto 0);
	    		trig_prim_3					: in 	std_logic_vector(9 downto 0);
	    		trig_synch_0_rise		: out	std_logic_vector(9 downto 0);
	    		trig_synch_1_rise		: out	std_logic_vector(9 downto 0);
	    		trig_synch_2_rise		: out	std_logic_vector(9 downto 0);
	    		trig_synch_3_rise		: out	std_logic_vector(9 downto 0);
	    		trig_synch_0_fall		: out	std_logic_vector(9 downto 0);
	    		trig_synch_1_fall		: out	std_logic_vector(9 downto 0);
	    		trig_synch_2_fall		: out	std_logic_vector(9 downto 0);
	    		trig_synch_3_fall		: out	std_logic_vector(9 downto 0));
	end component;

  signal i_trig_synch_0_rise	: std_logic_vector(9 downto 0);
	signal i_trig_synch_1_rise	: std_logic_vector(9 downto 0);
	signal i_trig_synch_2_rise	: std_logic_vector(9 downto 0);
	signal i_trig_synch_3_rise	: std_logic_vector(9 downto 0);
	signal i_trig_synch_0_fall	: std_logic_vector(9 downto 0);
	signal i_trig_synch_1_fall	: std_logic_vector(9 downto 0);
	signal i_trig_synch_2_fall	: std_logic_vector(9 downto 0);
	signal i_trig_synch_3_fall	: std_logic_vector(9 downto 0);

	component time_window is
	  port( clk_250MHz					: in  std_logic;
	        coinc_window				: in	std_logic_vector(3 downto 0);
	    		active_FTU_list_0		: in 	std_logic_vector(9 downto 0);
	    		active_FTU_list_1		: in 	std_logic_vector(9 downto 0);
	    		active_FTU_list_2		: in 	std_logic_vector(9 downto 0);
	    		active_FTU_list_3		: in 	std_logic_vector(9 downto 0);
	    		trig_synch_0_rise		: in	std_logic_vector(9 downto 0);
	    		trig_synch_1_rise		: in	std_logic_vector(9 downto 0);
	    		trig_synch_2_rise		: in	std_logic_vector(9 downto 0);
	    		trig_synch_3_rise		: in	std_logic_vector(9 downto 0);
	    		trig_synch_0_fall		: in	std_logic_vector(9 downto 0);
	    		trig_synch_1_fall		: in	std_logic_vector(9 downto 0);
	    		trig_synch_2_fall		: in	std_logic_vector(9 downto 0);
	    		trig_synch_3_fall		: in	std_logic_vector(9 downto 0);
	    		trig_window_0				: out	std_logic_vector(9 downto 0);
	    		trig_window_1				: out	std_logic_vector(9 downto 0);
	    		trig_window_2				: out	std_logic_vector(9 downto 0);
	    		trig_window_3				: out	std_logic_vector(9 downto 0));
	end component;

	signal i_trig_phys_window_0		: std_logic_vector(9 downto 0);
	signal i_trig_phys_window_1		: std_logic_vector(9 downto 0);
	signal i_trig_phys_window_2		: std_logic_vector(9 downto 0);
	signal i_trig_phys_window_3		: std_logic_vector(9 downto 0);
	signal i_trig_calib_window_0	: std_logic_vector(9 downto 0);
	signal i_trig_calib_window_1	: std_logic_vector(9 downto 0);
	signal i_trig_calib_window_2	: std_logic_vector(9 downto 0);
	signal i_trig_calib_window_3	: std_logic_vector(9 downto 0);

	component trigger_sum is
	  port( clk_250MHz					: in	std_logic;
	  			trig_window_0				: in	std_logic_vector(9 downto 0);
	  			trig_window_1				: in	std_logic_vector(9 downto 0);
	  			trig_window_2				: in	std_logic_vector(9 downto 0);
	  			trig_window_3				: in	std_logic_vector(9 downto 0);
	        number_of_events		: out	std_logic_vector(5 downto 0));
	end component;

begin

  -- Component instantiation
  inst_synch: input_synch
    port map( clk_250MHz				=> clk_250MHz,
							clk_250MHz_180		=> clk_250MHz_180,
							trig_prim_0				=> trig_prim_0,
							trig_prim_1				=> trig_prim_1,
							trig_prim_2				=> trig_prim_2,
							trig_prim_3				=> trig_prim_3,
							trig_synch_0_rise	=> i_trig_synch_0_rise,
							trig_synch_1_rise	=> i_trig_synch_1_rise,
							trig_synch_2_rise	=> i_trig_synch_2_rise,
							trig_synch_3_rise	=> i_trig_synch_3_rise,
							trig_synch_0_fall	=> i_trig_synch_0_fall,
							trig_synch_1_fall	=> i_trig_synch_1_fall,
							trig_synch_2_fall	=> i_trig_synch_2_fall,
							trig_synch_3_fall	=> i_trig_synch_3_fall);

	inst_phys_window: time_window
		port map( clk_250MHz				=> clk_250MHz,
							coinc_window			=> phys_coinc_window,
							active_FTU_list_0	=> active_FTU_list_0,
							active_FTU_list_1	=> active_FTU_list_1,
							active_FTU_list_2	=> active_FTU_list_2,
							active_FTU_list_3	=> active_FTU_list_3,
							trig_synch_0_rise	=> i_trig_synch_0_rise,
							trig_synch_1_rise	=> i_trig_synch_1_rise,
							trig_synch_2_rise	=> i_trig_synch_2_rise,
							trig_synch_3_rise	=> i_trig_synch_3_rise,
							trig_synch_0_fall	=> i_trig_synch_0_fall,
							trig_synch_1_fall	=> i_trig_synch_1_fall,
							trig_synch_2_fall	=> i_trig_synch_2_fall,
							trig_synch_3_fall	=> i_trig_synch_3_fall,
							trig_window_0			=> i_trig_phys_window_0,
							trig_window_1			=> i_trig_phys_window_1,
							trig_window_2			=> i_trig_phys_window_2,
							trig_window_3			=> i_trig_phys_window_3);

	inst_calib_window: time_window
		port map( clk_250MHz				=> clk_250MHz,
							coinc_window			=> calib_coinc_window,
							active_FTU_list_0	=> active_FTU_list_0,
							active_FTU_list_1	=> active_FTU_list_1,
							active_FTU_list_2	=> active_FTU_list_2,
							active_FTU_list_3	=> active_FTU_list_3,
							trig_synch_0_rise	=> i_trig_synch_0_rise,
							trig_synch_1_rise	=> i_trig_synch_1_rise,
							trig_synch_2_rise	=> i_trig_synch_2_rise,
							trig_synch_3_rise	=> i_trig_synch_3_rise,
							trig_synch_0_fall	=> i_trig_synch_0_fall,
							trig_synch_1_fall	=> i_trig_synch_1_fall,
							trig_synch_2_fall	=> i_trig_synch_2_fall,
							trig_synch_3_fall	=> i_trig_synch_3_fall,
							trig_window_0			=> i_trig_calib_window_0,
							trig_window_1			=> i_trig_calib_window_1,
							trig_window_2			=> i_trig_calib_window_2,
							trig_window_3			=> i_trig_calib_window_3);

	inst_phys_final_sum:	trigger_sum
		port map( clk_250MHz				=> clk_250MHz,
							trig_window_0			=> i_trig_phys_window_0,
							trig_window_1			=> i_trig_phys_window_1,
							trig_window_2			=> i_trig_phys_window_2,
							trig_window_3			=> i_trig_phys_window_3,
							number_of_events	=> phys_events);

	inst_calib_final_sum:	trigger_sum
		port map( clk_250MHz				=> clk_250MHz,
							trig_window_0			=> i_trig_calib_window_0,
							trig_window_1			=> i_trig_calib_window_1,
							trig_window_2			=> i_trig_calib_window_2,
							trig_window_3			=> i_trig_calib_window_3,
							number_of_events	=> calib_events);

end RTL;