--=======================================================================================
-- TITLE        : Sum of physics or calibration triggers
-- DESCRIPTION  : Convert number of inputs to '1' on 40bits to a sum on 6bits.
-- FILE         : trigger_sum.vhd
-- COMPANY      : Micro-Cameras & Space Exploration SA
--=======================================================================================
-- CREATION
-- DATE 			AUTHOR 	PROJECT 		REVISION
-- 07/03/2011 JGi                110307a
--=======================================================================================
-- MODIFICATION HISTORY
-- DATE 			AUTHOR	PROJECT			REVISION	COMMENTS
-- 07/03/2011 JGi 	 	            110307a 	Description
--=======================================================================================
-- Library Definition
library ieee;
  use ieee.std_logic_1164.all;
  use ieee.numeric_std.all;

-- Entity Definition
entity trigger_sum is
  port( --clk
        clk_250MHz				: in  std_logic;
        --inputs
        trig_window_0			: in	std_logic_vector(9 downto 0);
        trig_window_1			: in	std_logic_vector(9 downto 0);
        trig_window_2			: in	std_logic_vector(9 downto 0);
        trig_window_3			: in	std_logic_vector(9 downto 0);
        --output
        number_of_events	: out	std_logic_vector(5 downto 0));
end trigger_sum;

-- Architecture Definition
architecture RTL of trigger_sum is

	component unary_to_binary is
	  port( clk_250MHz	: in  std_logic;
	        vector_in		: in	std_logic_vector(4 downto 0);
	        result			: out	std_logic_vector(2 downto 0));
	end component;

	signal i_bin_to_dec_result_0	: std_logic_vector(2 downto 0);
	signal i_bin_to_dec_result_1	: std_logic_vector(2 downto 0);
	signal i_bin_to_dec_result_2	: std_logic_vector(2 downto 0);
	signal i_bin_to_dec_result_3	: std_logic_vector(2 downto 0);
	signal i_bin_to_dec_result_4	: std_logic_vector(2 downto 0);
	signal i_bin_to_dec_result_5	: std_logic_vector(2 downto 0);
	signal i_bin_to_dec_result_6	: std_logic_vector(2 downto 0);
	signal i_bin_to_dec_result_7	: std_logic_vector(2 downto 0);

	component adder_3_bits is
		port(	a		: in 	std_logic_vector(2 downto 0);
					b		: in 	std_logic_vector(2 downto 0);
					clk	: in 	std_logic;
					s		: out std_logic_vector(3 downto 0));
	end component;

	signal i_add_3_bits_result_0	: std_logic_vector(3 downto 0);
	signal i_add_3_bits_result_1	: std_logic_vector(3 downto 0);
	signal i_add_3_bits_result_2	: std_logic_vector(3 downto 0);
	signal i_add_3_bits_result_3	: std_logic_vector(3 downto 0);

	component adder_4_bits is
		port(	a		: in 	std_logic_vector(3 downto 0);
					b		: in 	std_logic_vector(3 downto 0);
					clk	: in 	std_logic;
					s		: out std_logic_vector(4 downto 0));
	end component;

	signal i_add_4_bits_result_0	: std_logic_vector(4 downto 0);
	signal i_add_4_bits_result_1	: std_logic_vector(4 downto 0);

	component adder_5_bits is
		port(	a		: in 	std_logic_vector(4 downto 0);
					b		: in 	std_logic_vector(4 downto 0);
					clk	: in 	std_logic;
					s		: out std_logic_vector(5 downto 0));
	end component;

begin

	-- Component instantiation
	-- Binary to decimal
	bin_to_dec_0: unary_to_binary
		port map(	clk_250MHz	=> clk_250MHz,
							vector_in		=> trig_window_0(4 downto 0),
							result			=> i_bin_to_dec_result_0);

	bin_to_dec_1: unary_to_binary
		port map(	clk_250MHz	=> clk_250MHz,
							vector_in		=> trig_window_0(9 downto 5),
							result			=> i_bin_to_dec_result_1);

	bin_to_dec_2: unary_to_binary
		port map(	clk_250MHz	=> clk_250MHz,
							vector_in		=> trig_window_1(4 downto 0),
							result			=> i_bin_to_dec_result_2);

	bin_to_dec_3: unary_to_binary
		port map(	clk_250MHz	=> clk_250MHz,
							vector_in		=> trig_window_1(9 downto 5),
							result			=> i_bin_to_dec_result_3);

	bin_to_dec_4: unary_to_binary
		port map(	clk_250MHz	=> clk_250MHz,
							vector_in		=> trig_window_2(4 downto 0),
							result			=> i_bin_to_dec_result_4);

	bin_to_dec_5: unary_to_binary
		port map(	clk_250MHz	=> clk_250MHz,
							vector_in		=> trig_window_2(9 downto 5),
							result			=> i_bin_to_dec_result_5);

	bin_to_dec_6: unary_to_binary
		port map(	clk_250MHz	=> clk_250MHz,
							vector_in		=> trig_window_3(4 downto 0),
							result			=> i_bin_to_dec_result_6);

	bin_to_dec_7: unary_to_binary
		port map(	clk_250MHz	=> clk_250MHz,
							vector_in		=> trig_window_3(9 downto 5),
							result			=> i_bin_to_dec_result_7);

	-- 3 bits adders
	inst_3_bits_add_0: adder_3_bits
		port map( clk	=> clk_250MHz,
							a		=> i_bin_to_dec_result_0,
							b		=> i_bin_to_dec_result_1,
							s		=> i_add_3_bits_result_0);

	inst_3_bits_add_1: adder_3_bits
		port map( clk	=> clk_250MHz,
							a		=> i_bin_to_dec_result_2,
							b		=> i_bin_to_dec_result_3,
							s		=> i_add_3_bits_result_1);
							
	inst_3_bits_add_2: adder_3_bits
		port map( clk	=> clk_250MHz,
							a		=> i_bin_to_dec_result_4,
							b		=> i_bin_to_dec_result_5,
							s		=> i_add_3_bits_result_2);

	inst_3_bits_add_3: adder_3_bits
		port map( clk	=> clk_250MHz,
							a		=> i_bin_to_dec_result_6,
							b		=> i_bin_to_dec_result_7,
							s		=> i_add_3_bits_result_3);

	-- 4 bits adders
	inst_4_bits_add_0: adder_4_bits
		port map( clk	=> clk_250MHz,
							a		=> i_add_3_bits_result_0,
							b		=> i_add_3_bits_result_1,
							s		=> i_add_4_bits_result_0);

	inst_4_bits_add_1: adder_4_bits
		port map( clk	=> clk_250MHz,
							a		=> i_add_3_bits_result_2,
							b		=> i_add_3_bits_result_3,
							s		=> i_add_4_bits_result_1);

	---- Final 5 bits adders
	inst_5_bits_add_0: adder_5_bits
		port map( clk	=> clk_250MHz,
							a		=> i_add_4_bits_result_0,
							b		=> i_add_4_bits_result_1,
							s		=> number_of_events);

end RTL;