--=======================================================================================
-- TITLE        : Binary to decimal converter
-- DESCRIPTION  :	Convert 5bits to the sum on 3bits of the bits to '1' in input vector
-- FILE         : binary_to_decimal.vhd
-- COMPANY      : Micro-Cameras & Space Exploration SA
--=======================================================================================
-- CREATION
-- DATE 			AUTHOR 	PROJECT 		REVISION
-- 07/03/2011 JGi                110307a
--=======================================================================================
-- MODIFICATION HISTORY
-- DATE 			AUTHOR	PROJECT			REVISION	COMMENTS
-- 07/03/2011 JGi 	 	            110307a 	Description
--=======================================================================================
-- Library Definition
library ieee;
  use ieee.std_logic_1164.all;
  use ieee.numeric_std.all;

-- Entity Definition
entity unary_to_binary is
  port( --clock
        clk_250MHz	: in  std_logic;
        --input
        vector_in		: in	std_logic_vector(4 downto 0);
        --output
        result			: out	std_logic_vector(2 downto 0));
end unary_to_binary;

-- Architecture Definition
architecture RTL of unary_to_binary is

  type t_reg is record
    -- Internal register declaration
    -- Ouput register declaration
    result			: std_logic_vector(2 downto 0);
  end record;

  signal i_next_reg : t_reg	:= (result			=> (others => '0'));
  signal i_reg      : t_reg	:= (result			=> (others => '0'));

begin

  -- Combinatorial logic
  process(vector_in, i_reg)
    variable v_reg  : t_reg	:= (result	=> (others => '0'));
  	variable temp_vect_0, temp_vect_1, temp_vect_2, temp_vect_3, temp_vect_4	:	
  						unsigned(2 downto 0)	:= (others => '0');
  begin
    v_reg := i_reg;
    --===================================================================================

    --===================================================================================
    -- Bit count processing
    --===================================================================================
    -- Simulate 5 vectors of 3 bits for the sum
    temp_vect_0	:= "00" & vector_in(0);
    temp_vect_1	:= "00" & vector_in(1);
    temp_vect_2	:= "00" & vector_in(2);
    temp_vect_3	:= "00" & vector_in(3);
    temp_vect_4	:= "00" & vector_in(4);

		-- Sum all the simulated vectors
    v_reg.result	:= std_logic_vector(temp_vect_0	+ temp_vect_1 + temp_vect_2	+
																			temp_vect_3 + temp_vect_4);
    --===================================================================================

    --===================================================================================
    -- Drive register input
    i_next_reg <= v_reg;

    --===================================================================================
    -- Output assignation
		result	<= i_reg.result;
    --===================================================================================
  end process;

  -- Sequential logic
  process(clk_250MHz)
  begin
    if rising_edge(clk_250MHz) then
      i_reg <= i_next_reg;
    end if;
  end process;

end RTL;