--=======================================================================================
-- TITLE        : Input synchronization block
-- DESCRIPTION  : Synchronization of FTUs signals using FPGA DDR input registers
-- FILE         : input_synch.vhd
-- COMPANY      : Micro-Cameras & Space Exploration SA
--=======================================================================================
-- CREATION
-- DATE 			AUTHOR 	PROJECT 		REVISION
-- 02/03/2011 JGi     FTM					110302a
--=======================================================================================
-- MODIFICATION HISTORY
-- DATE 			AUTHOR	PROJECT			REVISION	COMMENTS
-- 02/03/2011 JGi 	 	FTM					110302a 	Description
--=======================================================================================
-- Library Definition
library ieee;
	use ieee.std_logic_1164.all;
	use ieee.std_logic_arith.all;
	use ieee.std_logic_unsigned.all;

library unisim;
	use unisim.vcomponents.all;

-- Entity Definition
entity input_synch is
  port( --clock
        clk_250MHz				: in  std_logic;
        clk_250MHz_180		: in  std_logic;
    		--trigger primitives from FTUs
    		trig_prim_0				: in 	std_logic_vector(9 downto 0);  	--crate 0
    		trig_prim_1				: in 	std_logic_vector(9 downto 0);  	--crate 1
    		trig_prim_2				: in 	std_logic_vector(9 downto 0);  	--crate 2
    		trig_prim_3				: in 	std_logic_vector(9 downto 0);  	--crate 3
    		--synchronized trigger primitives
    		trig_synch_0_rise	: out	std_logic_vector(9 downto 0);  	--crate 0
    		trig_synch_1_rise	: out	std_logic_vector(9 downto 0);  	--crate 1
    		trig_synch_2_rise	: out	std_logic_vector(9 downto 0);		--crate 2
    		trig_synch_3_rise	: out	std_logic_vector(9 downto 0);		--crate 3
    		trig_synch_0_fall	: out	std_logic_vector(9 downto 0);  	--crate 0
    		trig_synch_1_fall	: out	std_logic_vector(9 downto 0);  	--crate 1
    		trig_synch_2_fall	: out	std_logic_vector(9 downto 0);		--crate 2
    		trig_synch_3_fall	: out	std_logic_vector(9 downto 0));	--crate 3
end input_synch;

-- Architecture Definition
architecture RTL of input_synch is

	type t_reg is record
    -- Internal register declaration
    -- Ouput register declaration
    trig_synch_0_rise	: std_logic_vector(9 downto 0);
    trig_synch_1_rise	: std_logic_vector(9 downto 0);
    trig_synch_2_rise	: std_logic_vector(9 downto 0);
    trig_synch_3_rise	: std_logic_vector(9 downto 0);
    trig_synch_0_fall	: std_logic_vector(9 downto 0);
    trig_synch_1_fall	: std_logic_vector(9 downto 0);
    trig_synch_2_fall	: std_logic_vector(9 downto 0);
    trig_synch_3_fall	: std_logic_vector(9 downto 0);
  end record;

  signal i_trig_synch_0_rise	: std_logic_vector(9 downto 0)	:= (others => '0');
  signal i_trig_synch_1_rise	: std_logic_vector(9 downto 0)	:= (others => '0');
  signal i_trig_synch_2_rise	: std_logic_vector(9 downto 0)	:= (others => '0');
  signal i_trig_synch_3_rise	: std_logic_vector(9 downto 0)	:= (others => '0');
  signal i_trig_synch_0_fall	: std_logic_vector(9 downto 0)	:= (others => '0');
  signal i_trig_synch_1_fall	: std_logic_vector(9 downto 0)	:= (others => '0');
  signal i_trig_synch_2_fall	: std_logic_vector(9 downto 0)	:= (others => '0');
  signal i_trig_synch_3_fall	: std_logic_vector(9 downto 0)	:= (others => '0');

  signal i_next_reg : t_reg	:= (trig_synch_0_rise => (others => '0'),
  															trig_synch_1_rise	=> (others => '0'),
  															trig_synch_2_rise	=> (others => '0'),
  															trig_synch_3_rise	=> (others => '0'),
  															trig_synch_0_fall => (others => '0'),
  															trig_synch_1_fall	=> (others => '0'),
  															trig_synch_2_fall	=> (others => '0'),
  															trig_synch_3_fall	=> (others => '0'));
  signal i_reg      : t_reg	:= (trig_synch_0_rise => (others => '0'),
  															trig_synch_1_rise	=> (others => '0'),
  															trig_synch_2_rise	=> (others => '0'),
  															trig_synch_3_rise	=> (others => '0'),
  															trig_synch_0_fall => (others => '0'),
  															trig_synch_1_fall	=> (others => '0'),
  															trig_synch_2_fall	=> (others => '0'),
  															trig_synch_3_fall	=> (others => '0'));

begin

  -- Input DDR flip-flops instantiation for crate 0
  input_ddr_0: for i in 0 to 9 generate
		iddr2_inst_trig_synch_0 : IDDR2
			generic map(DDR_ALIGNMENT	=> "NONE",			-- sets output alignment to "none", "c0", "c1"
		   						INIT_Q0				=> '0', 				-- sets initial state of the q0 output to '0' or '1'
		   						INIT_Q1				=> '0', 				-- sets initial state of the q1 output to '0' or '1'
		   						SRTYPE				=> "SYNC")			-- specifies "sync" or "async" set/reset
			port map( Q0	=> i_trig_synch_0_rise(i),	-- 1-bit output captured with c0 clock
		   					Q1 	=> i_trig_synch_0_fall(i), 	-- 1-bit output captured with c1 clock
		   					C0 	=> clk_250mhz, 							-- 1-bit clock input
		   					C1 	=> clk_250mhz_180, 					-- 1-bit clock input
		   					CE 	=> '1',  										-- 1-bit clock enable input
		   					D 	=> trig_prim_0(i),					-- 1-bit data input
		   					R 	=> '0',    									-- 1-bit reset input
		   					S 	=> '0');     								-- 1-bit set input
	end generate input_ddr_0;

  -- Input DDR flip-flops instantiation for crate 1
  input_ddr_1: for i in 0 to 9 generate
		iddr2_inst_trig_synch_1 : IDDR2
			generic map(DDR_ALIGNMENT	=> "NONE",
		   						INIT_Q0				=> '0',
		   						INIT_Q1				=> '0',
		   						SRTYPE				=> "SYNC")
			port map( Q0	=> i_trig_synch_1_rise(i),
		   					Q1 	=> i_trig_synch_1_fall(i),
		   					C0 	=> clk_250mhz,
		   					C1 	=> clk_250mhz_180,
		   					CE 	=> '1',
		   					D 	=> trig_prim_1(i),
		   					R 	=> '0',
		   					S 	=> '0');
	end generate input_ddr_1;

  -- Input DDR flip-flops instantiation for crate 2
  input_ddr_2: for i in 0 to 9 generate
		iddr2_inst_trig_synch_2 : IDDR2
			generic map(DDR_ALIGNMENT	=> "NONE",
		   						INIT_Q0				=> '0',
		   						INIT_Q1				=> '0',
		   						SRTYPE				=> "SYNC")
			port map( Q0	=> i_trig_synch_2_rise(i),
		   					Q1 	=> i_trig_synch_2_fall(i),
		   					C0 	=> clk_250mhz,
		   					C1 	=> clk_250mhz_180,
		   					CE 	=> '1',
		   					D 	=> trig_prim_2(i),
		   					R 	=> '0',
		   					S 	=> '0');
	end generate input_ddr_2;

  -- Input DDR flip-flops instantiation for crate 3
  input_ddr_3: for i in 0 to 9 generate
		iddr2_inst_trig_synch_3 : IDDR2
			generic map(DDR_ALIGNMENT	=> "NONE",
		   						INIT_Q0				=> '0',
		   						INIT_Q1				=> '0',
		   						SRTYPE				=> "SYNC")
			port map( Q0	=> i_trig_synch_3_rise(i),
		   					Q1 	=> i_trig_synch_3_fall(i),
		   					C0 	=> clk_250mhz,
		   					C1 	=> clk_250mhz_180,
		   					CE 	=> '1',
		   					D 	=> trig_prim_3(i),
		   					R 	=> '0',
		   					S 	=> '0');
	end generate input_ddr_3;

  -- Combinatorial logic
  process(i_trig_synch_0_rise, i_trig_synch_1_rise, i_trig_synch_2_rise,
  				i_trig_synch_3_rise, i_trig_synch_0_fall, i_trig_synch_1_fall,
  				i_trig_synch_2_fall, i_trig_synch_3_fall, i_reg)
    variable v_reg  : t_reg	:= (trig_synch_0_rise => (others => '0'),
  															trig_synch_1_rise	=> (others => '0'),
  															trig_synch_2_rise	=> (others => '0'),
  															trig_synch_3_rise	=> (others => '0'),
  															trig_synch_0_fall => (others => '0'),
  															trig_synch_1_fall	=> (others => '0'),
  															trig_synch_2_fall	=> (others => '0'),
  															trig_synch_3_fall	=> (others => '0'));
  begin
    v_reg := i_reg;
    --===================================================================================

    --===================================================================================
    -- Delay management for rising edge data
    --===================================================================================
    v_reg.trig_synch_0_rise	:= i_trig_synch_0_rise;
		v_reg.trig_synch_1_rise	:= i_trig_synch_1_rise;
		v_reg.trig_synch_2_rise	:= i_trig_synch_2_rise;
		v_reg.trig_synch_3_rise	:= i_trig_synch_3_rise;
    --===================================================================================

    --===================================================================================
    -- Delay management for falling edge data
    --===================================================================================
    v_reg.trig_synch_0_fall	:= i_trig_synch_0_fall;
		v_reg.trig_synch_1_fall	:= i_trig_synch_1_fall;
		v_reg.trig_synch_2_fall	:= i_trig_synch_2_fall;
		v_reg.trig_synch_3_fall	:= i_trig_synch_3_fall;
    --===================================================================================

    --===================================================================================
    -- Drive register input
    i_next_reg <= v_reg;

    --===================================================================================
    -- Output assignation
		trig_synch_0_rise	<= i_reg.trig_synch_0_rise;
		trig_synch_1_rise	<= i_reg.trig_synch_1_rise;
		trig_synch_2_rise	<= i_reg.trig_synch_2_rise;
		trig_synch_3_rise	<= i_reg.trig_synch_3_rise;
		trig_synch_0_fall	<= i_reg.trig_synch_0_fall;
		trig_synch_1_fall	<= i_reg.trig_synch_1_fall;
		trig_synch_2_fall	<= i_reg.trig_synch_2_fall;
		trig_synch_3_fall	<= i_reg.trig_synch_3_fall;
    --===================================================================================
  end process;

  -- Sequential logic
  process(clk_250MHz)
  begin
    if rising_edge(clk_250MHz) then
      i_reg <= i_next_reg;
    end if;
  end process;

end RTL;