--=======================================================================================
-- TITLE        : Interface synchronization to 250MHz
-- DESCRIPTION  : Synchronize incoming settings to the 250MHz clock
-- FILE         : interface_sync_250MHz.vhd
-- COMPANY      : Micro-Cameras & Space Exploration SA
--=======================================================================================
-- CREATION
-- DATE 			AUTHOR 	PROJECT 		REVISION
-- 11/03/2011 JGi                110311a
--=======================================================================================
-- MODIFICATION HISTORY
-- DATE 			AUTHOR	PROJECT			REVISION	COMMENTS
-- 11/03/2011 JGi 	 	            110311a 	Description
--=======================================================================================
-- Library Definition
library ieee;
  use ieee.std_logic_1164.all;
  use ieee.numeric_std.all;

-- Entity Definition
entity interface_sync_250MHz is
  port( --clock
  			clk_250MHz							: in  std_logic;
  			--inputs
    		start_run         			: in 	std_logic;
    		stop_run          			: in 	std_logic;
				new_config							: in	std_logic;
    		general_settings   			: in 	std_logic_vector(15 downto 0);
    		LP_and_PED_freq    			: in 	std_logic_vector(15 downto 0);
    		LP1_LP2_PED_ratio  			: in 	std_logic_vector(15 downto 0);
    		maj_coinc_n_phys   			: in 	std_logic_vector(15 downto 0);
    		maj_coinc_n_calib  			: in 	std_logic_vector(15 downto 0);
    		trigger_delay      			: in 	std_logic_vector(15 downto 0);
    		TIM_delay          			: in 	std_logic_vector(15 downto 0);
    		dead_time          			: in 	std_logic_vector(15 downto 0);
    		coinc_window_phys  			: in 	std_logic_vector(15 downto 0);
    		coinc_window_calib			: in 	std_logic_vector(15 downto 0);
    		active_FTU_list_0  			: in 	std_logic_vector(15 downto 0);
    		active_FTU_list_1  			: in 	std_logic_vector(15 downto 0);
    		active_FTU_list_2  			: in 	std_logic_vector(15 downto 0);
    		active_FTU_list_3  			: in 	std_logic_vector(15 downto 0);
    		--outputs
    		config_done							: out	std_logic;
    		sync_start_run         	:	out	std_logic;
    		sync_stop_run          	:	out	std_logic;
    		sync_general_settings   :	out	std_logic_vector(7 downto 0);
    		sync_LP_and_PED_freq    :	out	std_logic_vector(9 downto 0);
    		sync_LP1_LP2_PED_ratio  :	out	std_logic_vector(14 downto 0);
    		sync_maj_coinc_n_phys   :	out	std_logic_vector(5 downto 0);
    		sync_maj_coinc_n_calib	:	out	std_logic_vector(5 downto 0);
    		sync_trigger_delay      :	out	std_logic_vector(9 downto 0);
    		sync_TIM_delay          :	out	std_logic_vector(9 downto 0);
    		sync_dead_time          :	out	std_logic_vector(15 downto 0);
    		sync_coinc_window_phys  :	out	std_logic_vector(3 downto 0);
    		sync_coinc_window_calib	:	out	std_logic_vector(3 downto 0);
    		sync_active_FTU_list_0  :	out	std_logic_vector(9 downto 0);
    		sync_active_FTU_list_1  :	out	std_logic_vector(9 downto 0);
    		sync_active_FTU_list_2  :	out	std_logic_vector(9 downto 0);
    		sync_active_FTU_list_3  :	out	std_logic_vector(9 downto 0));
end interface_sync_250MHz;

-- Architecture Definition
architecture RTL of interface_sync_250MHz is

  type t_reg is record
    -- Internal register declaration
    -- Ouput register declaration
    config_done								: std_logic_vector(1 downto 0);
    sync_0_start_run         	:	std_logic;
    sync_1_start_run         	:	std_logic;
		sync_0_stop_run          	:	std_logic;
		sync_1_stop_run          	:	std_logic;
		sync_0_new_config					:	std_logic;
		sync_1_new_config					:	std_logic;
		sync_0_general_settings   :	std_logic_vector(7 downto 0);
		sync_1_general_settings   :	std_logic_vector(7 downto 0);
		sync_0_LP_and_PED_freq    :	std_logic_vector(9 downto 0);
		sync_1_LP_and_PED_freq    :	std_logic_vector(9 downto 0);
		sync_0_LP1_LP2_PED_ratio  :	std_logic_vector(14 downto 0);
		sync_1_LP1_LP2_PED_ratio  :	std_logic_vector(14 downto 0);
		sync_0_maj_coinc_n_phys   :	std_logic_vector(5 downto 0);
		sync_1_maj_coinc_n_phys   :	std_logic_vector(5 downto 0);
		sync_0_maj_coinc_n_calib	:	std_logic_vector(5 downto 0);
		sync_1_maj_coinc_n_calib	:	std_logic_vector(5 downto 0);
		sync_0_trigger_delay      :	std_logic_vector(9 downto 0);
		sync_1_trigger_delay      :	std_logic_vector(9 downto 0);
		sync_0_TIM_delay          :	std_logic_vector(9 downto 0);
		sync_1_TIM_delay          :	std_logic_vector(9 downto 0);
		sync_0_dead_time          :	std_logic_vector(15 downto 0);
		sync_1_dead_time          :	std_logic_vector(15 downto 0);
		sync_0_coinc_window_phys  :	std_logic_vector(3 downto 0);
		sync_1_coinc_window_phys  :	std_logic_vector(3 downto 0);
		sync_0_coinc_window_calib	:	std_logic_vector(3 downto 0);
		sync_1_coinc_window_calib	:	std_logic_vector(3 downto 0);
		sync_0_active_FTU_list_0  :	std_logic_vector(9 downto 0);
		sync_1_active_FTU_list_0  :	std_logic_vector(9 downto 0);
		sync_0_active_FTU_list_1  :	std_logic_vector(9 downto 0);
		sync_1_active_FTU_list_1  :	std_logic_vector(9 downto 0);
		sync_0_active_FTU_list_2  :	std_logic_vector(9 downto 0);
		sync_1_active_FTU_list_2  :	std_logic_vector(9 downto 0);
		sync_0_active_FTU_list_3  :	std_logic_vector(9 downto 0);
		sync_1_active_FTU_list_3  :	std_logic_vector(9 downto 0);
  end record;

  signal i_next_reg	: t_reg	:= (config_done								=> (others => '0'),
																sync_0_start_run         	=> '0',
																sync_1_start_run         	=> '0',
																sync_0_stop_run          	=> '0',
																sync_1_stop_run          	=> '0',
																sync_0_new_config					=> '0',
																sync_1_new_config					=> '0',
																sync_0_general_settings   => (others => '0'),
																sync_1_general_settings   => (others => '0'),
																sync_0_LP_and_PED_freq    => (others => '0'),
																sync_1_LP_and_PED_freq    => (others => '0'),
																sync_0_LP1_LP2_PED_ratio  => (others => '0'),
																sync_1_LP1_LP2_PED_ratio  => (others => '0'),
																sync_0_maj_coinc_n_phys   => (others => '1'),
																sync_1_maj_coinc_n_phys   => (others => '1'),
																sync_0_maj_coinc_n_calib	=> (others => '1'),
																sync_1_maj_coinc_n_calib	=> (others => '1'),
																sync_0_trigger_delay      => (others => '0'),
																sync_1_trigger_delay      => (others => '0'),
																sync_0_TIM_delay          => (others => '0'),
																sync_1_TIM_delay          => (others => '0'),
																sync_0_dead_time          => (others => '0'),
																sync_1_dead_time          => (others => '0'),
																sync_0_coinc_window_phys  => (others => '0'),
																sync_1_coinc_window_phys  => (others => '0'),
																sync_0_coinc_window_calib	=> (others => '0'),
																sync_1_coinc_window_calib	=> (others => '0'),
																sync_0_active_FTU_list_0  => (others => '0'),
																sync_1_active_FTU_list_0  => (others => '0'),
																sync_0_active_FTU_list_1  => (others => '0'),
																sync_1_active_FTU_list_1  => (others => '0'),
																sync_0_active_FTU_list_2  => (others => '0'),
																sync_1_active_FTU_list_2  => (others => '0'),
																sync_0_active_FTU_list_3  => (others => '0'),
																sync_1_active_FTU_list_3  => (others => '0'));
  signal i_reg			: t_reg	:= (config_done								=> (others => '0'),
																sync_0_start_run         	=> '0',
																sync_1_start_run         	=> '0',
																sync_0_stop_run          	=> '0',
																sync_1_stop_run          	=> '0',
																sync_0_new_config					=> '0',
																sync_1_new_config					=> '0',
																sync_0_general_settings   => (others => '0'),
																sync_1_general_settings   => (others => '0'),
																sync_0_LP_and_PED_freq    => (others => '0'),
																sync_1_LP_and_PED_freq    => (others => '0'),
																sync_0_LP1_LP2_PED_ratio  => (others => '0'),
																sync_1_LP1_LP2_PED_ratio  => (others => '0'),
																sync_0_maj_coinc_n_phys   => (others => '1'),
																sync_1_maj_coinc_n_phys   => (others => '1'),
																sync_0_maj_coinc_n_calib	=> (others => '1'),
																sync_1_maj_coinc_n_calib	=> (others => '1'),
																sync_0_trigger_delay      => (others => '0'),
																sync_1_trigger_delay      => (others => '0'),
																sync_0_TIM_delay          => (others => '0'),
																sync_1_TIM_delay          => (others => '0'),
																sync_0_dead_time          => (others => '0'),
																sync_1_dead_time          => (others => '0'),
																sync_0_coinc_window_phys  => (others => '0'),
																sync_1_coinc_window_phys  => (others => '0'),
																sync_0_coinc_window_calib	=> (others => '0'),
																sync_1_coinc_window_calib	=> (others => '0'),
																sync_0_active_FTU_list_0  => (others => '0'),
																sync_1_active_FTU_list_0  => (others => '0'),
																sync_0_active_FTU_list_1  => (others => '0'),
																sync_1_active_FTU_list_1  => (others => '0'),
																sync_0_active_FTU_list_2  => (others => '0'),
																sync_1_active_FTU_list_2  => (others => '0'),
																sync_0_active_FTU_list_3  => (others => '0'),
																sync_1_active_FTU_list_3  => (others => '0'));

begin

  -- Component instantiation

  -- Combinatorial logic
  process(start_run, stop_run, new_config, general_settings, LP_and_PED_freq,
  				LP1_LP2_PED_ratio, maj_coinc_n_phys, maj_coinc_n_calib, trigger_delay,
  				TIM_delay, dead_time, coinc_window_phys, coinc_window_calib, active_FTU_list_0,
  				active_FTU_list_1, active_FTU_list_2, active_FTU_list_3, i_reg)
    variable v_reg  : t_reg	:= (config_done								=> (others => '0'),
																sync_0_start_run         	=> '0',
																sync_1_start_run         	=> '0',
																sync_0_stop_run          	=> '0',
																sync_1_stop_run          	=> '0',
																sync_0_new_config					=> '0',
																sync_1_new_config					=> '0',
																sync_0_general_settings   => (others => '0'),
																sync_1_general_settings   => (others => '0'),
																sync_0_LP_and_PED_freq    => (others => '0'),
																sync_1_LP_and_PED_freq    => (others => '0'),
																sync_0_LP1_LP2_PED_ratio  => (others => '0'),
																sync_1_LP1_LP2_PED_ratio  => (others => '0'),
																sync_0_maj_coinc_n_phys   => (others => '1'),
																sync_1_maj_coinc_n_phys   => (others => '1'),
																sync_0_maj_coinc_n_calib	=> (others => '1'),
																sync_1_maj_coinc_n_calib	=> (others => '1'),
																sync_0_trigger_delay      => (others => '0'),
																sync_1_trigger_delay      => (others => '0'),
																sync_0_TIM_delay          => (others => '0'),
																sync_1_TIM_delay          => (others => '0'),
																sync_0_dead_time          => (others => '0'),
																sync_1_dead_time          => (others => '0'),
																sync_0_coinc_window_phys  => (others => '0'),
																sync_1_coinc_window_phys  => (others => '0'),
																sync_0_coinc_window_calib	=> (others => '0'),
																sync_1_coinc_window_calib	=> (others => '0'),
																sync_0_active_FTU_list_0  => (others => '0'),
																sync_1_active_FTU_list_0  => (others => '0'),
																sync_0_active_FTU_list_1  => (others => '0'),
																sync_1_active_FTU_list_1  => (others => '0'),
																sync_0_active_FTU_list_2  => (others => '0'),
																sync_1_active_FTU_list_2  => (others => '0'),
																sync_0_active_FTU_list_3  => (others => '0'),
																sync_1_active_FTU_list_3  => (others => '0'));
  begin
    v_reg := i_reg;
    --===================================================================================

    --===================================================================================
    -- Double synchronization of incoming signals
    --===================================================================================
    -- Double synchonize command signals
		v_reg.sync_0_start_run	:= start_run;
		v_reg.sync_1_start_run	:= i_reg.sync_0_start_run;
		v_reg.sync_0_stop_run		:= stop_run;
		v_reg.sync_1_stop_run		:= i_reg.sync_0_stop_run;
		v_reg.sync_0_new_config	:= new_config;
		v_reg.sync_1_new_config	:= i_reg.sync_0_new_config;

		v_reg.config_done(0)	:= '0';
		v_reg.config_done(1)	:= i_reg.config_done(0);

		-- If new configuration is received, register settings
		if i_reg.sync_1_new_config = '1' then
			v_reg.config_done(0)						:= '1';
			v_reg.sync_0_general_settings   := general_settings(7 downto 0);
			v_reg.sync_0_LP_and_PED_freq    := LP_and_PED_freq(9 downto 0);
			v_reg.sync_0_LP1_LP2_PED_ratio  := LP1_LP2_PED_ratio(14 downto 0);
			v_reg.sync_0_maj_coinc_n_phys   := maj_coinc_n_phys(5 downto 0);
			v_reg.sync_0_maj_coinc_n_calib	:= maj_coinc_n_calib(5 downto 0);
			v_reg.sync_0_trigger_delay      := trigger_delay(9 downto 0);
			v_reg.sync_0_TIM_delay          := TIM_delay(9 downto 0);
			v_reg.sync_0_dead_time          := dead_time(15 downto 0);
			v_reg.sync_0_coinc_window_phys  := coinc_window_phys(3 downto 0);
			v_reg.sync_0_coinc_window_calib	:= coinc_window_calib(3 downto 0);
			v_reg.sync_0_active_FTU_list_0  := active_FTU_list_0(9 downto 0);
			v_reg.sync_0_active_FTU_list_1  := active_FTU_list_1(9 downto 0);
			v_reg.sync_0_active_FTU_list_2  := active_FTU_list_2(9 downto 0);
			v_reg.sync_0_active_FTU_list_3  := active_FTU_list_3(9 downto 0);
		end if;
		v_reg.sync_1_general_settings   := i_reg.sync_0_general_settings;
		v_reg.sync_1_LP_and_PED_freq    := i_reg.sync_0_LP_and_PED_freq;
		v_reg.sync_1_LP1_LP2_PED_ratio  := i_reg.sync_0_LP1_LP2_PED_ratio;
		v_reg.sync_1_maj_coinc_n_phys   := i_reg.sync_0_maj_coinc_n_phys;
		v_reg.sync_1_maj_coinc_n_calib	:= i_reg.sync_0_maj_coinc_n_calib;
		v_reg.sync_1_trigger_delay      := i_reg.sync_0_trigger_delay;
		v_reg.sync_1_TIM_delay          := i_reg.sync_0_TIM_delay;
		v_reg.sync_1_dead_time          := i_reg.sync_0_dead_time;
		v_reg.sync_1_coinc_window_phys  := i_reg.sync_0_coinc_window_phys;
		v_reg.sync_1_coinc_window_calib	:= i_reg.sync_0_coinc_window_calib;
		v_reg.sync_1_active_FTU_list_0  := i_reg.sync_0_active_FTU_list_0;
		v_reg.sync_1_active_FTU_list_1  := i_reg.sync_0_active_FTU_list_1;
		v_reg.sync_1_active_FTU_list_2  := i_reg.sync_0_active_FTU_list_2;
		v_reg.sync_1_active_FTU_list_3  := i_reg.sync_0_active_FTU_list_3;
    --===================================================================================

    --===================================================================================
    -- Drive register input
    i_next_reg <= v_reg;

    --===================================================================================
    -- Output assignation
    config_done							<= i_reg.config_done(1);
		sync_start_run         	<= i_reg.sync_1_start_run;
		sync_stop_run          	<= i_reg.sync_1_stop_run;
		sync_general_settings   <= i_reg.sync_1_general_settings;
		sync_LP_and_PED_freq    <= i_reg.sync_1_LP_and_PED_freq;
		sync_LP1_LP2_PED_ratio  <= i_reg.sync_1_LP1_LP2_PED_ratio;
		sync_maj_coinc_n_phys   <= i_reg.sync_1_maj_coinc_n_phys;
		sync_maj_coinc_n_calib	<= i_reg.sync_1_maj_coinc_n_calib;
		sync_trigger_delay      <= i_reg.sync_1_trigger_delay;
		sync_TIM_delay          <= i_reg.sync_1_TIM_delay;
		sync_dead_time          <= i_reg.sync_1_dead_time;
		sync_coinc_window_phys  <= i_reg.sync_1_coinc_window_phys;
		sync_coinc_window_calib	<= i_reg.sync_1_coinc_window_calib;
		sync_active_FTU_list_0  <= i_reg.sync_1_active_FTU_list_0;
		sync_active_FTU_list_1  <= i_reg.sync_1_active_FTU_list_1;
		sync_active_FTU_list_2  <= i_reg.sync_1_active_FTU_list_2;
		sync_active_FTU_list_3  <= i_reg.sync_1_active_FTU_list_3;
    --===================================================================================
  end process;

  -- Sequential logic
  process(clk_250MHz)
  begin
  	if rising_edge(clk_250MHz) then
      i_reg <= i_next_reg;
    end if;
  end process;

end RTL;