--=======================================================================================
-- TITLE        : Timer
-- DESCRIPTION  : Timer for time coincidence windows
-- FILE         : time_counter.vhd
-- COMPANY      : Micro-Cameras & Space Exploration SA
--=======================================================================================
-- CREATION
-- DATE 			AUTHOR 	PROJECT 		REVISION
-- 02/03/2011 JGi     FTM        110302a
--=======================================================================================
-- MODIFICATION HISTORY
-- DATE 			AUTHOR	PROJECT			REVISION	COMMENTS
-- 02/03/2011 JGi 	 	FTM         110302a 	Description
--=======================================================================================
-- Library Definition
library ieee;
  use ieee.std_logic_1164.all;
  use ieee.numeric_std.all;

-- Entity Definition
entity time_counter is
  port( --clock
        clk_250MHz	: in  std_logic;
        --control
        enable			: in	std_logic;
        window			: in	std_logic_vector(3 downto 0);
        --I/O
        start_rise	: in	std_logic;
        start_fall	: in	std_logic;
        counting		:	out	std_logic);
end time_counter;

-- Architecture Definition
architecture RTL of time_counter is

  type t_reg is record
    -- Internal register declaration
    enable		: std_logic;
    started		: std_logic;
    done			: std_logic;
    window		: unsigned(3 downto 0);
    counter		: unsigned(3 downto 0);
    -- Ouput register declaration
    counting	: std_logic;
  end record;

  signal i_next_reg : t_reg	:= (enable		=> '0',
  															started		=> '0',
  															done			=> '0',
  															window		=> (others => '0'),
  															counter		=> (others => '0'),
  															counting	=> '0');
  signal i_reg      : t_reg	:= (enable		=> '0',
  															started		=> '0',
  															done			=> '0',
  															window		=> (others => '0'),
  															counter		=> (others => '0'),
  															counting	=> '0');

begin

  -- Combinatorial logic
  process(enable, window, start_rise, start_fall, i_reg)
    variable v_reg  : t_reg	:= (enable		=> '0',
  															started		=> '0',
  															done			=> '0',
  															window		=> (others => '0'),
  															counter		=> (others => '0'),
  															counting	=> '0');
  begin
    v_reg := i_reg;
    --===================================================================================

    --===================================================================================
    -- Counter management
    --===================================================================================
    -- Register activation signal (From active FTU list)
    v_reg.enable	:= enable;
    -- Register window width to improve speed
    v_reg.window	:= unsigned(window);
    -- Register enables to detect rising edges on them
    v_reg.started	:= start_rise or start_fall;

		-- Counter is counting permanently
		v_reg.counter	:= i_reg.counter+1;

		-- If enabled and input rising edge, reset counter
    if i_reg.enable = '1' and (start_rise = '1' or start_fall = '1') and
    i_reg.started = '0' then
    	v_reg.counting	:= '1';
    	v_reg.counter		:= (others => '0');
    end if;

		v_reg.done	:= '0';
		-- If inputs rised and counter reahc the value then done
		if i_reg.counter = i_reg.window and i_reg.counting = '1' then
    	v_reg.done	:= '1';
    end if;

		-- Disable counter comparison if done
    if i_reg.done = '1' then
    	v_reg.counting	:= '0';
    end if;
    --===================================================================================

    --===================================================================================
    -- Drive register input
    i_next_reg <= v_reg;

    --===================================================================================
    -- Output assignation
		counting	<= i_reg.counting;
    --===================================================================================
  end process;

  -- Sequential logic
  process(clk_250MHz)
  begin
    if rising_edge(clk_250MHz) then
      i_reg <= i_next_reg;
    end if;
  end process;

end RTL;