--=======================================================================================
-- TITLE        : Time window
-- DESCRIPTION  : Time window generation for trigger detection
-- FILE         : time_window.vhd
-- COMPANY      : Micro-Cameras & Space Exploration SA
--=======================================================================================
-- CREATION
-- DATE 			AUTHOR 	PROJECT 		REVISION
-- 02/03/2011 JGi     FTM        	110302a
--=======================================================================================
-- MODIFICATION HISTORY
-- DATE 			AUTHOR	PROJECT			REVISION	COMMENTS
-- 02/03/2011 JGi 	 	FTM         110302a 	Description
--=======================================================================================
-- Library Definition
library ieee;
  use ieee.std_logic_1164.all;
  use ieee.numeric_std.all;

-- Entity Definition
entity time_window is
  port( --clock
        clk_250MHz				: in  std_logic;
        --control signal
        coinc_window			: in	std_logic_vector(3 downto 0);
    		active_FTU_list_0	: in 	std_logic_vector(9 downto 0);
    		active_FTU_list_1	: in 	std_logic_vector(9 downto 0);
    		active_FTU_list_2	: in 	std_logic_vector(9 downto 0);
    		active_FTU_list_3	: in 	std_logic_vector(9 downto 0);
    		--trigger detection pulses
    		trig_synch_0_rise	: in	std_logic_vector(9 downto 0);		--crate 0
    		trig_synch_1_rise	: in	std_logic_vector(9 downto 0);		--crate 1
    		trig_synch_2_rise	: in	std_logic_vector(9 downto 0);		--crate 2
    		trig_synch_3_rise	: in	std_logic_vector(9 downto 0);		--crate 3
    		trig_synch_0_fall	: in	std_logic_vector(9 downto 0);		--crate 0
    		trig_synch_1_fall	: in	std_logic_vector(9 downto 0);		--crate 1
    		trig_synch_2_fall	: in	std_logic_vector(9 downto 0);		--crate 2
    		trig_synch_3_fall	: in	std_logic_vector(9 downto 0);		--crate 3
    		--programmed width pulses
    		trig_window_0			: out	std_logic_vector(9 downto 0);		--crate 0
    		trig_window_1			: out	std_logic_vector(9 downto 0);		--crate 1
    		trig_window_2			: out	std_logic_vector(9 downto 0);		--crate 2
    		trig_window_3			: out	std_logic_vector(9 downto 0));	--crate 3
end time_window;

-- Architecture Definition
architecture RTL of time_window is

	component time_counter is
	  port( clk_250MHz	: in  std_logic;
	        enable			: in	std_logic;
	        window			: in	std_logic_vector(3 downto 0);
	        start_rise	: in	std_logic;
	        start_fall	: in	std_logic;
	        counting		:	out	std_logic);
	end component;

begin

  -- Component instantiation
  ftu_list_0: for i in 0 to 9 generate
  	time_counter_inst_0: time_counter
  		port map( clk_250MHz	=> clk_250MHz,
								enable			=> active_FTU_list_0(i),
								window			=> coinc_window,
								start_rise	=> trig_synch_0_rise(i),
								start_fall	=> trig_synch_0_fall(i),
								counting		=> trig_window_0(i));
  end generate ftu_list_0;

  ftu_list_1: for i in 0 to 9 generate
  	time_counter_inst_1: time_counter
  		port map( clk_250MHz	=> clk_250MHz,
								enable			=> active_FTU_list_1(i),
								window			=> coinc_window,
								start_rise	=> trig_synch_1_rise(i),
								start_fall	=> trig_synch_1_fall(i),
								counting		=> trig_window_1(i));
  end generate ftu_list_1;

  ftu_list_2: for i in 0 to 9 generate
  	time_counter_inst_2: time_counter
  		port map( clk_250MHz	=> clk_250MHz,
								enable			=> active_FTU_list_2(i),
								window			=> coinc_window,
								start_rise	=> trig_synch_2_rise(i),
								start_fall	=> trig_synch_2_fall(i),
								counting		=> trig_window_2(i));
  end generate ftu_list_2;

  ftu_list_3: for i in 0 to 9 generate
  	time_counter_inst_3: time_counter
  		port map( clk_250MHz	=> clk_250MHz,
								enable			=> active_FTU_list_3(i),
								window			=> coinc_window,
								start_rise	=> trig_synch_3_rise(i),
								start_fall	=> trig_synch_3_fall(i),
								counting		=> trig_window_3(i));
  end generate ftu_list_3;

end RTL;