#ifndef FACT_MessageImp
#define FACT_MessageImp

#include <string>
#include <sstream>
#include <iostream>

class Time;

class MessageImp
{
public:
    /// Severity of a message
    enum Severity
    {
        kMessage = 10, ///< Just a message, usually obsolete
        kInfo    = 20, ///< An info telling something which can be interesting to know
        kWarn    = 30, ///< A warning, things that somehow might result in unexpected or unwanted bahaviour
        kError   = 40, ///< Error, something unexpected happened, but can still be handled by the program
        kFatal   = 50, ///< An error which cannot be handled at all happend, the only solution is program termination
        kDebug   = 99, ///< A message used for debugging only
    };

private:
    std::ostream &fOut; /// The ostream to which by default Write redirects its output

public:
    MessageImp(std::ostream &out=std::cout);

    virtual int Write(const Time &time, const std::string &txt, int qos=kInfo);

    int Update(const std::string &str, int qos=kInfo);
    int Update(const char *txt, int qos=kInfo) { return Update(std::string(txt), qos); }
    int Update(const std::stringstream &str, int qos=kInfo) { return Update(str.str(), qos); }
    int Update(int qos, const char *fmt, ...);

    int Debug(const std::string &str)    { return Update(str, kDebug);   }
    int Message(const std::string &str)  { return Update(str, kMessage); }
    int Info(const std::string &str)     { return Update(str, kInfo);    }
    int Warn(const std::string &str)     { return Update(str, kWarn);    }
    int Error(const std::string &str)    { return Update(str, kError);   }
    int Fatal(const std::string &str)    { return Update(str, kFatal);   }

    int Debug(const char *txt)   { return Debug(std::string(txt));   }
    int Message(const char *txt) { return Message(std::string(txt)); }
    int Info(const char *txt)    { return Info(std::string(txt));    }
    int Warn(const char *txt)    { return Warn(std::string(txt));    }
    int Error(const char *txt)   { return Error(std::string(txt));   }
    int Fatal(const char *txt)   { return Fatal(std::string(txt));   }

    int Debug(const std::stringstream &str)   { return Debug(str.str()); }
    int Message(const std::stringstream &str) { return Message(str.str()); }
    int Info(const std::stringstream &str)    { return Info(str.str());    }
    int Warn(const std::stringstream &str)    { return Warn(str.str());    }
    int Error(const std::stringstream &str)   { return Error(str.str());   }
    int Fatal(const std::stringstream &str)   { return Fatal(str.str());   }

    std::ostream &operator()() const { return fOut; }
    std::ostream &Out() const { return fOut; }
};

#endif
