#ifndef FACT_StateMachineDim
#define FACT_StateMachineDim

#include "MessageDim.h"       // MessageDimTX
#include "StateMachine.h"     // StateMachien

// ***************************************************************************
/**
 @class DimStart

 @brief Ensures calling DimServer::start() in its constructor and DimServer::stop() in its destructor

**/
// ***************************************************************************
#include "DimErrorRedirecter.h"

class DimStart : public DimErrorRedirecter
{
protected:
    DimStart(const std::string &name, MessageImp &imp) : DimErrorRedirecter(imp)
    {
        DimServer::addErrorHandler(this);
        DimServer::start(name.c_str());
    }
    ~DimStart() { DimServer::stop(); }
};

class StateMachineDim : public DimCommandHandler, public DimExitHandler, public StateMachine, public DimStart
{
private:
    MessageDimTX fLog;           /// Logging to the Dim network

    static const int fVersion;   /// Version number

    DimService fSrvState;        /// DimService offering fCurrentState
    DimService fSrvVersion;      /// DimService offering fVersion

    void exitHandler(int code);  /// Overwritten DimCommand::exitHandler.
    void commandHandler();       /// Overwritten DimCommand::commandHandler 

    /// Redirect our own logging to fLog
    int Write(const Time &time, const std::string &txt, int qos);

    /// This is an internal function to do some action in case of
    /// a state change, like updating the corresponding service.
    std::string SetCurrentState(int state, const char *txt="", const std::string &cmd="");

    EventImp *CreateEvent(int targetstate, const char *name, const char *fmt);

public:
    StateMachineDim(std::ostream &out=std::cout, const std::string &name="DEFAULT");
};

#endif
