#ifndef FACT_DimServiceInfoList
#define FACT_DimServiceInfoList

#include <map>
#include <vector>
#include <string>

#include "State.h"
#include "Description.h"
#include "DimServerList.h"

class DimInfo;

class DimServiceInfoList : public DimServerList
{
public:

    typedef std::map<const std::string, std::vector<DimInfo*>> ServiceInfoList;

    //                   Format   IsCmd
    typedef std::pair<std::string, bool> ServiceType;

    //                 name of service  Format/description
    typedef std::map<const std::string, ServiceType> TypeList;

    //                 ServiceName                 comment      list of descriptions
    typedef std::map<const std::string, std::pair<std::string, std::vector<Description>>> DescriptionList;

    struct ServerInfo
    {
        TypeList           first;   /// Format and description of the service
        DescriptionList    second;  /// Description of the arguments
        std::vector<State> third;   /// Available states of teh server
    };

    //                   Server         ServerInfo
    typedef std::map<const std::string, ServerInfo> ServiceList;

private:
    ServiceInfoList fServiceInfoList; /// A map storing the service description to retrieve all informations
    ServiceList     fServiceList;     /// A mal containing all the available informations

    DimInfo *CreateDimInfo(const std::string &str, const std::string &svc) const;
    DimInfo *CreateSL(const std::string &str) const { return CreateDimInfo(str, "SERVICE_LIST"); }
    DimInfo *CreateFMT(const std::string &str) const { return CreateDimInfo(str, "SERVICE_DESC"); }
    DimInfo *CreateDS(const std::string &str) const { return CreateDimInfo(str, "STATE_LIST"); }

protected:
    void AddServer(const std::string &s);
    void RemoveServer(const std::string &s);
    void RemoveAllServers();

    virtual void AddService(const std::string &server, const std::string &service, const std::string &fmt, bool iscmd)
    {
    }
    virtual void RemoveService(const std::string &server, const std::string &service, bool iscmd)
    {
    }
    virtual void RemoveAllServices(const std::string &server)
    {
    }

    virtual void AddDescription(const std::string &server, const std::string &service, const std::vector<Description> &vec)
    {
    }

    virtual void AddStates(const std::string &server, const std::vector<State> &vec)
    {
    }

protected:
    void infoHandler();

public:
    DimServiceInfoList() { }
    ~DimServiceInfoList() { RemoveAllServers(); }

    std::vector<std::string> GetServiceList(bool iscmd=false) const;
    std::vector<std::string> GetServiceList(const std::string &server, bool iscmd=false) const;

    std::vector<std::string> GetCommandList() const { return GetServiceList(true); }
    std::vector<std::string> GetCommandList(const std::string &server) const { return GetServiceList(server, true); }

    std::vector<Description> GetDescription(const std::string &server, const std::string &service) const;
    std::vector<State>       GetStates(const std::string &server) const;
    State                    GetState(const std::string &server, int state) const;

    int IsCommand(const std::string &server, const std::string &service) const;

    int PrintDescription(std::ostream &out, bool iscmd, const std::string &serv="", const std::string &svc="") const;
    int PrintStates(std::ostream &out, const std::string &serv="") const;

    bool SendDimCommand(std::ostream &lout, const std::string &server, const std::string &str) const;
    void SendDimCommand(const std::string &server, std::string str, std::ostream &lout) const;
    void SendDimCommand(const std::string &server, const std::string &str) const;
};

#endif
