#ifndef FACT_DimServerList
#define FACT_DimServerList

#include <vector>
#include <string>

#include "dic.hxx"

class DimServerList : public DimClient
{
public:
    typedef std::vector<std::string> ServerList;

private:
    DimInfo    fDimServers;  /// A DimInfo to retrieve the SERVER_LIST from teh DNS server
    ServerList fServerList;  /// A list with the available servers

    virtual void AddServer(const std::string &) { };
    virtual void RemoveServer(const std::string &) { };
    virtual void RemoveAllServers() { };

protected:
    void infoHandler();

public:
    DimServerList();

    /// @returns a reference to the list of servers
    const ServerList &GetServerList() const { return fServerList; }

    /// @returns whether the given server is in the list or not
    /// @param server string with the server which availability should be checked
    bool HasServer(const std::string &server) const;
};

#endif
