#include "DockWindow.h"

#include <QtGui/QDockWidget>

#include <stdexcept>

using namespace std;

DockWindow::DockWindow(QDockWidget *d, const QString &name)
    : fDockWidget(d), fGeometry(d->geometry())
{
    QObject *w0 = d->parent();   // QWidget
    if (!w0)
        throw runtime_error("1st parent of QDockWidget is NULL");

    QObject *w1 = w0->parent();  // QWidget
    if (!w1)
        throw runtime_error("2nd parent of QDockWidget is NULL");

    QObject *w2 = w1->parent();  // QWidget
    if (!w2)
            throw runtime_error("3rd parent of QDockWidget is NULL");

    fTabWidget = dynamic_cast<QTabWidget*>(w2);
    if (!fTabWidget)
        throw runtime_error("3rd parent of QDockWidget is not a QTabWidget");

    setGeometry(fGeometry);
    addDockWidget(Qt::LeftDockWidgetArea, fDockWidget);
    setWindowTitle(name);
}

void DockWindow::closeEvent(QCloseEvent *)
{
    QWidget *w = new QWidget;

    fTabWidget->addTab(w, windowTitle());

    fDockWidget->setParent(w);
    fDockWidget->setGeometry(fGeometry);

    fTabWidget->setTabsClosable(true);
}
