--
-- VHDL Architecture FACT_FTM_lib.dd_write_general_modul.beha
--
-- Created:
--          by - kai.UNKNOWN (E5PCXX)
--          at - 11:27:33 02.03.2011
--
-- using Mentor Graphics HDL Designer(TM) 2009.1 (Build 12)
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE IEEE.STD_LOGIC_UNSIGNED.all;
-- LIBRARY FACT_FTM_lib;
-- USE FACT_FTM_lib.ftm_array_types.all;
-- USE FACT_FTM_lib.ftm_constants.all;
library ftm_definitions;
USE ftm_definitions.ftm_array_types.all;
USE ftm_definitions.ftm_constants.all;

ENTITY dd_write_general_modul IS
PORT(
  clk                       : IN std_logic;
  dd_write_general          : IN std_logic;
  dd_write_general_started  : OUT std_logic := '0';
  dd_write_general_ready    : OUT std_logic := '0';
  dd_busy            : IN      std_logic;
  dd_write           : OUT     std_logic := '0';
  dd_started         : IN      std_logic;
  dd_ready           : IN      std_logic;
  dd_addr            : OUT     std_logic_vector (11 DOWNTO 0) := (others => '0');
  dd_data            : OUT     std_logic_vector (15 DOWNTO 0) := (others => '0')
  );
END ENTITY dd_write_general_modul;

--
ARCHITECTURE beha OF dd_write_general_modul IS

  type state_write_general_proc_type is (WGP_INIT, WGP_CONFIG, WGP_IDLE, WGP_WRITE_COUNTER_01, WGP_WRITE_COUNTER_02, WGP_WRITE_COUNTER_03,
                                         WGP_WRITE_TEMP_01, WGP_WRITE_TEMP_02, WGP_WRITE_TEMP_03, WGP_WRITE_TEMP_04, WGP_WRITE_READY, WRITE_TO_DD_ADDR);
  type state_write_dd_type is (WRITE_DD_START, WRITE_DD_WAIT, WRITE_DD_END);

  signal state_write_general_proc : state_write_general_proc_type := WGP_INIT;
  signal next_state_dd : state_write_general_proc_type := WGP_INIT;
  signal state_write_dd : state_write_dd_type := WRITE_DD_START;

  signal local_dd_addr : std_logic_vector (11 DOWNTO 0) := (others => '0');
  signal local_dd_data : std_logic_vector (15 DOWNTO 0) := (others => '0');

  signal on_time_counter  : std_logic_vector (47 DOWNTO 0) := X"333322221111";
  signal temp_sensor_0    : std_logic_vector (15 DOWNTO 0) := X"00FF";
  signal temp_sensor_1    : std_logic_vector (15 DOWNTO 0) := X"11FF";
  signal temp_sensor_2    : std_logic_vector (15 DOWNTO 0) := X"22FF";
  signal temp_sensor_3    : std_logic_vector (15 DOWNTO 0) := X"33FF";

BEGIN
  write_general_proc : process (clk)
  begin
    if rising_edge (clk) then
      case state_write_general_proc is
      
        when WGP_INIT =>
          state_write_general_proc <= WGP_CONFIG;
          
        when WGP_CONFIG =>
          state_write_general_proc <= WGP_IDLE;
          
        when WGP_IDLE =>
          if (dd_write_general = '1') then
            dd_write_general_started <= '1';
            dd_write_general_ready <= '0';
            state_write_general_proc <= WGP_WRITE_COUNTER_01;
          end if;
          
        when WGP_WRITE_COUNTER_01 =>
          local_dd_addr <= X"000";
          local_dd_data <= on_time_counter (47 DOWNTO 32);
          next_state_dd <= WGP_WRITE_COUNTER_02;
          state_write_general_proc <= WRITE_TO_DD_ADDR;
        
        when WGP_WRITE_COUNTER_02 =>
          local_dd_addr <= X"001";
          local_dd_data <= on_time_counter (31 DOWNTO 16);
          next_state_dd <= WGP_WRITE_COUNTER_03;
          state_write_general_proc <= WRITE_TO_DD_ADDR;
        
        when WGP_WRITE_COUNTER_03 =>
          local_dd_addr <= X"002";
          local_dd_data <= on_time_counter (15 DOWNTO 0);
          next_state_dd <= WGP_WRITE_TEMP_01;
          state_write_general_proc <= WRITE_TO_DD_ADDR;
        
        when WGP_WRITE_TEMP_01 =>
          local_dd_addr <= X"003";
          local_dd_data <= temp_sensor_0;
          next_state_dd <= WGP_WRITE_TEMP_02;
          state_write_general_proc <= WRITE_TO_DD_ADDR;
        
        when WGP_WRITE_TEMP_02 =>
          local_dd_addr <= X"004";
          local_dd_data <= temp_sensor_1;
          next_state_dd <= WGP_WRITE_TEMP_03;
          state_write_general_proc <= WRITE_TO_DD_ADDR;
        
        when WGP_WRITE_TEMP_03 =>
          local_dd_addr <= X"005";
          local_dd_data <= temp_sensor_2;
          next_state_dd <= WGP_WRITE_TEMP_04;
          state_write_general_proc <= WRITE_TO_DD_ADDR;
        
        when WGP_WRITE_TEMP_04 =>
          local_dd_addr <= X"006";
          local_dd_data <= temp_sensor_3;
          next_state_dd <= WGP_WRITE_READY;
          state_write_general_proc <= WRITE_TO_DD_ADDR;
          
        when WGP_WRITE_READY =>
          if (dd_write_general = '0') then
            dd_write_general_started <= '0';
            dd_write_general_ready <= '1';
            state_write_general_proc <= WGP_IDLE;
          end if;
        
        -- write to dynamic data block
        when WRITE_TO_DD_ADDR =>
          case state_write_dd is
            when WRITE_DD_START =>
              if (dd_busy = '0') then
                dd_addr <= local_dd_addr;
                dd_data <= local_dd_data;
                dd_write <= '1';
                state_write_dd <= WRITE_DD_WAIT;
              end if;
            when WRITE_DD_WAIT =>
              if (dd_started = '1') then
                dd_write <= '0';
                state_write_dd <= WRITE_DD_END;
              end if;
            when WRITE_DD_END =>
              if (dd_ready = '1') then
                state_write_dd <= WRITE_DD_START;
                state_write_general_proc <= next_state_dd;
              end if;
          end case;
        
      end case;
    end if;
  end process write_general_proc;

END ARCHITECTURE beha;
