#ifndef FADBoard_H_SEEN
#define FADBoard_H_SEEN

#include <ctype.h>
#include <time.h>
#include <math.h>
#include <errno.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/time.h>

#include <stdlib.h>
#include <string.h>
#include <iostream>
#include <algorithm>
#include <sys/socket.h>
#include <netdb.h>

#include "FAD.h"
#include "FADFormat.h"

const unsigned int READ_BUFFER_SIZE = 1000000;
const unsigned int STATUS_SIZE = 200;

class FADBoard: public DimThread {

	class FAD *m;
	int Socket;
	pthread_mutex_t Mutex;
	DimService *DIM_Name, *DIM_Status, *DIM_ID, *DIM_Frequency;
	DimService *DIM_Rate, *DIM_Temp, *DIM_ROI, *DIM_DAC;

	void ReadLoop();
	static void LaunchThread(class FADBoard *);
	void threadHandler();
	void SetStatus(const char *, ...);

  public: 
    FADBoard(std::string, unsigned short, class FAD *, unsigned int);
    ~FADBoard();

	struct BoardStatus {
	  uint16_t BoardID;
	  uint64_t DNA;
	  uint16_t FirmwareRevision;
	  uint32_t BoardTime;
	  uint32_t EventCounter;

	  char Message[STATUS_SIZE];
	  struct timeval Update;
	  float Rate;

	  uint32_t TriggerID;
	  uint32_t Runnumber;
	  uint16_t TriggerType;
	  uint16_t TriggerCRC;
	  uint16_t TriggerCell[NChips];

	  float Frequency;
	  bool Lock[NChips];
	  int8_t PhaseShift;

	  bool denable;
	  bool dwrite;
	  bool DCM_lock;
	  bool DCM_ready;
	  bool spi_clk;

	  uint16_t ROI[NChips][NChannels];
	  uint16_t DAC[NDAC];
	  float Temp[NTemp];
	} Status;

	short Data[NChips][NChannels][NBins];
	long int Sum[NChips][NChannels][NBins];

	struct CalibData {
	  uint64_t DNA;
	  short Baseline[NChips][NChannels][NBins];
	  double Gain[NChips][NChannels][NBins];
	  double Secondary[NChips][NChannels][NBins];
	  float Temp;
	  float Frequency;
	  time_t Time;
	} ACalib;

	void Send(const void *, size_t);
	void Send(unsigned short);
	struct BoardStatus GetStatus();
	void AmplitudeCalibration();
	void Lock();
	void Unlock();

	unsigned short Port;
	char *Name;
	bool CommOK;
	bool Active;
	bool Continue;
	pthread_t Thread;
	pthread_cond_t CondVar;
	
    // Amplitude calibration
   	int Count;  

  private:
	enum StateType {standbye, baseline, gain, secondary, cleanup, wait};
	struct BoardStatus InitialStatus;
	StateType State;
};

#endif
