#include "MainWindow.h"

#include <iostream>

#include "dic.hxx"

#include "DockWindow.h"
#include "HtmlDelegate.h"
#include "CheckBoxDelegate.h"

using namespace std;

MainWindow::MainWindow(QWidget *p) : QMainWindow(p)
{
    // setupUi MUST be called before the DimNetwork is initilized
    // In this way it can be ensured that nothing from the
    // DimNetwork arrives before all graphical elements are
    // initialized. This is a simple but very powerfull trick.
    setupUi(this);

    // Now here we can do further setup which should be done
    // before the gui is finally displayed.
    fDimCmdServers->setItemDelegate(new CheckBoxDelegate);
    fDimCmdCommands->setItemDelegate(new CheckBoxDelegate);
    fDimCmdDescription->setItemDelegate(new HtmlDelegate);

    fDimSvcServers->setItemDelegate(new CheckBoxDelegate);
    fDimSvcServices->setItemDelegate(new CheckBoxDelegate);
    fDimSvcDescription->setItemDelegate(new HtmlDelegate);

    fStatusBar->showMessage(PACKAGE_STRING"   |   "PACKAGE_URL"   |   report bugs to <"PACKAGE_BUGREPORT">");

    fFtuLED[0] = fFtuLEDPrototype;

    for (int i=1; i<40; i++)
    {
        QPushButton *b = new QPushButton(static_cast<QWidget*>(fFtuLEDPrototype->parent()));

        b->setEnabled(fFtuLEDPrototype->isEnabled());
        b->setSizePolicy(fFtuLEDPrototype->sizePolicy());
        b->setMaximumSize(fFtuLEDPrototype->maximumSize());
        b->setIcon(fFtuLEDPrototype->icon());
        b->setIconSize(fFtuLEDPrototype->iconSize());
        b->setCheckable(fFtuLEDPrototype->isCheckable());
        b->setFlat(fFtuLEDPrototype->isFlat());

        fFtuLedLayout->addWidget(b, i/10+1, i%10+1, 1, 1);

        fFtuLED[i] = b;
    }

    for (int i=0; i<40; i++)
    {
        fFtuLED[i]->setObjectName(QString::fromUtf8("fFtuLED")+QString::number(i));
        QObject::connect(fFtuLED[i], SIGNAL(clicked()), this, SLOT(slot_fFtuLED_clicked()));
    }
}

void MainWindow::SelectTab(const QString &name)
{
    for (int i=0; i<fTabWidget->count(); i++)
        if (fTabWidget->tabText(i)==name)
        {
            fTabWidget->setCurrentIndex(i);
            break;
        }
}

void MainWindow::on_fShutdown_clicked()
{
    DimClient::sendCommand("DIS_DNS/KILL_SERVERS", NULL, 0);
}


void MainWindow::on_fShutdownAll_clicked()
{
    DimClient::sendCommand("DIS_DNS/KILL_SERVERS", NULL, 0);
    DimClient::sendCommand("DIS_DNS/EXIT",         1);
}

void MainWindow::on_fTabWidget_tabCloseRequested(int which)
{
    // To get the correct size we have to switch to this tab
    // An alternative would be to take the size of the current tab
    fTabWidget->setCurrentIndex(which);

    QWidget *w = fTabWidget->currentWidget(); //fTabWidget->widget(which);
    if (!w)
    {
        cout << "Weird... the tab requested to be closed doesn't exist!" << endl;
        return;
    }

    QDockWidget *d = w->findChild<QDockWidget*>();
    if (!d)
    {
        cout << "Sorry, tab requested to be closed contains no QDockWidget!" << endl;
        return;
    }

    new DockWindow(d, fTabWidget->tabText(which));
    fTabWidget->removeTab(which);

    if (fTabWidget->count()==1)
        fTabWidget->setTabsClosable(false);
}


void MainWindow::on_fChatSend_clicked()
{
    if (DimClient::sendCommand("CHAT/MSG", fChatMessage->displayText().toStdString().c_str()))
        fChatMessage->clear();
}

void MainWindow::on_fStatusLoggerLed_clicked()
{
    SelectTab("Logger");
}

void MainWindow::on_fStatusChatLed_clicked()
{
    SelectTab("Chat");
}

void MainWindow::on_fStatusFTMLed_clicked()
{
    SelectTab("Trigger");
}

void MainWindow::slot_fFtuLED_clicked()
{
    for (int i=0; i<40; i++)
        if (sender()==fFtuLED[i])
            cout << "--------------> clicked #" << i << endl;
}

void MainWindow::on_fPing_toggled(bool checked)
{
    if (checked)
        DimClient::sendCommand("FTM_CONTROL/PING", NULL, 0);
}
