#include <iostream>
#include "PeriodicSignal.H"
#include <stdio.h>
//for signals
#include <sigc++/signal_system.h>
using namespace SigC;
class Counter:public Object
{
public:
    int max;
    int count;
    int incr;
    
    Counter(int max_, int incr_)
            :max(max_),incr(incr_),count(0)
        {};
    void isIncrementPossible()
        {
            count+=incr;
//            cout<<"Counter by "<<incr<<" to "<<max<<" is at "<<count<<"\n";
            printf("Counter by %d to %d  is at %d\n",incr,max,count);
        };
    void PrintIAmDone()
        {
            cout<<"Counter by "<<incr<<" to "<<max<<" is done!"<<"\n";
        };
    
};
bool end;

void endMe()
{
    end=true;
}

int main()
{
    end=false;
    Counter byTwo(100,25), byThree(100,33);
    
    PeriodicSignal byTwoEachSec(1000000);
    byTwoEachSec.signal.connect(slot(byTwo,&Counter::isIncrementPossible));
    byTwoEachSec.Start();
    
    PeriodicSignal byThreeEachTwoSec(2000000);
    byThreeEachTwoSec.signal.connect(slot(byThree,&Counter::isIncrementPossible));
    byThreeEachTwoSec.Start();
    
    while(!end){
    }
    

    return 0;
}
