//-----------------------------------------------------------------------------
#include "typedefs.h"
#include "application.h"
#include "spi_master.h"
#include "ad7719_adc.h"
#include "atmega_adc.h"    
#include "usart.h"
#include "macros.h"
#include "muxer_fsc.h"
#include "output.h"
#include "parser.h"
#include "interpol.h"
#include "w5100_spi_interface.h"
#include <avr/interrupt.h>
#include <avr/wdt.h>
#include <stdlib.h>
//-----------------------------------------------------------------------------
// definition of some functions:
// these function are implemented in this file, this is not doog coding style.
// sooner or later, they will be moved into more apropriate files.

void parse(); //doesn't do anything at the moment

// end of function definition:
//-----------------------------------------------------------------------------


// MAIN WORKFLOW GLOBAL VARIABLES
	bool verbose;
	bool heartbeat_enable;

// USART global variables
	U08 usart_rx_buffer[USART_RX_BUFFER_SIZE];
	U08 usart_tx_buffer[USART_TX_BUFFER_SIZE];
	U08 usart_rx_buffer_index = 0;
	U08 usart_tx_buffer_index = 0;
  	U08 usart_last_char; 					// last received char

// USART FLAGS
	bool usart_tx_buffer_overflow = false;	// true if usart_tx_buffer was full.
	//bool usart_rx_ready = false;			// EOL was received, parser needs to be called
	
// TIMER global variable
	volatile U32 local_ms = 0;

// AD7719 global variables
	U32 ad7719_values[TEMP_CHANNELS];
	U08 ad7719_enables[CHANNEL_BITMAP];
	U08 ad7719_channels_ready[CHANNEL_BITMAP];
	U08 ad7719_readings_since_last_muxing = 0;
	U08 ad7719_current_channel = 0;
	U32 ad7719_current_reading = 0;
	bool ad7719_measured_all = false;
	
// ATMEGA ADC global variables
	U08 adc_values[V_CHANNELS + I_CHANNELS + H_CHANNELS]; // stores measured voltage in steps of 16mV
	U08 adc_enables[V_BITMAP + I_BITMAP + H_BITMAP];
	U08 adc_channels_ready[V_BITMAP + I_BITMAP + H_BITMAP];
	U08 adc_readings_since_last_muxing = 0;
	U08 adc_current_channel = 0;
	U08 adc_current_reading = 0;
	bool adc_measured_all = false;

	bool once_told_you = true;
	bool debug_mode = false;
	
#ifndef ___MAIN_WORKFLOW_GLOBAL_VARS
#define ___MAIN_WORKFLOW_GLOBAL_VARS	
	#define TEMP_CHANNELS 64
	#define CHANNEL_BITMAP 8
	#define AD7719_READINGS_UNTIL_SETTLED 1 // bei3:480ms
	#define V_CHANNELS 40
	#define I_CHANNELS 40
	#define H_CHANNELS 4
	#define V_BITMAP 5
	#define I_BITMAP 5
	#define H_BITMAP 1
	#define ADC_READINGS_UNTIL_SETTLED 1
	
#endif // ___MAIN_WORKFLOW_GLOBAL_VARS


//-----------------------------------------------------------------------------
//   M A I N    ---   M A I N    ---   M A I N    ---   M A I N    ---  M A I N    
//-----------------------------------------------------------------------------
int main(void)
{
	U08 register_content;

	app_init();		  // Setup: Watchdog and I/Os
	usart_init();

	spi_init(); 		// Initialize SPI interface as master
	
// TIMER2 is used as local clock:
// configure timer 2
	TCCR2 = (1<<WGM21); // CTC Modus
	TCCR2 |= (1<<CS21) | (1<<CS20); // Prescaler 64 --> counts up every 8us
	OCR2 = 125-1; 					// --> output compare interrupt occurs every 125 x 8us = 1ms
	// Compare Interrupt erlauben
	TIMSK |= (1<<OCIE2);

  //  Enable interrupts
  sei();              

	usart_write_str((pU08)"Start of test firmware (06.05.11) now:\n");
	if (local_ms % 10000 == 0) {
		usart_write_str((pU08)"time: ");
		usart_write_U32(local_ms/1000,6);
		usart_write_str((pU08)"sec.\n");
	}

  PORTB &= ~(1<<PB2); //#reset = LOW --> W5100 is in reset ... 
	_delay_ms(50); //reset
	
	PORTB |= 1<<PB2; //#reset = HIGH --> W5100 is active
	_delay_ms(5);		// give it 5ms to accomodate.
	
	
//	DDRB |= (1 << PB2);  // setze 5tes bit im data direction register von port B
//	DDRB |= (1 << PB3);  // setze 5tes bit im data direction register von port B
//	DDRB |= (1 << PB4);  // setze 5tes bit im data direction register von port B
	
	while (1)
	{ 
		PORTB ^= (1<<PB4);  // toggle zustand vom 5ten bit in Port B
		PORTB ^= (1<<PB3);  // toggle zustand vom 5ten bit in Port B
		PORTB ^= (1<<PB2);  // toggle zustand vom 5ten bit in Port B
		
	_delay_ms(1); //reset
		
	}
	
	
	while (1) {
	usart_write_str((pU08)"Start to read from W5300 CM_RTR0 register at:");
	usart_write_U32(local_ms,10);
	usart_write_str((pU08)"ms.\n");
	
	register_content = w5100_read(CM_RTR0); // read something
	
	usart_write_str((pU08)"register content of CM_RTR0 retrieved at:");
	usart_write_U32(local_ms,10);
	usart_write_str((pU08)"ms.\t");
	usart_write_str((pU08)"register content is: 0x");
	usart_write_U08_hex(register_content);
	usart_write_str((pU08)"\n");
	
	
	_delay_ms(400); //reset
	_delay_ms(400); //reset
	_delay_ms(400); //reset
}
	
	
	usart_write_str((pU08)"W5300 init begins at:");
	usart_write_U32(local_ms,10);
	usart_write_str((pU08)"ms.\n");
	
	w5100_init();
 
 
 
 

	
} // end of main()	
	
/*
//MAIN LOOP
while (1)
{
	if (heartbeat_enable) PORTB ^= (1<<PB3); // toggle Out2_spare --> heartbeat
//----------------------------------------------------------------------------
	//IF we need to send away one byte, and ready to send

	if ( (usart_tx_buffer_index > 0) && (UCSRA & (1<<UDRE)) ) { 
		UDR = usart_tx_buffer[0];
		// THis is shit
		for (U08 i=0 ; i < USART_TX_BUFFER_SIZE; ++i) {
			usart_tx_buffer[i] = usart_tx_buffer[i+1];
		}
		usart_tx_buffer_index--;
	}
//----------------------------------------------------------------------------

	//IF we just received one byte, and there is enough space in the RX_buffer
	if ( (UCSRA & (1<<RXC)) && (usart_rx_buffer_index < USART_RX_BUFFER_SIZE) ){
		usart_last_char = UDR;
		if (usart_last_char == '\n'){ // if EOL was received
			usart_rx_ready = true;
		}else {
		usart_rx_buffer[usart_rx_buffer_index] = usart_last_char;
		usart_rx_buffer_index++;
		}
		// here is still something strange .... better send an enter automatically
	} else if (UCSRA & (1<<RXC)) { // if there is no scace in the buffer; read anyway.
		usart_last_char = UDR;
		usart_rx_buffer_index =0;
	}
//----------------------------------------------------------------------------

	//IF USART DOR bit is set, PC is sending data to fast!!!
	if ( UCSRA & (1<<DOR) ){
		// flush TX_buffer and write warning message in
		// maybe even switch off every measurement. ?
	}
//----------------------------------------------------------------------------

	//IF TX_BUFFER was overrun.	
	if (usart_tx_buffer_overflow) {
		// flash TX_buffer and write warning message in
		// maybe even switch off every measurement. ?
		//
		// this should only happen, in verbose mode and with low baudrates.
	}
//----------------------------------------------------------------------------
	
	//IF one command was received. 
	//	-It is not allowed to send more than one command between two '\n'
	if (usart_rx_ready){ 
		parse();
		usart_rx_buffer_index = 0;
		usart_rx_ready = false;
	}
//----------------------------------------------------------------------------

	//IF ATmega internal ADC did finish a conversion --every 200us
	if ( (ADCSRA & (1<<ADIF)) && !adc_measured_all) {
		adc_current_reading = ADCH;
		if (adc_readings_since_last_muxing == ADC_READINGS_UNTIL_SETTLED) {
			adc_values[adc_current_channel] = adc_current_reading;
			adc_readings_since_last_muxing=0;
			// note that this channel is ready, now and 
			adc_output(adc_current_channel, adc_current_reading);
			// proceed to the next enabled channel.
			adc_channels_ready[adc_current_channel/8] |= (1<<(adc_current_channel%8));
			adc_current_channel = increase_adc (adc_current_channel);
			Set_V_Muxer(adc_current_channel);
		} else { // the ADC did not settle yet, we discard the reading
			++adc_readings_since_last_muxing;
			// current reading is not used for anything else
		}
	}
//----------------------------------------------------------------------------

	//IF AD7719 ADC just finished a conversion -- every 60ms
	
	if (AD7719_IS_READY()) {
			ad7719_current_reading = read_adc(); // --takes at 4MHz SCLK speed about 6us
		// AD7719 is only read out if settled. saves time.	
		if (ad7719_readings_since_last_muxing == AD7719_READINGS_UNTIL_SETTLED) {
			ad7719_values[ad7719_current_channel] = ad7719_current_reading;
			ad7719_readings_since_last_muxing=0;
			// now prepare the data to be send away via USART.
			//ad7719_output(ad7719_current_channel, ad7719_current_reading);
			// note that this channel is ready, now and 
			// proceed to the next enabled channel.
			ad7719_channels_ready[ad7719_current_channel/8] |= (1<<(ad7719_current_channel%8));
			ad7719_current_channel = increase_ad7719 (ad7719_current_channel);
			Set_T_Muxer(ad7719_current_channel);
		} else { // the AD7719 did not settle yet, we discard the reading
			++ad7719_readings_since_last_muxing;

			// current reading is not used for anything else
		}
	}
//----------------------------------------------------------------------------
	//IF one of the ADC measured all channels, we wanted to know.
	check_if_measured_all();
	
	if (ad7719_measured_all && adc_measured_all)
		adc_output_all();

//----------------------------------------------------------------------------

//	if (verbose == true)
		// talk() was just defined so the 
		// code is not at this place ... look down.
//		talk();


} // end of MAIN LOOP
//-----------------------------------------------------------------------------
//    E N D     E N D     E N D     E N D     E N D     E N D     E N D     
//-----------------------------------------------------------------------------

*/



ISR (TIMER2_COMP_vect)
{
 ++local_ms;
}




