//-----------------------------------------------------------------------------

#include "application.h"
#include "usart.h"
#include <avr/wdt.h> 


//-----------------------------------------------------------------------------

volatile U08 app_reset_source;
//-----------------------------------------------------------------------------

void app_init(void) {
  app_reset_source = MCUSR; // Save last reset source
  MCUSR = 0x00; // Clear reset source for next reset cycle


	// Dangerous here: I still do not know much about the watchdog.
	// This code is still from Udo Juerss. 

  // The watchdog timer is disabled by default ("startup.asm")
	#ifdef USE_WATCHDOG
	 WDTCSR = WDTOE | (1 << WDE); // Enable watchdog reset (~16ms)
	#endif

	// define PORTS
	// USART
	DDRD &= ~(1<<PD0);				// PD0 = RXD is input
	DDRD |= 1<<PD1; 					// PD1 = TXD is output
	

	// SPARE OUT/-INPUTS
	DDRB |= (1<<PB2) | (1<<PB3); 	// set Out1_spare & out2_spare as outputs
	DDRA &= ~(1<<PA7);				// set In1_spare as input
	DDRC &= ~(1<<PC7);				// set In2_spare as input
	//PORTA |= (1<<PA7); 				// swtich on pullup on In1_spare
	//PORTC |= (1<<PC7); 				// swtich on pullup on In2_spare

	// ATmega internal ADC input 
	DDRA &= ~(1<<PA6);

	// MUXER ADDRESS OUTs
	DDRA |= 0x3F; // SA-pins -> output
	DDRC |= 0x7F; // SB-pins -> output

	// SPI
	// set all CS's: output
	DDRB |= (1 << SPI_E_CS);
	DDRD |= (1 << SPI_AD_CS) |(1 << SPI_M_CS) |(1 << SPI_A_CS);

	// set all Chips selects HIGH
	PORTB |= (1 << SPI_E_CS);
	PORTD |= (1 << SPI_AD_CS) |(1 << SPI_M_CS) |(1 << SPI_A_CS);

	// set MOSI and SCK: output & // set MISO: input
	SPI_DDR |= (1 << SPI_MOSI);
	SPI_DDR |= (1 << SPI_SCLK);
	SPI_DDR &= ~(1 << SPI_MISO);

	// set MOSI, SCK: HIGH. MISO leave alone.
	SPI_PRT |= (1 << SPI_MOSI);
	SPI_PRT |= (1 << SPI_SCLK);
	//SPI_PRT |= (1 << SPI_MISO);

	// ADC 
	DDRD &= ~(1<<PD6);					// PD6 is AD_READY input
	DDRD |= 1<<PD7;							// PD7 is AD_RESET output

	// ACCELEROMETER
	DDRD &= ~(1<<PD2);					// PD2 is ACC_READY input

	//MAX6662   <--- not assembled 
	// DDRB &= ~(1<<PB0); 			// PB0 is over temperature alert input
	// DDRB &= ~(1<<PB1);				// PB1 is general temperature altert input
}



//-----------------------------------------------------------------------------

void app_set_watchdog_prescaler(tWDT_PRESCALE wdt_prescale) // Set watchdog prescale
{
  U08 sreg_backup = SREG; // Copy status register to variable
  U08 wdtcsr_value = WDE + wdt_prescale; // Set new prescale value to variable

  cli(); // Disable interrups
  wdt_reset(); // Reset watchdog

  WDTCR |= (1 << WDTOE) | (1 << WDE); // Unlock register access, 4 cycles to store new value
  WDTCR = wdtcsr_value; // Set new watchdog prescaler
  SREG = sreg_backup; // Restore status register
}

void set_ad7719_enable_register() {

	usart_write_str((pU08)"\n set enable bits of AD7719 Port ");
	if ((usart_received_chars>=5) && 
	(usart_rx_buffer[2] >= 'A' && usart_rx_buffer[2] <= 'H'))
	{
	usart_write_char(usart_rx_buffer[2]);
	usart_write_str((pU08)" to ");
	usart_write_U08_hex(usart_rx_buffer[4]);
	usart_write_char('\n');
		ad7719_enables[usart_rx_buffer[2]-'A']=usart_rx_buffer[4];
		ad7719_channels_ready[usart_rx_buffer[2]-'A']=0x00;
	}
	else if  ((usart_received_chars=3) && 
	(usart_rx_buffer[1] >= 'A' && usart_rx_buffer[1] <= 'H'))
	{
		usart_write_char(usart_rx_buffer[1]);
		if (usart_rx_buffer[2]!='0') {
			usart_write_str((pU08)" to 0xFF\n");
			ad7719_enables[usart_rx_buffer[1]-'A']=0xFF;
		} else
		{
			usart_write_str((pU08)" to 0x00\n");
			ad7719_enables[usart_rx_buffer[1]-'A']=0x00;
		}
		ad7719_channels_ready[usart_rx_buffer[1]-'A']=0x00;	
	}
	else
	{
		usart_write_str((pU08)"\n something wrong\n");
		usart_write_str((pU08)"usart_rx_buffer_index: ");
		usart_write_U08(usart_received_chars, 3);
		usart_write_str((pU08)"\n usart_rx_buffer[2]: ");
		usart_write_char(usart_rx_buffer[2]);
		usart_write_str((pU08)"\n usart_rx_buffer[4]: ");
		usart_write_U08_hex(usart_rx_buffer[4]);
		usart_write_char('\n');
	}
}

void set_adc_enable_register() {
	// TODO
	usart_write_str((pU08)"setting of ATmega internal ADC enable registers is not supported. yet.\n");
}

U08	increase_adc (U08 channel){
U08 effective_channel;
	for ( U08 increase = 1 ; increase <= V_CHANNELS + I_CHANNELS + H_CHANNELS; increase++)
	{
		effective_channel = (channel + increase) % (V_CHANNELS + I_CHANNELS + H_CHANNELS);
		if (adc_enables[effective_channel/8] & (1<<effective_channel%8))
			return effective_channel;
	}
	return channel;
} // end if increase_adc;

U08	increase_ad7719 (U08 channel){
U08 effective_channel;
	for ( U08 increase = 1 ; increase <= TEMP_CHANNELS; increase++)
	{
		effective_channel = (channel + increase) % (TEMP_CHANNELS);
		if (ad7719_enables[effective_channel/8] & (1<<effective_channel%8))
			return effective_channel;
	}
	return channel;
} // end if increase_adc;

void check_if_measured_all() {
	adc_measured_all = true;
	for ( U08 i=0; i<V_BITMAP + I_BITMAP + H_BITMAP; ++i ) {
		if ((adc_enables[i] ^ adc_channels_ready[i]) != 0x00) {
			adc_measured_all = false;
			break;
		}
	}
	ad7719_measured_all = true;
	for ( U08 i=0; i<CHANNEL_BITMAP; ++i ) {
		if ((ad7719_enables[i] ^ ad7719_channels_ready[i]) != 0x00) {
			ad7719_measured_all = false;
			break;
		}
	}


}
