#include "parser.h"
#include "output.h"
#include "application.h"
#include "usart.h"
// this method parses the data, 
// which came in via USART
// later it might as well parse the data from ethernet.
void parse_ascii() {
	usart_rx_buffer[USART_RX_BUFFER_SIZE-1] = 0;
	usart_write_str((pU08)"got:");
	usart_write_str(usart_rx_buffer);
	
// look at first byte
// I hope, I can manage to use one byte commands
	switch (usart_rx_buffer[0]) {
		case 'E': 	// AD7719 enable bitmaps may be set
			set_ad7719_enable_register();
			break;
		case 'e':	// ATmega internal ADC enable bitmaps may be set
			// not supported yet.
			set_adc_enable_register();
			break;
		case 'h':
			usart_write_str((pU08)"\nheartbeat ");
			heartbeat_enable = true;
			if (usart_rx_buffer[1] == '0'){
				heartbeat_enable = false;
				usart_write_str((pU08)"off\n");
			} else {
				usart_write_str((pU08)"on\n");
			}
			break;
		case 'G': 			// GET the Temperature channels, which are enabled
			once_told_you = false;
			for ( U08 i=0; i<CHANNEL_BITMAP; ++i ) {
				ad7719_channels_ready[i]=0;
			}
			break;

		case 'g':			// GET the voltage/current/humidity channels, which are enabled
			once_told_you = false;
			for ( U08 i=0; i<V_BITMAP + I_BITMAP + H_BITMAP; ++i ) {
				adc_channels_ready[i]=0;
			}
			break;

		case 'P':
			print_ad7719_nicely();
			break;
			
		case 'p':
			print_adc_nicely();
			break;

		case 's':
			print_status();
			break;	

		case 'd':
			usart_write_str((pU08)"\ndebug mode ");
			debug_mode = true;
			if (usart_rx_buffer[1] == '0'){
				debug_mode = false;
				usart_write_str((pU08)"off\n");
			} else {
				usart_write_str((pU08)"on\n");
			}
			break;		
	}
	
	
	usart_write_str((pU08)"\nready?");
	for (U08 i=0; i<USART_RX_BUFFER_SIZE; ++i)
		usart_rx_buffer[i] = 0;
}

void parse_non_human_readable_input() {


}

// this guy checks, if an incoming byte is:
// to be stored, because it belongs to a command
// to be discarded, because something went wrong, and the bytemade no sense...
// the end of a commmand, and so the 'real parser' may do his work.

void incoming_byte_parser() {
	static bool receiving_command = false;
	U08 current_byte = UDR;
	
	if (!receiving_command) { 
		switch (current_byte) {
			case 0x01:
				receiving_command = true;
				break;
		}
	}
	
	if (receiving_command)
	{
		usart_rx_buffer[usart_received_chars] = usart_last_char;
		usart_received_chars++;
	}
	
	
}
