#ifndef __APPLICATION_H
#define __APPLICATION_H
//-----------------------------------------------------------------------------

#include "typedefs.h"
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------

// SPI DEFINITIONS
// Port Definitions
#define SPI_PRT PORTB
#define SPI_DDR DDRB

// Bit Definitions
#define SPI_SCLK PB7
#define SPI_MOSI PB5
#define SPI_MISO PB6

#define SPI_E_CS PB4 		
#define SPI_AD_CS PD3 		
#define SPI_M_CS PD4		
#define SPI_A_CS PD5		

//#ifdef ____WENNICHSWIRKLICHWILL
#ifndef ___MAIN_WORKFLOW_GLOBAL_VARS
#define ___MAIN_WORKFLOW_GLOBAL_VARS
	#define TEMP_CHANNELS 64
	#define CHANNEL_BITMAP 8
	#define AD7719_READINGS_UNTIL_SETTLED 3 // bei3:480ms
	
	#define V_CHANNELS 40
	#define I_CHANNELS 40
	#define H_CHANNELS 4
	#define V_BITMAP 5
	#define I_BITMAP 5
	#define H_BITMAP 1
	#define ADC_READINGS_UNTIL_SETTLED 1
#endif

// MAIN WORKFLOW GLOBAL VARIABLES

	extern bool heartbeat_enable;


	
// TIMER global variable
	extern volatile U32 local_ms;

// AD7719 global variables
	extern U32 ad7719_values[TEMP_CHANNELS];
	extern U08 ad7719_enables[CHANNEL_BITMAP];
	extern U08 ad7719_channels_ready[CHANNEL_BITMAP];
	extern U08 ad7719_readings_since_last_muxing;
	extern U08 ad7719_current_channel;
	extern U32 ad7719_current_reading;
	extern bool ad7719_measured_all;
// ATMEGA ADC global variables
	extern U08 adc_values[V_CHANNELS + I_CHANNELS + H_CHANNELS]; // stores measured voltage in steps of 16mV
	extern U08 adc_enables[V_BITMAP + I_BITMAP + H_BITMAP];
	extern U08 adc_channels_ready[V_BITMAP + I_BITMAP + H_BITMAP];
	extern U08 adc_readings_since_last_muxing;
	extern U08 adc_current_channel;
	extern U08 adc_current_reading;
	extern bool adc_measured_all;

	extern bool once_told_you;
	extern bool debug_mode;



//-----------------------------------------------------------------------------
extern volatile U08 app_reset_source;
//-----------------------------------------------------------------------------

void app_init(void); // Initialize application
void app_set_watchdog_prescaler(tWDT_PRESCALE wdt_prescale); // Set watchdog prescale

//methods in main ... declared here ... don't ask why ... 
// definition of some functions:
// these function are implemented in this file, this is not doog coding style.
// sooner or later, they will be moved into more apropriate files.
void set_adc_enable_register();
void set_ad7719_enable_register();
U08	increase_adc (U08 channel);
U08	increase_ad7719 (U08 channel);
void check_what_measurement_was_finished() ;
void check_if_measured_all() ;
// end of function definition:
//-----------------------------------------------------------------------------



//-----------------------------------------------------------------------------

#endif
