#include "typedefs.h"
#include <avr/interrupt.h>


	volatile U16 milisec = 0;
	volatile U32 sec = 0;

void timer_init() {
	// TIMER2 is used as local clock:
	// configure timer 2
	TCCR2 = (1<<WGM21); // CTC Modus
	TCCR2 |= (1<<CS21) | (1<<CS20); // Prescaler 64 --> counts up every 8us
	OCR2 = 125-1; 					// --> output compare interrupt occurs every 125 x 8us = 1ms
	// Compare Interrupt erlauben
	TIMSK |= (1<<OCIE2);
	
}

ISR (TIMER2_COMP_vect)
{
	if (milisec < 999)
 		++milisec;
	else {
		milisec = 0;
		sec++;
	}
		
}
