//-----------------------------------------------------------------------------
#include "typedefs.h"
#include "application.h"
#include "spi_master.h"
#include "ad7719_adc.h"
#include "atmega_adc.h"    
#include "usart.h"
#include "macros.h"
#include "muxer_fsc.h"
#include "output.h"
#include "parser.h"
#include "interpol.h"
#include "w5100_spi_interface.h"
#include "timer.h"
#include <avr/interrupt.h>
#include <avr/wdt.h>
#include <stdlib.h>

// MAIN WORKFLOW GLOBAL VARIABLES
	bool verbose;  // should go to w5100.c or so
	bool heartbeat_enable;
	
// AD7719 global variables
	U32 ad7719_values[RESISTANCE_CHANNELS];
	U08 ad7719_enables[RESISTANCE_CHANNELS/8];
	U08 ad7719_channels_ready[RESISTANCE_CHANNELS/8];
	U08 ad7719_readings_since_last_muxing = 0;
	U08 ad7719_current_channel = 0;
	U32 ad7719_current_reading = 0;
	bool ad7719_measured_all = false;
	bool ad7719_values_printed = true;
	bool ad7719_print_endless = false;

// ATMEGA ADC global variables
	U08 adc_readings_until_mean=250;
	U32 adc_values[VOLTAGE_CHANNELS]; // stores measured voltage in steps of 16mV
	U08 adc_enables[VOLTAGE_CHANNELS/8];
	U08 adc_channels_ready[VOLTAGE_CHANNELS/8];
	U08 adc_readings_since_last_muxing = 0;
	U08 adc_current_channel = 0;
	U16 adc_current_reading = 0;
	bool adc_measured_all = false;
	bool adc_values_printed = true;
	bool adc_print_endless = false;

	bool once_told_you = true;
	bool debug_mode = false;
	
// ETHERNET VARS
U08 downloaded_bytes;

//-----------------------------------------------------------------------------
//   M A I N    ---   M A I N    ---   M A I N    ---   M A I N    ---  M A I N    
//-----------------------------------------------------------------------------
/*
int main(void)
{
	

	U16 received_bytes;
	U08 really_downloaded_bytes;
	while(!usart_rx_ready){
		received_bytes = get_S0_RX_RSR();
		
		
		
	
		if (get_S0_RX_RSR() != 0) { // we have something to read
			usart_write_str((pU08)"\nReading ");
			usart_write_U16(get_S0_RX_RSR(), 6);
			usart_write_str((pU08)" b from W5100\n");
		
			while (received_bytes != 0) {
				really_downloaded_bytes = w5100_get_RX(16, true);
				usart_write_char('!');
				usart_write_U08(really_downloaded_bytes,4);
				usart_write_char('\n');
				for (U08 i=0; i<really_downloaded_bytes; i++){
					usart_write_U08_hex(eth_read_buffer[i]);
					usart_write_char(' ');
				}
				received_bytes -= really_downloaded_bytes;
			}
		}
		usart_write_char('\n');
		
		_delay_ms(400);
		_delay_ms(400);
		_delay_ms(400);
		_delay_ms(400);
	}
	usart_rx_ready = false;
	
	bool quit = false;
	while (!quit) {
	usart_write_str((pU08)"Enter the string to send to PC or \"XXX\" in order to quit\n");
		while(!usart_rx_ready){
			_delay_ms(100);
		}
		usart_rx_ready = false;
	
		if ( (usart_rx_buffer[0]=='X') &&  (usart_rx_buffer[1]=='X') && (usart_rx_buffer[2]=='X') )
			quit = true;
		else {
			// copy string to W5100 TX buffer and issue 'SEND' command.
			for (U08 i =0; i<usart_received_chars; i++){
				eth_write_buffer[i]=usart_rx_buffer[i];
			}
			
			w5100_set_TX(usart_received_chars);
			
		}		
			
		
	}
	
} // end of main()	
*/
int main(void)
{
	app_init();		  // Setup: Watchdog and I/Os
	usart_init();
	spi_init(); 		// Initialize SPI interface as master
	timer_init();		// set up TIMER2: TIMER2_COMP interrupt occurs every 1ms
	
	w5100_reset();
	w5100_init();

	//  Enable interrupts
	sei();

	
for ( U08 i=0; i < (RESISTANCE_CHANNELS/8); ++i ) {
	ad7719_enables[i]=0x00;
	ad7719_channels_ready[i]=0;
	}
for ( U08 i=0; i < (VOLTAGE_CHANNELS/8); ++i ) {
	adc_enables[i]=0x00;
	adc_channels_ready[i]=0;
}

	static U08 welcome[]="welcome to:\n FSC command interface 0.1 \n build: ??.05.2010\n";
	usart_write_str(welcome);
	/*
	print_help();
	print_adc_enable_status(true);
	usart_write_char('\n');
	print_ad7719_enable_status(true);
	usart_write_char('\n');
	usart_write_str((pU08)"time:");
	usart_write_U32(sec , 7);
	usart_write_str((pU08)" sec.\n");
*/
//MAIN LOOP
while (1)
{
	// checks if socket is okay and resets in case of problem the W5100 
	if (w5100_caretaker())  
	{
	// something is not okay with the ethernet ... 
	// will be reset in the next revolution.. but maybe we want to do more...
	}
	
	// this if should check every 25ms if we have any data on the W5100
	if ( (milisec % W5100_INPUT_CHECK_TIME == 0) && (w5100_ready) )
	{
		if (get_S0_RX_RSR() != 0) { // we have something to read
			downloaded_bytes = w5100_get_RX(ETH_READ_BUFFER_SIZE, true);
			usart_write_str((pU08)"got ethernet stream - no. of. bytes:");
			usart_write_U08(downloaded_bytes,3);
			usart_write_char('\n');
			for (U08 i=0; i<downloaded_bytes; i++){
				usart_write_U08_hex(eth_read_buffer[i]);
				usart_write_char(' ');
			}
			usart_write_char('\n');
		}
	}
	
//----------------------------------------------------------------------------
	if (check_if_adc_measurement_done()) {
		if(adc_print_endless){
			usart_write_str((pU08)"V|");
			usart_write_U32(sec ,8);
			print_adc_nicely(false,true);
			for ( U08 i=0; i<(VOLTAGE_CHANNELS/8); ++i ) {
				adc_channels_ready[i]=0;
			}
		} else 
		if ( !adc_values_printed) {
			adc_values_printed = true;
			print_adc_nicely(true,true);
		}
	} 

	if (check_if_ad7719_measurement_done()) {
		if(ad7719_print_endless){
			usart_write_str((pU08)"R|");
			usart_write_U32(sec ,8);
			print_ad7719_nicely(false,true);
			for ( U08 i=0; i<(RESISTANCE_CHANNELS/8); ++i ) {
				ad7719_channels_ready[i]=0;
			}
		} else 
		if ( !ad7719_values_printed) {
			ad7719_values_printed = true;
			print_ad7719_nicely(true,true);
		}
	} 

//----------------------------------------------------------------------------

	// in order to check the user interface on a hardware near level.
	// user can issue 'heartbeat command'.
	// then this pin is toggled with the 'main-while-loop-frequency'
	// --> nice check for this frequency as well
	if (heartbeat_enable) {
		PORTA ^= (1<<HEARTBEATPIN);
	}
		
//----------------------------------------------------------------------------
	//IF we need to send away one byte, and ready to send
	// apparently depricated
	if ( (usart_tx_buffer_index > 0) && (UCSRA & (1<<UDRE)) ) { 
		UDR = usart_tx_buffer[0];
		// THis is shit
		for (U08 i=0 ; i < USART_TX_BUFFER_SIZE; ++i) {
			usart_tx_buffer[i] = usart_tx_buffer[i+1];
		}
		usart_tx_buffer_index--;
	}

//----------------------------------------------------------------------------

	//IF USART DOR bit is set, PC is sending data to fast!!!
	if ( UCSRA & (1<<DOR) ){
		usart_write_str((pU08)"PC sending to fast!\n");
		//usart_last_char = UDR;
		UDR;
		// flush TX_buffer and write warning message in
		// maybe even switch off every measurement. ?
	}
//----------------------------------------------------------------------------

	//IF TX_BUFFER was overrun.	
	if (usart_tx_buffer_overflow) {
		// flash TX_buffer and write warning message in
		// maybe even switch off every measurement. ?
		//
		// this should only happen, in verbose mode and with low baudrates.
	}
//----------------------------------------------------------------------------
	
	//IF one command was received. 
	//	-It is not allowed to send more than one command between two '\n'
	if (usart_rx_ready){ 
		void MSR_parser();
	}
//----------------------------------------------------------------------------

	//IF ATmega internal ADC did finish a conversion --every 200us
	if ( (ADCSRA & (1<<ADIF)) && !adc_measured_all) {
		adc_current_reading = (U16)ADCL;
		adc_current_reading += (U16)ADCH<<8;
		if (adc_readings_since_last_muxing == ADC_READINGS_UNTIL_SETTLED+adc_readings_until_mean-1) {
			adc_channels_ready[adc_current_channel/8] |= (1<<(adc_current_channel%8));
			adc_current_channel = increase_adc (adc_current_channel);
			adc_values[adc_current_channel] = 0;
			Set_V_Muxer(adc_current_channel);
			adc_readings_since_last_muxing = 0;
			_delay_ms(10);
		}
		else if (adc_readings_since_last_muxing >= ADC_READINGS_UNTIL_SETTLED-1) {
			adc_values[adc_current_channel] += adc_current_reading;
			++adc_readings_since_last_muxing;
		}
		else  {
			++adc_readings_since_last_muxing;
		}

	}
//----------------------------------------------------------------------------

	//IF AD7719 ADC just finished a conversion -- every 60ms
	
	if (AD7719_IS_READY() && !ad7719_measured_all) {
		ad7719_current_reading = read_adc(); // --takes at 4MHz SCLK speed about 6us
		// AD7719 is only read out if settled. saves time.	
		if (ad7719_readings_since_last_muxing == AD7719_READINGS_UNTIL_SETTLED-1) {
			ad7719_values[ad7719_current_channel] = ad7719_current_reading;
			ad7719_readings_since_last_muxing=0;
			if (debug_mode) {
				usart_write_U32_hex(ad7719_current_reading);
				usart_write_char('\n');
				usart_write_char('\n');
			}
			// now prepare the data to be send away via USART.
			
			// note that this channel is ready, now and 
			// proceed to the next enabled channel.
			ad7719_channels_ready[ad7719_current_channel/8] |= (1<<(ad7719_current_channel%8));
			ad7719_current_channel = increase_ad7719 (ad7719_current_channel);
			Set_T_Muxer(ad7719_current_channel);
		} else { // the AD7719 did not settle yet, we discard the reading
			++ad7719_readings_since_last_muxing;
			if (debug_mode) {
				usart_write_U32_hex(ad7719_current_reading);
				usart_write_char('\n'); 
			}

			// current reading is not used for anything else
		}
	}


} // end of MAIN LOOP

} // end of main function
//-----------------------------------------------------------------------------
//    E N D     E N D     E N D     E N D     E N D     E N D     E N D     
//-----------------------------------------------------------------------------

