#include "output.h"
#include "usart.h"
#include "application.h"
#include "timer.h"

void print_status() {
	usart_write_str((pU08)"adc status:\n");
	for (U08 i=0; i< VOLTAGE_CHANNELS/8;++i) {
		usart_write_U08_bin(adc_enables[i]);	
		usart_write_char(' ');
	}
	usart_write_char('\n');
	for (U08 i=0; i< VOLTAGE_CHANNELS/8;++i){
		usart_write_U08_bin(adc_channels_ready[i]);
		usart_write_char(' ');
	}
	usart_write_char('\n');

	usart_write_str((pU08)"ad7719 status:\n");
	for (U08 i=0; i< RESISTANCE_CHANNELS/8;++i) {
		usart_write_U08_bin(ad7719_enables[i]);
		usart_write_char(' ');
	}
	usart_write_char('\n');
	for (U08 i=0; i< RESISTANCE_CHANNELS/8;++i){
		usart_write_U08_bin(ad7719_channels_ready[i]);
		usart_write_char(' ');
	}
	usart_write_char('\n');

	usart_write_str((pU08)"time:");
	usart_write_U32(sec,10);
	usart_write_str((pU08)" sec.\n");

	usart_write_str((pU08)"adc measured all: ");
	if (adc_measured_all)
		usart_write_str((pU08)" true\n");
	else
		usart_write_str((pU08)"false\n");

	usart_write_str((pU08)"ad7719 measured all: ");
	if (ad7719_measured_all)
		usart_write_str((pU08)" true\n");
	else
		usart_write_str((pU08)"false\n");

	usart_write_str((pU08)"adc current channel:");
	usart_write_U08(adc_current_channel,2);
	usart_write_char('\n');

	usart_write_str((pU08)"ad7719 current channel:");
	usart_write_U08(ad7719_current_channel,2);
	usart_write_char('\n');

}
void print_adc_nicely() {
	usart_write_str((pU08)"\n printing voltages in mV:\n");
	// output:	U08 adc_values[V_CHANNELS + I_CHANNELS + H_CHANNELS];
	for (U08 i=0; i< VOLTAGE_CHANNELS;++i) {
		if (i%8 == 0) usart_write_char('\n');
		adc_output(i, adc_values[i]);
		usart_write_str((pU08)"   ");
	}
	usart_write_char('\n');
}


void print_ad7719_nicely() 
{
	float value;

	usart_write_str((pU08)"\n printing measured resistance in kohms:\n");

	for (U08 i=0; i< RESISTANCE_CHANNELS;++i) {
		if (i%8 == 0) usart_write_char('\n');

		// print channel name:
		usart_write_str((pU08)"R:"); //R for resistance
		usart_write_char('A'+i/8); // Letters A,B,C,D,E,F,G,H
		//usart_write_char(' '); 
		usart_write_U08(i%8+1,1); // Numbers 1...8
		usart_write_char(':'); 

		// check if this channel is enabled in the bitmap
		if (ad7719_enables[i/8] & (1<<i%8))
		{
			value = (6.25 * 1.024 * ad7719_values[i]) / ((U32)1 << 25);
			usart_write_float(value, 3,6);
			//usart_write_U32(ad7719_values[i],8);
			//usart_write_U32_hex(data); //data
			usart_write_str((pU08)" ");	
		} else {
			usart_write_str((pU08)"         ");	
		}
		//usart_write_char('\n');
	}
}

void ad7719_output(U08 channel, U32 data) {
float value = 0;
	usart_write_str((pU08)"R:"); //R for resistance
	usart_write_char('A'+channel/8); // Letters A,B,C,D,E,F,G,H
	//usart_write_char(' '); 
	usart_write_U08(channel%8+1,1); // Numbers 1...8
	usart_write_char(':'); 
	

	value = (6.25 * data) / ((U32)1 << 25);
	usart_write_float(value, 3,6);
	//usart_write_U32_hex(data); //data


}

void adc_output(U08 channel, U08 data) {

//	if (channel < 40) 
//		usart_write_str((pU08)"V:"); 
//	else if (channel < 80)
//		usart_write_str((pU08)"I:"); 
//	else if (channel < 84)
//		usart_write_str((pU08)"H:"); 

	if (channel <80)
	{
		switch ((channel%40)/4) {
			case 0:
			case 1:
				usart_write_char('A'); 
			break;
			case 2:
			case 3:
				usart_write_char('B');
				break;
			case 4:
			case 5:
				usart_write_char('C'); 
				break;
			case 6:
			case 7:
				usart_write_char('D'); 
				break;
			case 8:
				usart_write_char('E');
				break;
			case 9:
				usart_write_char('F');
				break;
			default:
				usart_write_char('?');
				break;
			}
	}
	else // channel 80..83
	{
		usart_write_char('H');
	}
	//usart_write_char(' '); 
	
	if ( (channel%40)/4 == 9)
		usart_write_U08((channel)%4+1,1); // Numbers 1...4
	else
		usart_write_U08((channel)%8+1,1); // Numbers 1...8
	
	
	//usart_write_U08(channel,2); // Numbers 1...8
	usart_write_char(':'); 
	usart_write_U16((U16)data*16, 4); //data
}


void adc_output_all() {
	print_adc_nicely();
	print_ad7719_nicely();
}
