//-----------------------------------------------------------------------------

#include "ad7719_adc.h"       
#include "spi_master.h"    

//-----------------------------------------------------------------------------

void ad7719_init(void)
{
	// setup the SPI interface according to AD7710 specs.
	// This is needed, because W5100 has different SPI specs.
	spi_setup_ad7719();	
	

	// ADC communiaction works like this:
	// a write operation to the COM register takes place - telling the device what up next.
	// a write or read operation to another register takes place
	// COM register bits have the following meaning:
	//
	// |  7  |  6  |  5  |  4  |  3  |  2  |  1  |  0  |
	// |#WEN |R/#W | zero| zero|  A3 |  A2 |  A1 |  A0 |
	//
	// #WEN (inversed write enable) must be zero inorder to clock more bits into the SPI interface.
	// R/#W (read / not write) must be zero if the next operation will be a WRITE. one if the next is READ.
	// A3-A0 denote the address of the next register.

  
  CLR_BIT(ADC_PRT,ADC_RST);		// Reset ADC (active low) 	
  SET_BIT(ADC_PRT,ADC_RST);		// Stop Reset ADC


  CLR_BIT(PORTD,SPI_AD_CS);
  spi_transfer_byte(FILTER_RD); // Next operation is  a read from filter register
  SET_BIT(PORTD,SPI_AD_CS);
#ifdef AD7719_COM_DELAY_NEEDED
_delay_us(50);
#endif

  CLR_BIT(PORTD,SPI_AD_CS);
  spi_transfer_byte(0);			// now this read takes place	
  SET_BIT(PORTD,SPI_AD_CS);
#ifdef AD7719_COM_DELAY_NEEDED
_delay_us(50);
#endif

  CLR_BIT(PORTD,SPI_AD_CS);
  spi_transfer_byte(IOCON_WR); 			// Next Operation is write to IOCON -- this is a 2byte register
  SET_BIT(PORTD,SPI_AD_CS);
  
#ifdef AD7719_COM_DELAY_NEEDED
_delay_us(50);
#endif

  CLR_BIT(PORTD,SPI_AD_CS);
  spi_transfer_byte(IOCON_INIT_HIGH);  	// Write to IOCON1 
  SET_BIT(PORTD,SPI_AD_CS);
#ifdef AD7719_COM_DELAY_NEEDED
_delay_us(50);
#endif
  CLR_BIT(PORTD,SPI_AD_CS);
  spi_transfer_byte(IOCON_INIT_LOWBYTE);  	// Write to IOCON2 
  SET_BIT(PORTD,SPI_AD_CS);

#ifdef AD7719_COM_DELAY_NEEDED
_delay_us(50);
#endif

  CLR_BIT(PORTD,SPI_AD_CS);
  spi_transfer_byte(FILTER_WR);     	// Next Operation is write to FILTER
  SET_BIT(PORTD,SPI_AD_CS);

#ifdef AD7719_COM_DELAY_NEEDED
_delay_us(50);
#endif
  CLR_BIT(PORTD,SPI_AD_CS);
  spi_transfer_byte(FILTER_INIT);		// Set Filter register to 0x52 --> good for 50Hz noise rejection.
  SET_BIT(PORTD,SPI_AD_CS);
#ifdef AD7719_COM_DELAY_NEEDED
_delay_us(50);
#endif
  CLR_BIT(PORTD,SPI_AD_CS);
  spi_transfer_byte(AD1CON_WR);     	// Next Operation is write to AD1CON
  SET_BIT(PORTD,SPI_AD_CS);

#ifdef AD7719_COM_DELAY_NEEDED
_delay_us(50);
#endif

  CLR_BIT(PORTD,SPI_AD_CS);
  spi_transfer_byte(AD1CON_INIT);  		// auxilliary ADC is not used in this application --> AD7719 data sheet for more info about aux. ADC
  SET_BIT(PORTD,SPI_AD_CS);

#ifdef AD7719_COM_DELAY_NEEDED
_delay_us(50);
#endif

  CLR_BIT(PORTD,SPI_AD_CS);
  spi_transfer_byte(AD0CON_WR);     	// Next Operation is write to AD0CON  Start SPI
  SET_BIT(PORTD,SPI_AD_CS);

#ifdef AD7719_COM_DELAY_NEEDED
_delay_us(50);
#endif

  CLR_BIT(PORTD,SPI_AD_CS);
  spi_transfer_byte(AD0CON_INIT);  	// Write to AD0CON
  SET_BIT(PORTD,SPI_AD_CS);

#ifdef AD7719_COM_DELAY_NEEDED
_delay_us(50);
#endif

  CLR_BIT(PORTD,SPI_AD_CS);
  spi_transfer_byte(MODE_WR);     	// Next Operation is write to MODE
  SET_BIT(PORTD,SPI_AD_CS);

#ifdef AD7719_COM_DELAY_NEEDED
_delay_us(50);
#endif

  CLR_BIT(PORTD,SPI_AD_CS);
  spi_transfer_byte(MODE_CONT);  	// Set mode to: continuous sampling.
  SET_BIT(PORTD,SPI_AD_CS);

#ifdef AD7719_COM_DELAY_NEEDED
_delay_us(50);
#endif

// these 
  CLR_BIT(PORTD,SPI_AD_CS);
  spi_transfer_byte(FILTER_RD);	 	// Next Operation is read from Filter register... 
  SET_BIT(PORTD,SPI_AD_CS);

#ifdef AD7719_COM_DELAY_NEEDED
_delay_us(50);
#endif

  CLR_BIT(PORTD,SPI_AD_CS);			// the reading takes place here
  spi_transfer_byte(0);
  SET_BIT(PORTD,SPI_AD_CS);

#ifdef AD7719_COM_DELAY_NEEDED
_delay_us(50);
#endif
} 
          
void startconv(U08 continuous)
{
	// setup the SPI interface according to AD7710 specs.
	// This is needed, because W5100 has different SPI specs.
	spi_setup_ad7719();	

	CLR_BIT(PORTD,SPI_AD_CS);       // Set CS low
	spi_transfer_byte(MODE_WR);        // Next Operation is write to Mode Register
  SET_BIT(PORTD,SPI_AD_CS);
  CLR_BIT(PORTD,SPI_AD_CS);
	if (continuous)	spi_transfer_byte(MODE_SINGLE);	 // Start new A/D conversion
	else spi_transfer_byte(MODE_CONT);	 // Start continous conversion mode
	SET_BIT(PORTD,SPI_AD_CS);  
}

void stopconv(void)
{
	// setup the SPI interface according to AD7710 specs.
	// This is needed, because W5100 has different SPI specs.
	spi_setup_ad7719();	

	CLR_BIT(PORTD,SPI_AD_CS);       // Set CS low
	spi_transfer_byte(MODE_WR);        // Next Operation is write to Mode Register
    SET_BIT(PORTD,SPI_AD_CS);
    CLR_BIT(PORTD,SPI_AD_CS);
	spi_transfer_byte(MODE_IDLE);
	SET_BIT(PORTD,SPI_AD_CS);  
}


U32 read_adc(void)
{
	// setup the SPI interface according to AD7710 specs.
	// This is needed, because W5100 has different SPI specs.
	spi_setup_ad7719();	
 
	CLR_BIT(PORTD,SPI_AD_CS);       // Set CS low
	spi_transfer_byte(AD0DAT_RD);   // Next Operation is read from Main ADC Data Register
    SET_BIT(PORTD,SPI_AD_CS);

	#ifdef AD7719_COM_DELAY_NEEDED
	_delay_us(50);
	#endif

    CLR_BIT(PORTD,SPI_AD_CS);
	U32 value=0; 					// actually a 24bit value is returned
	value |= spi_transfer_byte(0) ;
	value =value<<8;
	value |= spi_transfer_byte(0) ;
	value =value<<8;
	value |= spi_transfer_byte(0) ;
	SET_BIT(PORTD,SPI_AD_CS);	// Set CS high
	return value;                                                                                                 
}   
  
  
