#ifndef __SPI_MASTER_H
#define __SPI_MASTER_H
//-----------------------------------------------------------------------------

#include "typedefs.h"
#include "application.h"
#include "usart.h"
//-----------------------------------------------------------------------------
#define SPI_READ_BUFFER_SIZE 16
#define SPI_WRITE_BUFFER_SIZE 16

#define SPI_MAX_SLAVE_INDEX 2 //?
#define SPI_MAX_CLOCK_INDEX 6 //?
//-----------------------------------------------------------------------------
extern volatile U08 spi_clock_index;
extern volatile U08 spi_cpol;
extern volatile U08 spi_cpha;
extern volatile U08 spi_dord;
extern volatile U08 SPI_DEVICE_SS[4];
extern volatile BOOL SPI_DEVICE_ACTIVE_HIGH[4];

extern volatile U08 spi_read_buffer[SPI_READ_BUFFER_SIZE];
extern volatile U08 spi_write_buffer[SPI_WRITE_BUFFER_SIZE];
//-----------------------------------------------------------------------------

void spi_init(void);
void spi_transfer(U08 bytes, U08 device);
void spi_transfer_w5100(U08 bytes);
U08 spi_transfer_byte(U08 data);
void spi_set_clock_index(U08 clock_index);
void spi_set_dord(U08 dord);
void spi_set_cpol(U08 cpol);
void spi_set_cpha(U08 cpha);
void spi_setup(void);
void spi_setup_ad7719();
void spi_setup_w5100();
void spi_transfer_string(U08 length, U08* addr, U08 device);
//-----------------------------------------------------------------------------

#endif
