#ifndef __MACROS_H
#define __MACROS_H
//-----------------------------------------------------------------------------

#define SET_BIT(byte,bit) (byte |= (1 << bit)) // Set bit in byte
#define CLR_BIT(byte,bit) (byte &= ~(1 << bit)) // Clear bit in byte
#define TGL_BIT(byte,bit) (byte ^= (1 << bit)) // Toggle bit in byte

#define IS_SET(reg,bit) (reg & bit) // TRUE if bit = 1
#define IS_CLR(reg,bit) !(reg & bit) // TRUE if bit = 0

#define BIT(x) (1 << (x)) // Define bit value
#define HI(x) ((x) >> 8) // Highbyte of 16-bit value

#define ABS(x) ((x >= 0) ? x : -x) // Absolute value of x

#define HI_HEX(x) ("0123456789ABCDEF" [x >> 4]) // Create hex of high nibble
#define LO_HEX(x) ("0123456789ABCDEF" [x & 0x0F]) // Create hex of low nibble
//-----------------------------------------------------------------------------

#endif
