#include "tests.h"

#include "typedefs.h"

void test_out_spare_pins(void)
{

	// set everything as inputs -- high Z
	DDRA = 0x00;
	DDRB = 0x00;
	DDRC = 0x00;
	DDRD = 0x00;

	DDRB |= 1<<PB2; // set spare out1 as output
	DDRB |= 1<<PB3; // set spare out2 as output

	DDRB |= 1<<PB4; 

	PORTC |= 1<<PC7; // switch PC7 pullup on
	PORTA |= 1<<PA7; // switch PA7 pullup on

	while (true)
	{
		 
		if ( (PINC & (1<<PC7)) == 0 )
		{
			PORTB |= 1 << PB2;
		} else {
			PORTB &= ~(1<<PB2);
		}

		/*
		if ( (PINA & (1<<PA7)) == 0 )
		{
			PORTB |= 1 << PB3;
		} else {
			PORTB &= ~(1<<PB3);
		}
*/

		PORTB ^= 1<<PB3;
		PORTB ^= 1<<PB4;
	}



}
