#include "HeadersFAD.h"

#include <string.h>

#include <iomanip>

#include "Converter.h"

using namespace std;

void FAD::EventHeader::print(std::ostream &out) const
{
    out << hex << "Delimiter: ";
    if (fStartDelimiter==kDelimiterStart)
        out << "ok";
    else
        out << fStartDelimiter;
    out << " (Crate=" << dec << (fBoardId>>8) << ", Board=" << (fBoardId&0xff) << ", Version=" << (fVersion>>8) << "." << (fVersion&0xff) << ", DNA=" << fDNA <<")" << endl;

    out << dec;
    out << "PkgLength:  " << fPackageLength << endl;

    out << "RunNumber:  " << dec<< fRunNumber << endl;
    out << "Time:       " << fTimeStamp/10000. << "s" << endl;
    out << "EvtCounter: " << dec << fEventCounter << " of " << fNumTriggersToGenerate << endl;
    out << "Trigger:    Type=" << dec << fTriggerType << " Id=" << fTriggerId << " Crc=0x" << hex << fTriggerCrc << endl;

    out << "RefClock:   " << dec << fFreqRefClock << endl;
    out << "PhaseShift: " << fAdcClockPhaseShift << endl;
    out << "Prescaler:  " << fTriggerGeneratorPrescaler << endl;

    out << "DAC:       " << dec;
    for (int i=0; i<kNumDac; i++)
        out << " " << fDac[i];
    out << endl;

    out << "Temp:      " << dec;
    for (int i=0; i<kNumTemp; i++)
        out << " " << GetTemp(i);
    out << endl;

    out << "PLL_LCK=" << hex << fPLLLCK << endl;
    out << "  PLL-Lock:         " << hex << PllLock() << endl;
    out << "  Denable:          " << HasDenable() << endl;
    out << "  Dwrite:           " << HasDwrite() << endl;
    out << "  RefClk too high:  " << IsRefClockTooHigh() << endl;
    out << "  RefClk too low:   " << IsRefClockTooLow() << endl;
    out << "  DCM locked:       " << IsDcmLocked() << endl;
    out << "  DCM ready:        " << IsDcmReady() << endl;
    out << "  SPI_SCLK enabled: " << HasSpiSclk() << endl;
}

void FAD::ChannelHeader::print(std::ostream &out) const
{
    out << "Chip=" << dec << (fId>>4) << " Ch=" << (fId&0xf) << ":";
    out << " StartCell=" << fStartCell;
    out << " ROI=" << fRegionOfInterest << endl;
}
