-- ----------------------------------------------------------------------------
-------------------------------------------------------------------------------
-- FTM Light pulser interface: FM__pulse generator for feedback 
-------------------------------------------------------------------------------
--
--
-- Created:      May 13 2011
--               by Patrick Vogler
--        
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;


library ftm_definitions;
USE ftm_definitions.ftm_constants.all;


ENTITY FM_pulse_generator IS
   GENERIC( 
      pulse_length : integer := FLD_PULSE_LENGTH   -- 48ns                                                               
         );
   PORT( 
      clk            : in  std_logic;
      pulse_freq     : in  std_logic_vector (5 downto 0);
      FM_out         : out std_logic  := '0'
         );
END FM_pulse_generator;

ARCHITECTURE beha OF FM_pulse_generator IS

BEGIN
  
  clk_div: process (clk)
    variable Z   : integer range - FLD_MIN_FREQ_DIV to FLD_FD_MAX_RANGE;
	 variable MAX : integer range 0 to FLD_FD_MAX_RANGE;
    variable Y   : integer range 0 to pulse_length;
	 variable X   : integer range 0 to FLD_FD_MULT;
      
  begin
  
  --  MAX := (FLD_MIN_FREQ_DIV + FLD_FD_MULT * integer(pulse_freq));   
	 	 
    if rising_edge(clk) then       
	   if (X < FLD_FD_MULT) then
		  X := X+1;
	   else
		  X := 0;		  
		  if (Z < pulse_freq) then 		
          Z := Z + 1;
        else 
          Z := - FLD_MIN_FREQ_DIV;
          Y := 0;
        end if;		  
		end if;     




      if (Y < pulse_length) then 
        Y := Y + 1;
        FM_out <= '1';
      else
        FM_out <= '0';  
      end if;  

    end if;
  end process clk_div;

END ARCHITECTURE beha;
