--------------------------------------------------------------------------------
-- Company: 
-- Engineer:      Patrick Vogler
--
-- Create Date:   14:09:52 05/13/2011
-- Design Name:   
-- Module Name:   /home/pavogler/ISDC_repos/firmware/FTM/Lightpulser_interface//Lightpulser_interface_tb.vhd
-- Project Name:  FLD
-- Target Device:  
-- Tool versions:  
-- Description:   
-- 
-- VHDL Test Bench Created by ISE for module: Lightpulser_interface
-- 
-- Dependencies:
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
-- Notes: 
-- This testbench has been automatically generated using types std_logic and
-- std_logic_vector for the ports of the unit under test.  Xilinx recommends
-- that these types always be used for the top-level I/O of a design in order
-- to guarantee that the testbench will bind correctly to the post-implementation 
-- simulation model.
--------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_unsigned.all;
USE ieee.numeric_std.ALL;
 
ENTITY Lightpulser_interface_tb IS
END Lightpulser_interface_tb;
 
ARCHITECTURE behavior OF Lightpulser_interface_tb IS 
 
    -- Component Declaration for the Unit Under Test (UUT)
 
    COMPONENT Lightpulser_interface
    PORT(
         clk_50 : IN  std_logic;
         clk_250 : IN  std_logic;
         Cal_0_p : OUT  std_logic;
         Cal_0_n : OUT  std_logic;
         Cal_1_p : OUT  std_logic;
         Cal_1_n : OUT  std_logic;
         Cal_2_p : OUT  std_logic;
         Cal_2_n : OUT  std_logic;
         Cal_3_p : OUT  std_logic;
         Cal_3_n : OUT  std_logic;
         Cal_4_p : OUT  std_logic;
         Cal_4_n : OUT  std_logic;
         Cal_5_p : OUT  std_logic;
         Cal_5_n : OUT  std_logic;
         Cal_6_p : OUT  std_logic;
         Cal_6_n : OUT  std_logic;
         Cal_7_p : OUT  std_logic;
         Cal_7_n : OUT  std_logic;
         LP1_ampl : IN  std_logic_vector(15 downto 0);
         LP2_ampl : IN  std_logic_vector(15 downto 0);
         LP1_delay : IN  std_logic_vector(15 downto 0);
         LP2_delay : IN  std_logic_vector(15 downto 0);
         LP1_pulse : IN  std_logic;
         LP2_pulse : IN  std_logic;
         start_config : IN  std_logic;
         config_started : OUT  std_logic;
         config_done : OUT  std_logic
        );
    END COMPONENT;
    

   --Inputs
   signal clk_50 : std_logic := '0';
   signal clk_250 : std_logic := '0';
   signal LP1_ampl : std_logic_vector(15 downto 0) := (others => '0');
   signal LP2_ampl : std_logic_vector(15 downto 0) := (others => '0');
   signal LP1_delay : std_logic_vector(15 downto 0) := (others => '0');
   signal LP2_delay : std_logic_vector(15 downto 0) := (others => '0');
   signal LP1_pulse : std_logic := '0';
   signal LP2_pulse : std_logic := '0';
   signal start_config : std_logic := '0';

 	--Outputs
   signal Cal_0_p : std_logic;
   signal Cal_0_n : std_logic;
   signal Cal_1_p : std_logic;
   signal Cal_1_n : std_logic;
   signal Cal_2_p : std_logic;
   signal Cal_2_n : std_logic;
   signal Cal_3_p : std_logic;
   signal Cal_3_n : std_logic;
   signal Cal_4_p : std_logic;
   signal Cal_4_n : std_logic;
   signal Cal_5_p : std_logic;
   signal Cal_5_n : std_logic;
   signal Cal_6_p : std_logic;
   signal Cal_6_n : std_logic;
   signal Cal_7_p : std_logic;
   signal Cal_7_n : std_logic;
   signal config_started : std_logic;
   signal config_done : std_logic;

   -- Clock period definitions
   constant clk_50_period : time := 20 ns;
   constant clk_250_period : time := 4 ns;
 
BEGIN
 
	-- Instantiate the Unit Under Test (UUT)
   uut: Lightpulser_interface PORT MAP (
          clk_50 => clk_50,
          clk_250 => clk_250,
          Cal_0_p => Cal_0_p,
          Cal_0_n => Cal_0_n,
          Cal_1_p => Cal_1_p,
          Cal_1_n => Cal_1_n,
          Cal_2_p => Cal_2_p,
          Cal_2_n => Cal_2_n,
          Cal_3_p => Cal_3_p,
          Cal_3_n => Cal_3_n,
          Cal_4_p => Cal_4_p,
          Cal_4_n => Cal_4_n,
          Cal_5_p => Cal_5_p,
          Cal_5_n => Cal_5_n,
          Cal_6_p => Cal_6_p,
          Cal_6_n => Cal_6_n,
          Cal_7_p => Cal_7_p,
          Cal_7_n => Cal_7_n,
          LP1_ampl => LP1_ampl,
          LP2_ampl => LP2_ampl,
          LP1_delay => LP1_delay,
          LP2_delay => LP2_delay,
          LP1_pulse => LP1_pulse,
          LP2_pulse => LP2_pulse,
          start_config => start_config,
          config_started => config_started,
          config_done => config_done
        );

   -- Clock process definitions
   clk_50_process :process
   begin
		clk_50 <= '0';
		wait for clk_50_period/2;
		clk_50 <= '1';
		wait for clk_50_period/2;
   end process;
 
   clk_250_process :process
   begin
		clk_250 <= '0';
		wait for clk_250_period/2;
		clk_250 <= '1';
		wait for clk_250_period/2;
   end process;
 

   -- Stimulus process
   stim_proc: process
   begin		
      -- hold reset state for 100 ms.
  --    wait for 100 ms;	

      wait for clk_50_period*10;

      -- insert stimulus here

         -- init input signals
         start_config  <= '0';
         LP1_pulse     <= '0';
         LP2_pulse     <= '0';



         -- latch settings
         LP1_ampl  <= "1000000000000111";
         LP2_ampl  <= "0100000000010000";
         
         LP1_delay  <= "0000000000010000";
         LP2_delay  <= "0000000000000001";
      
         wait for clk_50_period*5;      
         start_config <= '1';
         wait for clk_50_period*1;
         start_config <= '0';


         wait for clk_50_period*5;
      

         -- trigger lightpulses
         
         -- LP1: mirror dish
         LP1_pulse <= '1';
         wait for clk_50_period*5;      
         LP1_pulse <= '0';

         -- LP2: shutter
         LP2_pulse <= '1';
         wait for clk_50_period*5;      
         LP2_pulse <= '0';





      -- next cyclus
      wait for clk_50_period*10;

      
         -- latch settings
         LP1_ampl  <= "1100000000000111";
         LP2_ampl  <= "0000000000010000";
         
         LP1_delay  <= "0000000001010000";
         LP2_delay  <= "0000000000000101";
      
         wait for clk_50_period*5;      
         start_config <= '1';
         wait for clk_50_period*1;
         start_config <= '0';


         wait for clk_50_period*5;
      
            -- trigger lightpulses
         
         -- LP1: mirror dish
         LP1_pulse <= '1';
         wait for clk_50_period*2;      
         LP1_pulse <= '0';

         -- LP2: shutter
         LP2_pulse <= '1';
         wait for clk_50_period*2;      
         LP2_pulse <= '0';



      wait;
   end process;

END;
