#ifndef MARS_MImgCleanStd
#define MARS_MImgCleanStd

#ifndef MARS_MGTask
#include "MGTask.h"
#endif

class MGeomCam;
class MCerPhotEvt;

class MGGroupFrame;

class MImgCleanStd : public MGTask
{
private:
    const MGeomCam    *fCam;  //!
          MCerPhotEvt *fEvt;  //!

    Float_t fCleanLvl1;
    Float_t fCleanLvl2;

    void CreateGuiElements(MGGroupFrame *f);

public:
    MImgCleanStd(const Float_t lvl1=3.0, const Float_t lvl2=2.5,
                 const char *name=NULL, const char *title=NULL);

    void CleanStep1();
    void CleanStep2();
    void CleanStep3();

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    Bool_t ProcessMessage(Int_t msg, Int_t submsg, Long_t param1, Long_t param2);

    ClassDef(MImgCleanStd, 0)    // task doing a standard image cleaning
}; 

#endif

