----------------------------------------------------------------------------------
-- Company:        ETH Zurich, Institute for Particle Physics
-- Engineer:       Patrick Vogler
-- 
-- Create Date:    March 2 2010
-- Design Name:    
-- Module Name:    FTM Lightpulser interface: single lightpulser
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description:    generates the signals to control a single lightpulser
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
--
-- modifications:  
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;


library ftm_definitions;
USE ftm_definitions.ftm_array_types.all;
USE ftm_definitions.ftm_constants.all;



entity single_LP is
  port(
    
-- Clock
-------------------------------------------------------------------------------
--   clk_50    : IN  STD_LOGIC;              --  50 MHz system clock 
   clk_250   : IN  STD_LOGIC;              -- 250 MHz system clock
   
-- Lightpulser
-------------------------------------------------------------------------------
   LP_Pulse_out    : out STD_LOGIC;     --  

   
-- FPGA intern signals: Lightpulser brightness
-------------------------------------------------------------------------------
--   int_LP             : in std_logic_vector (1 downto 0);  -- Intensity Light                                                    

   LP_pulse_in          : in std_logic;                    -- trigger lightpulse

   LP_delay             : in std_logic_vector (15 downto 0)
   
  );
end single_LP;



architecture Behavioral of single_LP is


-- type TYPE_LightPulser_STATE is (IDLE, PULSE, BLOCKED);   
-- signal LightPulser_state        : TYPE_LightPulser_STATE := IDLE;  
-- signal LP_Pulse_sig         : std_logic;


-- Component Declarations  
component delayed_pulse is
	generic(pulse_width	: integer range 0 to 15);
        port(clk_250MHz  	: in    std_logic;
	     delay		: in	std_logic_vector(9 downto 0);
	     input		: in	std_logic;
	     output		: out	std_logic);
end component;






  
begin

 
  
-- pulse_witdh_LP : process(clk_50, LP_pulse_in)  
--  begin    
--    begin
--    if rising_edge(clk_50) then
--       case LightPulser_state is
--         when IDLE =>           
--           LP_Pulse_sig <= '0';           
--           if LP_pulse_in = '1' then 
--             LightPulser_state  <= PULSE;
--           end if  
--         when PULSE =>           
--           LP_Pulse_sig <= '1';           
--           LightPulser_state  <= BLOCKED;  
--         when BLOCKED =>           
--           LP_Pulse_sig <= '0';           
--           if LP_pulse_in = '0' then 
--             LightPulser_state  <= IDLE;
--            end if           
--       end case;               
--    end if;  
-- end process pulse_witdh_LP;



inst_LP_delay: delayed_pulse
	generic map(pulse_width		=> FLD_PULSE_LENGTH)
	port map(clk_250MHz		=> clk_250,
	        delay			=> LP_delay(9 downto 0),
		input			=> LP_pulse_in,
		output			=> LP_Pulse_out);





end Behavioral;
