#ifndef FACT_EventBuilderWrapper
#define FACT_EventBuilderWrapper

/*
#if BOOST_VERSION < 104400
#if (__GNUC__ > 4 || (__GNUC__ == 4 && __GNUC_MINOR__ > 4))
#undef BOOST_HAS_RVALUE_REFS
#endif
#endif
#include <boost/thread.hpp>

using namespace std;
*/

#include <boost/date_time/posix_time/posix_time_types.hpp>

#include "EventBuilder.h"

class EventBuilderWrapper
{
public:
    // FIXME
    static EventBuilderWrapper *This;

private:
    boost::thread fThread;

    enum CommandStates_t // g_runStat
    {
        kAbort      = -2,  // quit as soon as possible ('abort')
        kExit       = -1,  // stop reading, quit when buffered events done ('exit')
        kInitialize =  0,  // 'initialize' (e.g. dim not yet started)
        kHybernate  =  1,  // do nothing for long time ('hybernate') [wakeup within ~1sec]
        kSleep      =  2,  // do nothing ('sleep')                   [wakeup within ~10msec]
        kModeFlush  = 10,  // read data from camera, but skip them ('flush')
        kModeTest   = 20,  // read data and process them, but do not write to disk ('test')
        kModeFlag   = 30,  // read data, process and write all to disk ('flag')
        kModeRun    = 40,  // read data, process and write selected to disk ('run')
    };

    MessageImp &fMsg;

public:
    EventBuilderWrapper(MessageImp &msg) : fMsg(msg)
    {
        if (This)
            throw logic_error("EventBuilderWrapper cannot be instantiated twice.");

        This = this;
    }
    ~EventBuilderWrapper()
    {
        Abort();
        // FIXME: Used timed_join and abort afterwards
        //        What's the maximum time the eb need to abort?
        fThread.join();
        //fMsg.Info("EventBuilder stopped.");
    }

    void Update(const char *msg, int severity)
    {
        fMsg.Update(msg, severity);
    }

    bool IsThreadRunning()
    {
        return !fThread.timed_join(boost::posix_time::microseconds(0));
    }

    void SetMaxMemory(unsigned int mb) const
    {
        if (mb*1000000<GetUsedMemory())
        {
            // fMsg.Warn("...");
            return;
        }

        g_maxMem = mb*1000000;
    }

    void Start(const vector<string> &addr)
    {
        if (IsThreadRunning())
        {
            fMsg.Warn("Start - EventBuilder still running");
            return;
        }

        fMsg.Message("Starting EventBuilder thread");

        g_maxBoards = addr.size();
        g_actBoards = g_maxBoards;

        g_runStat   = kModeRun;

        int i=0;
        for (vector<string>::const_iterator it=addr.begin(); it!=addr.end(); it++)
        {
            g_ip[i].port = 5000;
            memset(g_ip[i].addr, 0, 100);
            strncpy(g_ip[i].addr, it->c_str(), 99);

            strcpy(g_ip[i].addr, "127.0.0.1");
            i++;
        }

        fThread = boost::thread(StartEvtBuild);
    }
    void Abort()
    {
        fMsg.Message("Signal abort to EventBuilder thread...");
        g_runStat = kAbort;
    }

    void Exit()
    {
        fMsg.Message("Signal exit to EventBuilder thread...");
        g_runStat = kExit;
    }

    /*
    void Wait()
    {
        fThread.join();
        fMsg.Message("EventBuilder stopped.");
    }*/

    void Hybernate() const { g_runStat = kHybernate; }
    void Sleep()     const { g_runStat = kSleep;     }
    void FlushMode() const { g_runStat = kModeFlush; }
    void TestMode()  const { g_runStat = kModeTest;  }
    void FlagMode()  const { g_runStat = kModeFlag;  }
    void RunMode()   const { g_runStat = kModeRun;   }

    // FIXME: To be removed
    void SetMode(int mode) const { g_runStat = mode; }

    bool IsConnected(int i) const     { return gi_NumConnect[i]==7; }
    bool IsDisconnected(int i) const  { return gi_NumConnect[i]==0; }
    int  GetNumConnected(int i) const { return gi_NumConnect[i]; }

    size_t GetUsedMemory() const { return gi_usedMem; }


    // -------------- Mapped event builder callbacks ------------------

    int runOpen(uint32_t runid, RUN_HEAD *h, size_t)
    {
        cout << "OPEN_FILE #" << runid << endl;
        cout << " Ver= " << h->Version << endl;
        cout << " Typ= " << h->RunType << endl;
        cout << " Nb = " << h->NBoard << endl;
        cout << " Np = " << h->NPix << endl;
        cout << " NTm= " << h->NTm << endl;
        cout << " roi= " << h->Nroi << endl;

        return 0;
    }

    int runWrite(int, EVENT *e, size_t)
    {
        cout << "WRITE_EVENT" << endl;

        cout << " Evt=" << e->EventNum << endl;
        cout << " Typ=" << e->TriggerType << endl;
        cout << " roi=" << e->Roi << endl;
        cout << " trg=" << e->SoftTrig << endl;
        cout << " tim=" << e->PCTime << endl;

        return 0;
    }

    int runClose(int, RUN_TAIL *, size_t)
    {
        cout << "CLOSE_RUN" << endl;
        return 0;
    }
};

EventBuilderWrapper *EventBuilderWrapper::This = 0;

// ----------- Event builder callbacks implementation ---------------
extern "C"
{
    int runOpen(uint32_t irun, RUN_HEAD *runhd, size_t len)
    {
        return EventBuilderWrapper::This->runOpen(irun, runhd, len);
    }

    int runWrite(int fileId, EVENT *event, size_t len)
    {
        return EventBuilderWrapper::This->runWrite(fileId, event, len);
    }

    int runClose(int fileId, RUN_TAIL *runth, size_t len)
    {
        return EventBuilderWrapper::This->runClose(fileId, runth, len);
    }

    void message(int severity, const char *msg)
    {
        EventBuilderWrapper::This->Update(msg, severity);
    }
}

#endif
