-- ----------------------------------------------------------------------------
-------------------------------------------------------------------------------
-- FTM Light pulser interface: FM__pulse generator for feedback 
-------------------------------------------------------------------------------
--
--
-- Created:      May 13 2011
--               by Patrick Vogler
--        
-- modified:     May 26 2011
--               by Patrick Vogler
--               "Lightpulser Basic Version"

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;


library ftm_definitions;
USE ftm_definitions.ftm_constants.all;


ENTITY FM_pulse_generator_Basic IS
   GENERIC( 
      pulse_length : integer := FLD_PULSE_LENGTH   -- 48ns                                                               
         );
   PORT( 
      clk            : in  std_logic;
      pulse_freq     : in  std_logic_vector (5 downto 0);
      FM_out         : out std_logic  := '0'
         );
END FM_pulse_generator_Basic;

ARCHITECTURE beha OF FM_pulse_generator_Basic IS

BEGIN
  
  clk_div: process (clk)
    variable Z   : integer range - FLD_MIN_FREQ_DIV_BASIC to FLD_FD_MAX_RANGE_BASIC;
    variable Y   : integer range 0 to FLD_PULSE_LENGTH_BASIC;
    variable X   : integer range 0 to FLD_FD_MULT_BASIC ;
      
  begin 
   	 
    if rising_edge(clk) then       
	   if (X < FLD_FD_MULT_BASIC) then
		  X := X+1;
	   else
		  X := 0;		  
		  if (Z < pulse_freq) then 		
                      Z := Z + 1;
                  else 
                      Z := - FLD_MIN_FREQ_DIV;
                      Y := 0;
                  end if;		  
        end if;   

      if (Y < FLD_PULSE_LENGTH_BASIC) then 
        Y := Y + 1;
        FM_out <= '1';
      else
        FM_out <= '0';  
      end if;  

    end if;
  end process clk_div;

END ARCHITECTURE beha;
