-- VHDL Entity FACT_FAD_lib.clock_generator_var_ps.symbol
--
-- Created:
--          by - dneise.UNKNOWN (E5B-LABOR6)
--          at - 13:20:47 01.06.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.2 (Build 10)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY clock_generator_var_ps IS
   PORT( 
      CLK             : IN     std_logic;
      RST_IN          : IN     std_logic;
      direction       : IN     std_logic;
      do_shift        : IN     std_logic;
      CLK_25          : OUT    std_logic;
      CLK_25_PS       : OUT    std_logic;
      CLK_50          : OUT    std_logic;
      locked_status_o : OUT    std_logic;
      offset          : OUT    std_logic_vector (7 DOWNTO 0) := (OTHERS => '0');
      ready_status_o  : OUT    std_logic
   );

-- Declarations

END clock_generator_var_ps ;

--
-- VHDL Architecture FACT_FAD_lib.clock_generator_var_ps.struct
--
-- Created:
--          by - dneise.UNKNOWN (E5B-LABOR6)
--          at - 13:20:48 01.06.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.2 (Build 10)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.numeric_std.all;
LIBRARY UNISIM;
--USE UNISIM.Vcomponents.all;
LIBRARY FACT_FAD_lib;
USE FACT_FAD_lib.fad_definitions.all;

LIBRARY FACT_FAD_lib;

ARCHITECTURE struct OF clock_generator_var_ps IS

   -- Architecture declarations

   -- Internal signal declarations
   SIGNAL CLK0_OUT    : std_logic;
   SIGNAL LOCKED_OUT  : std_logic;
   SIGNAL PSCLK_IN    : std_logic;
   SIGNAL PSDONE_OUT  : std_logic;
   SIGNAL PSEN_IN     : std_logic;
   SIGNAL PSINCDEC_IN : std_logic;
   SIGNAL rst         : std_logic := '0';    --asynch in of DCM

   -- Implicit buffer signal declarations
   SIGNAL CLK_25_internal : std_logic;


   -- Component Declarations
   COMPONENT dcm_50_to_25
   PORT (
      CLKIN_IN        : IN     std_logic;
      CLK0_OUT        : OUT    std_logic;
      CLKFX_OUT       : OUT    std_logic;
      CLKIN_IBUFG_OUT : OUT    std_logic
   );
   END COMPONENT;
   COMPONENT dcm_ps_38ns
   PORT (
      CLKIN_IN : IN     std_logic;
      CLK0_OUT : OUT    std_logic
   );
   END COMPONENT;
   COMPONENT dcm_var_ps_38ns
   PORT (
      CLKIN_IN    : IN     std_logic;
      PSCLK_IN    : IN     std_logic;
      PSEN_IN     : IN     std_logic;
      PSINCDEC_IN : IN     std_logic;
      RST_IN      : IN     std_logic;
      CLK0_OUT    : OUT    std_logic;
      LOCKED_OUT  : OUT    std_logic;
      PSDONE_OUT  : OUT    std_logic
   );
   END COMPONENT;
   COMPONENT phase_shifter
   PORT (
      CLK             : IN     std_logic ;
      rst             : OUT    std_logic                     := '0'; --asynch in of DCM
      -- interface to: clock_generator_variable_PS_struct.vhd
      PSCLK           : OUT    std_logic ;
      PSEN            : OUT    std_logic                     := '0';
      PSINCDEC        : OUT    std_logic                     := '1'; -- default is 'incrementing'
      PSDONE          : IN     std_logic ;                           -- will pulse once, if phase shifting was done.
      LOCKED          : IN     std_logic ;                           -- when is this going high?
      -- interface to: w5300_modul.vhd
      shift_phase     : IN     std_logic ;
      direction       : IN     std_logic ;                           -- corresponds TO 'PSINCDEC'
      reset_DCM       : IN     std_logic ;                           -- asynch in: orders us, TO reset the DCM
      -- status:
      shifting        : OUT    std_logic                     := '0';
      ready           : OUT    std_logic                     := '0';
      locked_status_o : OUT    std_logic ;
      ready_status_o  : OUT    std_logic ;
      offset          : OUT    std_logic_vector (7 DOWNTO 0) := (OTHERS => '0')
   );
   END COMPONENT;

   -- Optional embedded configurations
   -- pragma synthesis_off
   FOR ALL : dcm_50_to_25 USE ENTITY FACT_FAD_lib.dcm_50_to_25;
   FOR ALL : dcm_ps_38ns USE ENTITY FACT_FAD_lib.dcm_ps_38ns;
   FOR ALL : dcm_var_ps_38ns USE ENTITY FACT_FAD_lib.dcm_var_ps_38ns;
   FOR ALL : phase_shifter USE ENTITY FACT_FAD_lib.phase_shifter;
   -- pragma synthesis_on


BEGIN

   -- Instance port mappings.
   U_0 : dcm_50_to_25
      PORT MAP (
         CLKIN_IN        => CLK,
         CLKFX_OUT       => CLK_25_internal,
         CLKIN_IBUFG_OUT => OPEN,
         CLK0_OUT        => CLK_50
      );
   U_1 : dcm_ps_38ns
      PORT MAP (
         CLKIN_IN => CLK_25_internal,
         CLK0_OUT => CLK0_OUT
      );
   U_2 : dcm_var_ps_38ns
      PORT MAP (
         CLKIN_IN    => CLK0_OUT,
         PSCLK_IN    => PSCLK_IN,
         PSEN_IN     => PSEN_IN,
         PSINCDEC_IN => PSINCDEC_IN,
         RST_IN      => rst,
         CLK0_OUT    => CLK_25_PS,
         LOCKED_OUT  => LOCKED_OUT,
         PSDONE_OUT  => PSDONE_OUT
      );
   U_4 : phase_shifter
      PORT MAP (
         CLK             => CLK0_OUT,
         rst             => rst,
         PSCLK           => PSCLK_IN,
         PSEN            => PSEN_IN,
         PSINCDEC        => PSINCDEC_IN,
         PSDONE          => PSDONE_OUT,
         LOCKED          => LOCKED_OUT,
         shift_phase     => do_shift,
         direction       => direction,
         reset_DCM       => RST_IN,
         shifting        => OPEN,
         ready           => OPEN,
         locked_status_o => locked_status_o,
         ready_status_o  => ready_status_o,
         offset          => offset
      );

   -- Implicit buffered output assignments
   CLK_25 <= CLK_25_internal;

END struct;
