#ifndef EDD_H_SEEN
#define EDD_H_SEEN

#include "../../Evidence/GUI.h"
#include "RawDataCTX.h"
#include "PixelMap.h"

#define SVN_REVISION "$Revision: 10143 $"

class TP_DAQ;

// Event oscilloscope
class EventScope: public EddBasePlot, public PixelMap {
  Q_OBJECT

  private:
    struct ItemDetails {
	  unsigned int Board, Chip, Channel;
      QwtPlotCurve *Signal;
	  QwtPlotMarker *Trigger;
    };
    QList<struct ItemDetails> List;

	class TP_DAQ *DAQPage;
    QString Name;
	bool Active;
	QAction *PhysPipeAction;
	QAction *PersistanceAction;
	FILE *Tmpfile;
	QTemporaryFile File;
	QString LastPath;

  public:
    EventScope(class TP_DAQ *, QWidget * = NULL);
    ~EventScope();
	
	void UpdateFirst(int, int, int);
	void AddTrace(int, int, int);
	void SetActive(bool);
	QString ToPixel(unsigned int, unsigned int, unsigned int, unsigned int);
	RawDataCTX *RD;
	CTX_ErrCode ErrCode;

  private slots:
	void Update(QString, int, QByteArray, QString, QString);
	void PlotTraces();
	void DeleteCurve(QwtPlotCurve *);
	void NewEventNum(int);

  public slots:
	void OpenRawFile(QString=QString());
	
  signals:
	void PixelData(QVector<double>);
};


// Tab page classes
class TP_Environment: public QWidget {
  Q_OBJECT

  public:
    TP_Environment();
};

class TP_Bias: public QWidget {
  Q_OBJECT

  public:
    TP_Bias();
};

class TP_FADctrl: public QWidget {
  Q_OBJECT

  public:
    TP_FADctrl();
};

class TP_Feedback: public QWidget {
  Q_OBJECT

  public:
    TP_Feedback();
};

class TP_DAQ: public QWidget {
  Q_OBJECT
  static const int MAXPIXEL = 1440;

  private:
 	QFormLayout *FormLayout;
	QWidget *Display;
	QPushButton **Pixel;
	QPushButton *StartStopButton;

  private slots:
	void TranslatePixelID(int);
	void UpdateScope(int);
	void KeepCurrent();
	void StartStop(bool);
	void ShowPixelDisplay();
	void SetPixelData(QVector<double>);
	void OpenDataFile();

  public:
	TP_DAQ(bool);	
	~TP_DAQ();
	
	EventScope *Scope;
 	QSpinBox *Channel, *Chip, *Board, *PixelID, *Event;
    QPlainTextEdit *RunHeaderDisplay, *EventHeaderDisplay;
	QLineEdit *FilenameBox;
};

class TP_Evidence: public QWidget {
  Q_OBJECT

  private slots:
	void ToggleAlarm(bool);
	void StartDIMBrowser();
	void StartELog();

  public:
	TP_Evidence();	
};


// Main window class
class GUI: public QMainWindow, public DimBrowser {
  Q_OBJECT

  private:
    QTabWidget *TabWidget;
            
    void closeEvent(QCloseEvent *);
	
  public:
    GUI();
    
  private slots:
    void MenuAbout();
    void MenuNewHistory();
    void MenuRawDataBrowser();
	void DetachTab(int, bool=false);
	void CheckAlarm();
};

#endif
