#include "atmega_adc.h"
#include "typedefs.h"

void atmega_adc_init(void)
{
//ADC einschalten
	ADCSRA |= (1<<ADPS2) | (1<<ADPS1);     // ADC_clk = 125kHz
	ADCSRA &= ~(1<<ADPS0);
		// normal conversion takes: 13 adc_clk cycles = 104us
		// 1st conversion takes longer: 25 clk cycles = 200us
	ADCSRA |= 1<<ADATE; // autotrigger enable
	SFIOR &= ~(0xE0);		//ADTS=000 --> free running mode 
	ADCSRA |= (1<<ADEN);                  // ADC aktivieren

	ADMUX &= ~(1<<REFS0); 
	ADMUX &= ~(1<<REFS1); 	//REFS = 00 --> use external reference voltage.
	//ADMUX |= 1<<ADLAR;		//ADLAR =1 	--> left adjust ac result in ADCH register --> 8bit resolution only.				
	ADMUX |= (0x1F & 0x06); //MUX = 0x06 --> Pin ADC6 = PA6 is used as ADC input pin.
	
	ADCSRA |= (1<<ADSC); 	// start 1st conversion

}
