
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
USE ieee.std_logic_unsigned.all;

ENTITY w5300_interface_tester IS
   PORT( 
   		clk    : IN     std_logic;


      -- interface to W5300 chip ports:
	  cs        : IN     std_logic;
	  rd        : IN     std_logic;
	  wiz_addr  : IN     std_logic_vector (9 DOWNTO 0);
	  wiz_data  : INOUT  std_logic_vector (15 DOWNTO 0);
	  wiz_reset : IN     std_logic;
	  wr        : IN     std_logic;
	  int       : OUT    std_logic;
      
      
      data_o    : IN     std_logic_vector (15 DOWNTO 0);
      addr_i    : OUT    std_logic_vector (9 DOWNTO 0);
      data_i    : OUT    std_logic_vector (15 DOWNTO 0);
      read_i    : OUT    std_logic;
      ready_o			: IN 			std_logic;
      write_i   : OUT    std_logic

   );

-- Declarations

END w5300_interface_tester ;

--
ARCHITECTURE beha OF w5300_interface_tester IS
	type state_t is (
	PRESTART,
	WRITE_TEST, WRITING,
	READ_TEST, READING
	--FINAL
	);

	signal state : state_t;
	
	signal write : std_logic;
	signal read : std_logic;
	
BEGIN

	write_i <= write;
	read_i <= read;
	wiz_data <= X"1234";
	
	process(clk)
		begin
			
			if rising_edge(clk) then
				case state is
				when 	PRESTART =>
					read <= '0';
					write <= '0';
					if (ready_o = '1') then
						state <= WRITE_TEST;
					end if;
				
				when WRITE_TEST =>
					if (ready_o = '1') then
	    					addr_i <= "0000111100";
	    					data_i <= X"ABCD";
	    					write <= '1';
	    					state <= WRITING;
					end if;					

				when WRITING =>
					if (ready_o = '0') then
						write <= '0';
						state <= READ_TEST;
					end if;
					
				when READ_TEST =>
					if (ready_o = '1') then
						addr_i <= "0100110101";
						read <= '1';
						state <= READING;
					end if;					
					
				when READING =>
					if (ready_o = '0') then
						read <= '0';
						state <= WRITE_TEST;
				end if;
	

				
	
				end case;
				
			end if; --clk
			
		end process;
	
END ARCHITECTURE beha;

