/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */


void MagicHillas(const char *filename="data/camera.root")
{
    //
    // This is a demonstration program which calculates the Hillas
    // parameter out of a Magic root file.

    //
    // Create a empty Parameter List and an empty Task List
    // The tasklist is identified in the eventloop by its name
    //
    MParList  plist;

    MTaskList tlist;
    plist.AddToList(&tlist);

    //
    // The geometry container must be created by yourself to make sure
    // that you don't choos a wrong geometry by chance
    //
    MGeomCamMagic geomcam;
    plist.AddToList(&geomcam);

    MPedestalCam pedest;
    plist.AddToList(&pedest);

    //
    // Now setup the tasks and tasklist:
    //
    //  1) read in the data from a magic root file   MReadTree
    //  2) calculate number of cerenkov photons      MCerPhotCalc
    //  3) clean the image                           MImgCleanStd
    //  4) calculate hillas                          MHillasCalc
    //  5) fill the hillas into the histograms       MFillH
    //

    //
    // The first argument is the tree you want to read.
    //   Events:     Cosmic ray events
    //   PedEvents:  Pedestal Events
    //   CalEvents:  Calibration Events
    //
    MReadTree read("Events", filename);
    MReadMarsFile  readhead("Events",filename);
    // read.AddFile("data/cer000019.root");

    MMcPedestalCopy pedestals;
    MMcPedestalNSB pedNSB;
    MCerPhotCalc ncalc;
    MImgCleanStd clean;
    MHillasCalc  hcalc;
    MFillH       hfill("MHillas", "MHHillas");
    MFillH       sfill("MHillas", "MHStarMap");

    //
    // Crete and setup Tasklist
    //
    MWriteRootFile write("hillas.root");
    write.AddContainer("MHillas");
    write.AddContainer("MHStarMap");

    tlist.AddToList(&read);
    tlist.AddToList(&readhead);
    tlist.AddToList(&pedestals);
    tlist.AddToList(&pedNSB);
    tlist.AddToList(&ncalc);
    tlist.AddToList(&clean);
    tlist.AddToList(&hcalc);
    tlist.AddToList(&hfill);
    tlist.AddToList(&sfill);
    tlist.AddToList(&write);

    //
    // Create and setup the eventloop
    //
    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    //
    // Execute your analysis
    //
    if (!evtloop.Eventloop())
        return;
    tlist.PrintStatistics();

    //
    // After the analysis is finished we can display the histograms
    //
    plist.FindObject("MHHillas")->DrawClone();
    plist.FindObject("MHStarMap")->DrawClone();
}
