#ifndef MMCRUNHEADER_H
#define MMCRUNHEADER_H
///////////////////////////////////////////////////////////////////////
//                                                                   //
// MRunHeader                                                        //
//                                                                   //
///////////////////////////////////////////////////////////////////////

#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif


class MMcRunHeader : public MParContainer
{
private:
    /* ---- Run Header Informations ---- */
    UInt_t  fNumTrigCond;     // Number of trigger conditions in this file,
                              // zero means single condition mode

    //-- 0 means: MMcTrig
    //-- 1 means: MMcTrig;1
    //-- 2 means: MMcTrig;1 MMcTrig;2

    Byte_t  fAllEvtsTriggered;  // boolean that indicates is all images are 
                                // saved or only the ones that trigger

    Byte_t  fMcEvt;           // McEvt stored or not
    Byte_t  fMcTrig;          // McTrig stored or not
    Byte_t  fMcFadc;          // McFadc stored or not

    Int_t   fNumAnalisedPixels;  // Number of analised pixels

    UInt_t  fNumSimulatedShowers; // Number of showers that were simualted
    UInt_t  fNumStoredShowers;    // Number of store showers in this run

    //  Coordinates of the Starfield

    Int_t fStarFieldRaH;
    Int_t fStarFieldRaM;
    Int_t fStarFieldRaS;
    Int_t fStarFieldDeD;
    Int_t fStarFieldDeM;
    Int_t fStarFieldDeS;

    Float_t fNumPheFromDNSB;  // Number of phe/ns from diffuse NSB

    //  Telescope axis position (zenith and azimutal angle)
    Float_t fTelesTheta;  // >180 (200) means for each shower,
                          // the Theta of shower
    Float_t fTelesPhi;    // > 360 (400) means for each shower,
                          // the Phi of shower

    //  Angular distanve from the source position to the camera center
    Float_t fSourceOffsetTheta; 
    Float_t fSourceOffsetPhi;

    //  Angular range used in the Corsika showers generation (degrees)
    Float_t fShowerThetaMax;
    Float_t fShowerThetaMin;
    Float_t fShowerPhiMax;
    Float_t fShowerPhiMin;

    UShort_t fCorsikaVersion;
    UShort_t fReflVersion;
    UShort_t fCamVersion;

public:
    MMcRunHeader(const char *name=NULL, const char *title=NULL);
    ~MMcRunHeader();

    void Fill(const UInt_t numtrigcond,
	 const Byte_t fallevts,
	 const Byte_t fmcevt,
	 const Byte_t fmctrig,
	 const Byte_t fmcfadc,
	 const Int_t  fnumanalpixels,
	 const UInt_t fnumsim,
	 const UInt_t fnumsto,
	 const Int_t fsfRaH,
	 const Int_t fsfRaM,
	 const Int_t fsfRaS,
	 const Int_t fsfDeD,
	 const Int_t fsfDeM,
	 const Int_t fsfDeS,
	 const Float_t fnumdnsb,
	 const Float_t ftelestheta,
	 const Float_t ftelesphi,
	 const Float_t fsofftheta,
	 const Float_t fsoffphi,
	 const Float_t fshthetamax,
	 const Float_t fshthetamin,
	 const Float_t fshphimax,
	 const Float_t fshphimin,
	 const UInt_t fcorsika,
	 const UInt_t frefl,
	 const UInt_t fcam
	);

    Float_t GetNumPheFromDNSB() { return fNumPheFromDNSB; }

    ClassDef(MMcRunHeader, 1)	// storage container for general info
};
#endif


