#ifndef FACT_MainWindow
#define FACT_MainWindow

#include "design.h"

#include <QMainWindow>

class TObject;
class TCanvas;

class MainWindow : public QMainWindow, protected Ui::MainWindow
{
    Q_OBJECT;

    void MakeLEDs(QPushButton **arr, QGridLayout *lay, const char *slot) const;

    void SelectTab(const QString &name);
    void SetTriggerSequence();
    void SetTriggerCoincidence();
    void SetCalibCoincidence();

protected:
    QPushButton *fFtuLED[40];
    QPushButton *fFadLED[40];

    bool fInHandler;

public:
    MainWindow(QWidget *p=0);

private slots:
    // System status
    void on_fShutdown_clicked();
    void on_fShutdownAll_clicked();

    // Status LEDs signals
    void on_fStatusFTULed_clicked();
    void on_fStatusFTMLed_clicked();
    void on_fStatusFADLed_clicked();
    void on_fStatusLoggerLed_clicked();
    void on_fStatusChatLed_clicked();
    //void on_fStatusFTMEnable_stateChanged(int state);

    // Tab Widget
    void on_fTabWidget_tabCloseRequested(int which);
    virtual void on_fTabWidget_currentChanged(int) { }

    // Tab: FTM
    void on_fEnableTrigger_stateChanged(int);
    void on_fEnableExt1_stateChanged(int);
    void on_fEnableExt2_stateChanged(int);
    void on_fEnableClockCond_stateChanged(int);
    void on_fEnableVeto_stateChanged(int);

    void on_fTriggerSeqPed_valueChanged(int)   { SetTriggerSequence(); }
    void on_fTriggerSeqLPint_valueChanged(int) { SetTriggerSequence(); }
    void on_fTriggerSeqLPext_valueChanged(int) { SetTriggerSequence(); }

    void on_fPhysicsCoincidence_valueChanged(int);
    void on_fPhysicsWindow_valueChanged(int);
    void on_fCalibCoincidence_valueChanged(int);
    void on_fCalibWindow_valueChanged(int);

    void on_fTriggerInterval_valueChanged(int);
    void on_fTriggerDelay_valueChanged(int);
    void on_fTimeMarkerDelay_valueChanged(int);
    void on_fDeadTime_valueChanged(int);

    void on_fClockCondR0_valueChanged(int) { }
    void on_fClockCondR1_valueChanged(int) { }
    void on_fClockCondR8_valueChanged(int) { }
    void on_fClockCondR9_valueChanged(int) { }
    void on_fClockCondR11_valueChanged(int) { }
    void on_fClockCondR13_valueChanged(int) { }
    void on_fClockCondR14_valueChanged(int) { }
    void on_fClockCondR15_valueChanged(int) { }

    void on_fPrescalingVal_valueChanged(int);

    // Tab: FTUs
    void slot_fFtuLED_clicked();
    void on_fFtuPing_toggled(bool);
    void on_fFtuAllOn_clicked();
    void on_fFtuAllOff_clicked();

    // Tab: Rates
    virtual void on_fPixelEnable_stateChanged(int) { }
    virtual void on_fThresholdVal_valueChanged(int) { }
    virtual void on_fThresholdIdx_valueChanged(int) { }
    virtual void on_fThresholdCrate_valueChanged(int) { }
    virtual void on_fThresholdBoard_valueChanged(int) { }
    virtual void on_fThresholdPatch_valueChanged(int) { }
    virtual void on_fPixelIdx_valueChanged(int) { }

    void on_fPixelEnableAll_clicked();
    void on_fPixelDisableAll_clicked();

    virtual void on_fPixelDisableOthers_clicked() { }
    virtual void on_fThresholdDisableOthers_clicked() { }

    virtual void on_fRatePatch1_valueChanged(int) { }
    virtual void on_fRatePatch2_valueChanged(int) { }
    virtual void on_fRateBoard1_valueChanged(int) { }
    virtual void on_fRateBoard2_valueChanged(int) { }

    // Tab: FADs
    void slot_fFadLED_clicked() { }

    // Tab: Chat
    void on_fChatSend_clicked();

    // Tab: Commands
    /// Needs access to DimNetwork thus it is implemented in the derived class
    virtual void on_fDimCmdSend_clicked() { }

    // Main menu
    //    void on_fMenuLogSaveAs_triggered(bool)

    virtual void slot_RootEventProcessed(TObject *, unsigned int, TCanvas *) { }
    virtual void slot_RootUpdate() { }

    void slot_TimeUpdate();
};

#endif
