//simple test program to check the PixelMap class

#include "../../pixelmap/PixelMap.h"
#include <iostream>

int main(){

    std::cout << std::endl;
    std::cout << "==============================" << std::endl;
    std::cout << "PixelMap Test Program" << std::endl;
    std::cout << "==============================" << std::endl;
    std::cout << std::endl;

    PixelMap* pm = new PixelMap();

    pm->Print();

    std::string drs1 = pm->DRS_to_Pixel(0,0,0);
    std::cout << "Name: " << drs1 << std::endl;

    std::string drs2 = pm->DRS_to_Pixel(1,0,0);
    std::cout << "Name: " << drs2 << std::endl;

    std::string hv1 = pm->HV_to_Pixel(6,1,8);
    std::cout << "Name: " << hv1 << std::endl;

    std::string hv2 = pm->HV_to_Pixel(1,0,0);
    std::cout << "Name: " << hv2 << std::endl;

    unsigned int drsb1 = pm->Pixel_to_DRSboard("0-1-1");
    std::cout << "Board: " << drsb1 << std::endl;

    unsigned int drsb2 = pm->Pixel_to_DRSboard("1-0-0");
    std::cout << "Board: " << drsb2 << std::endl;

    unsigned int hvchain1 = pm->Pixel_to_HVchain("0-1-1");
    std::cout << "Chain: " << hvchain1 << std::endl;

    unsigned int hvchain2 = pm->Pixel_to_HVchain("1-0-0");
    std::cout << "Chain: " << hvchain2 << std::endl;

    delete pm;

    return 0;

}
