/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 <mailto:tbretz@uni-sw.gwdg.de>
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */


void readMagic()
{
    MParList plist;

    MGeomCamMagic geomcam;
    MPedestalCam  pedest;
    MHillas       hillas;
    MTaskList     tlist;

    plist.AddToList(&geomcam);
    plist.AddToList(&pedest);
    plist.AddToList(&hillas);
    plist.AddToList(&tlist);

    MReadMarsFile   read("Events", "~/data/camera.root");
    MMcPedestalCopy pcopy;
    MMcPedestalNSB  pnsb;
    MCerPhotCalc    ncalc;
    MClone          clone("MCerPhotEvt");
    MImgCleanStd    clean;
    MHillasCalc     hcalc;

    tlist.AddToList(&read);
    tlist.AddToList(&pcopy);
    tlist.AddToList(&pnsb);
    tlist.AddToList(&ncalc);
    tlist.AddToList(&clone);
    tlist.AddToList(&clean);
    tlist.AddToList(&hcalc);

    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    if (!evtloop.PreProcess())
        return;

    MCamDisplay display(&geomcam);
    display.Draw();

    while (tlist.Process())
    {
        cout << "Event #" << read.GetEventNum() ":" << endl;

        display.DrawPhotNum((MCerPhotEvt*)clone.GetClone());
        gClient->HandleInput();
        if(getchar()=='q')
            break;

        hillas.Print();
	hillas.Draw();

        display.DrawPhotNum((MCerPhotEvt*)plist.FindObject("MCerPhotEvt"));

        gClient->HandleInput();
        if(getchar()=='q')
	break;
    } 

    evtloop.PostProcess();

}
